<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="fileFormatPageTitle@loadBean@servletRequest"/> 
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadFileFormat"/>

          <uix:pageLayout titleBinding="TITLE_FILE_FORMAT@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="messages@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>

              <uix:header textBinding="TABLE_NAME@loadBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:styledText
                          styleClass="OraInstructionText"
                          textBinding="TABLE_NAME_INSTR@loadBundle@servletRequest"/>
                      <uix:labeledFieldLayout width="75%">
                        <uix:contents>
                          <uix:messageLovField
                              id="loadTable"
                              name="loadTable"
                              promptBinding="TABLE_NAME@loadBundle@servletRequest"
                              textBinding="loadTable@loadBean@servletRequest"
                              columns="60"
                              messageBinding="(TABLE_NAME@loadBundle@servletRequest)@messages@servletRequest"
                              messageTypeBinding="(TABLE_NAME@loadBundle@servletRequest)@messageTypes@servletRequest"
                              searchDescBinding="CLICK_TO_SELECT_TABLE@loadBundle@servletRequest"
                              onClick="startLov('loadTable','ListSchemaTable')">
                            <uix:end>
                              <uix:submitButton
                                  name="event"
                                  value="createNewTable"
                                  shortDescBinding="CREATE_NEW_TABLE@loadBundle@servletRequest"
                                  textBinding="CREATE_NEW_TABLE@loadBundle@servletRequest"/>
                            </uix:end>
                          </uix:messageLovField>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>

              <uix:header textBinding="DATA_FILE_FORMAT@loadBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <oem:radioButton
                          name="dataFileFormat"
                          selectedValueBinding="dataFileFormat@loadBean@servletRequest"
                          selected="true"
                          textBinding="CHARACTER_DELIMITED@loadBundle@servletRequest"
                          value="CHARACTER_DELIMITED"/>
                      <oem:radioButton
                          name="dataFileFormat"
                          selectedValueBinding="dataFileFormat@loadBean@servletRequest"
                          selected="false"
                          textBinding="FIXED_LENGTH@loadBundle@servletRequest"
                          value="FIXED_LENGTH"/>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>

              <uix:header textBinding="PREVIEW_CONTENTS@loadBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:flowLayout>
                        <uix:contents>
                          <uix:switcher childNameBinding="dataFileLocation@loadBean@servletRequest">
                            <uix:case name="DATA_FILE_LOCATED_ON_TARGET">
                              <uix:messagePrompt
                                  promptBinding="DATA_FILE_ON_TARGET_RESULT@loadBundle@servletRequest"/>
                            </uix:case>
                            <uix:case name="DATA_FILE_LOCATED_ON_BROWSER">
                              <uix:messagePrompt
                                  promptBinding="DATA_FILE_ON_TARGET_RESULT_COPY@loadBundle@servletRequest"/>
                            </uix:case>
                          </uix:switcher>
                          <uix:spacer width="10"/>
                          <uix:styledText
                             styleClass="OraDataText"
                             textBinding="dataFile@loadBean@servletRequest"/>
                        </uix:contents>
                      </uix:flowLayout>
                      <uix:textInput
                          shortDescBinding="PREVIEW_CONTENTS@loadBundle@servletRequest"
                          columns="120" rows="8" readOnly="true"
                          textBinding="previewData@loadBean@servletRequest"/>
                      <uix:tip>
                        <uix:contents>
                          <uix:styledText
                              styleClass="OraTipText"
                              textBinding="PREVIEW_CONTENTS_TIP@loadBundle@servletRequest"/>
                        </uix:contents>
                      </uix:tip>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>

            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="loadForm"
                    maxValueBinding="navMaxValue@loadBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@loadBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
