<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="filesPageTitle@loadBean@servletRequest"/> 
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form 
            name="loadForm" 
            destination="/console/database/data/load" 
            method="post" 
            usesUpload="true"
            copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadFiles"/>

          <uix:pageLayout titleBinding="TITLE_FILES@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="messages@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>

                  <uix:radioButton
                      name="dataFileLocation"
                      selectedValueBinding="dataFileLocation@loadBean@servletRequest"
                      textBinding="DATA_FILE_LOCATED_ON_TARGET@loadBundle@servletRequest"
                      value="DATA_FILE_LOCATED_ON_TARGET"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/>
                      <uix:labeledFieldLayout labelWidth="20%">
                        <uix:contents>
                          <uix:messageLovField
                              id="dataFileOnServer"
                              name="dataFileOnServer"
                              promptBinding="DATA_FILE_ON_TARGET@loadBundle@servletRequest"
                              textBinding="dataFileOnServer@loadBean@servletRequest"
                              columns="80"
                              tipBinding="FILES_DATA_FILE_TIP_ON_TARGET@loadBundle@servletRequest"
                              searchDescBinding="CLICK_TO_SELECT_DATA_FILE@loadBundle@servletRequest"
                              messageBinding="(DATA_FILE_ON_TARGET@loadBundle@servletRequest)@messages@servletRequest"
                              messageTypeBinding="(DATA_FILE_ON_TARGET@loadBundle@servletRequest)@messageTypes@servletRequest"
                              onClick="startFileBrowser('dataFileOnServer')"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:contents>
                  </uix:rowLayout>

                  <uix:radioButton
                      name="dataFileLocation"
                      selectedValueBinding="dataFileLocation@loadBean@servletRequest"
                      textBinding="DATA_FILE_LOCATED_ON_BROWSER@loadBundle@servletRequest"
                      value="DATA_FILE_LOCATED_ON_BROWSER"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="FILES_DATA_FILE_UPLOAD_TIP@loadBundle@servletRequest"/>
                          <uix:labeledFieldLayout labelWidth="20%">
                            <uix:contents>
                              <uix:messageFileUpload
                                  id="dataFileOnBrowser"
                                  name="dataFileOnBrowser"
                                  promptBinding="DATA_FILE_ON_BROWSER@loadBundle@servletRequest"
                                  columns="80"
                                  tipBinding="FILES_DATA_FILE_TIP_ON_BROWSER@loadBundle@servletRequest"
                                  messageBinding="(DATA_FILE_ON_BROWSER@loadBundle@servletRequest)@messages@servletRequest"
                                  messageTypeBinding="(DATA_FILE_ON_BROWSER@loadBundle@servletRequest)@messageTypes@servletRequest"/>
                              <uix:messageLovField
                                  id="defaultTargetDir"
                                  name="defaultTargetDir"
                                  promptBinding="DEFAULT_DIR_ON_TARGET@loadBundle@servletRequest"
                                  textBinding="defaultTargetDir@loadBean@servletRequest"
                                  columns="80"
                                  tipBinding="FILES_DEFAULT_DIR_TIP_ON_TARGET@loadBundle@servletRequest"
                                  searchDescBinding="CLICK_TO_SELECT_DEFAULT_DIR@loadBundle@servletRequest"
                                  messageBinding="(DEFAULT_DIR_ON_TARGET@loadBundle@servletRequest)@messages@servletRequest"
                                  messageTypeBinding="(DEFAULT_DIR_ON_TARGET@loadBundle@servletRequest)@messageTypes@servletRequest"
                                  onClick="startDirectoryBrowser('defaultTargetDir')"/>
                              <uix:styledText styleClass="OraInlineInfoText" text=""/>
                              <uix:tip>
                                <uix:contents>
                                  <uix:styledText
                                      styleClass="OraTipText"
                                      textBinding="FILES_DATA_FILE_UPLOAD_DELAY_TIP@loadBundle@servletRequest"/>
                                </uix:contents>
                              </uix:tip>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>

                </uix:contents>
              </uix:stackLayout>

            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="loadForm"
                    maxValueBinding="navMaxValue@loadBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@loadBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
