<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="loadMethodPageTitle@loadBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadMethod"/>

          <uix:pageLayout titleBinding="TITLE_LOAD_METHOD@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="LOAD_METHOD@loadBundle@servletRequest"> --%>
              <uix:tableLayout cellSpacing="5">
                <uix:contents>

                  <uix:stackLayout>
                    <uix:contents>
                      <oem:radioButton
                                name="loadType"
                                selectedValueBinding="loadType@loadBean@servletRequest"
                                selected="true"
                                textBinding="CONVENTIONAL_PATH@loadBundle@servletRequest"
                                value="CONVENTIONAL"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="LOAD_CONVENTIONAL_PATH@loadBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                      <oem:radioButton
                                name="loadType"
                                selectedValueBinding="loadType@loadBean@servletRequest"
                                selected="false"
                                textBinding="DIRECT_PATH@loadBundle@servletRequest"
                                value="DIRECT"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="LOAD_DIRECT_PATH@loadBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                      <oem:radioButton
                                name="loadType"
                                selectedValueBinding="loadType@loadBean@servletRequest"
                                selected="false"
                                textBinding="PARALLEL_DIRECT_PATH@loadBundle@servletRequest"
                                value="PARALLEL_DIRECT"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="LOAD_PARALLEL_DIRECT_PATH@loadBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:stackLayout>

                </uix:contents>
              </uix:tableLayout>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="loadForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="loadForm"
                    maxValueBinding="navMaxValue@loadBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@loadBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
