<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="summaryPageTitle@loadBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadReview"/>

          <uix:pageLayout titleBinding="TITLE_SUMMARY@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>
      
            <%-- <uix:header textBinding="REVIEW@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>
                  <uix:switcher childNameBinding="createControlFile@loadBean@servletRequest">
                    <uix:case name="true">
                      <uix:labeledFieldLayout labelWidth="40%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="DATA_FILE@loadBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryDataFile@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="CONTROL_FILE@loadBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="controlFile@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLogFile@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOAD_METHOD@loadBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLoadType@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryFailJobs@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryScheduleType@loadBean@servletRequest"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:labeledFieldLayout labelWidth="40%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="CONTROL_FILE@loadBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="controlFile@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="DATA_FILE@loadBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryDataFile@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLogFile@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOAD_METHOD@loadBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLoadType@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryFailJobs@loadBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryScheduleType@loadBean@servletRequest"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:case>
                  </uix:switcher>

                  <uix:hideShow disclosedBinding="showParameters@loadBean@servletRequest"
                                formSubmitted="true" id="hideShow"
                                disclosedTextBinding="HIDE_PARAMETERS@exportBundle@servletRequest"
                                undisclosedTextBinding="SHOW_PARAMETERS@exportBundle@servletRequest">
                    <uix:contents>
                      <uix:messagePrompt labeledNodeId="parameterCommand" promptBinding="SUMMARY_PARAMETERS@loadBundle@servletRequest"/>
                      <uix:textInput name="parameterCommand" id="parameterCommand" rows="10" 
                          textBinding="parameterCommand@loadBean@servletRequest" columns="100"
                          readOnly="true"/>
                    </uix:contents>
                  </uix:hideShow>

                  <uix:separator/>

                  <uix:switcher childNameBinding="createControlFile@loadBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:submitButton formName="loadForm" 
                            shortDescBinding="CONTROL_FILE_CONTENTS@loadBundle@servletRequest" 
                            textBinding="CONTROL_FILE_CONTENTS@loadBundle@servletRequest" 
                            name="event" value="controlFileContents"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton formName="loadForm" 
                            shortDescBinding="REVIEW_FILE_OPTIONS@loadBundle@servletRequest" 
                            textBinding="REVIEW_FILE_OPTIONS@loadBundle@servletRequest" 
                            name="event" value="reviewFileOptions"/>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:stackLayout>
            <%-- </uix:header> --%>

            <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                  <uix:contents>
                    <uix:navigationBar
                      name="ctNav"
                      blockSize="-1"
                      formSubmitted="true"
                      formName="loadForm"
                      maxValueBinding="navMaxValue@loadBean@servletRequest"
                      minValue="1"
                      valueBinding="navValue@loadBean@servletRequest"/>
                  </uix:contents>
                  <uix:submitButton shortDescBinding="SUBMIT_JOB@exportBundle@servletRequest" formName="loadForm" textBinding="SUBMIT_JOB@exportBundle@servletRequest" name="event" value="submit"/>
                </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
