<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="controlFileTypePageTitle@loadBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">

          <uix:formValue name="pageName" value="/database/data/loadType"/>    

          <uix:pageLayout titleBinding="TITLE_CONTROL_FILE_TYPE@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>			
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>			

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>

                      <%-- radio button --%>
                      <uix:rowLayout>
                        <uix:contents>
                         <oem:radioButton
                                    name="controlFileType"
                                    selectedValueBinding="controlFileType@loadBean@servletRequest"
                                    selected="true"
                                    textBinding="CREATE_CONTROL_FILE@loadBundle@servletRequest"
                                    value="CREATE_CONTROL_FILE"/>
                        </uix:contents>
                      </uix:rowLayout>

                      <%-- tip for radio button --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="CREATE_CONTROL_FILE_TIP@loadBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>

                      <%-- radio button --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <oem:radioButton
                                    name="controlFileType"
                                    selectedValueBinding="controlFileType@loadBean@servletRequest"
                                    selected="false"
                                    textBinding="USE_EXISTING_CONTROL_FILE@loadBundle@servletRequest"
                                    value="USE_EXISTING_CONTROL_FILE"/>
                        </uix:contents>
                      </uix:rowLayout>

                      <%-- tip for radio button --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="USE_EXISTING_CONTROL_FILE_TIP@loadBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>

                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:contents>

            <uix:header textBinding="HOST_CREDENTIALS@exportBundle@servletRequest">
              <uix:contents>
                <%@ include file="/credentials.jspf"%>
              </uix:contents>
            </uix:header>

            <uix:pageButtons> 
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="CONTINUE@DBObjectBundle@servletRequest" textBinding="CONTINUE@DBObjectBundle@servletRequest" formName="loadForm" name="event" value="continue"/>
                <uix:contents>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons> 

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
