<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
<uix:metaContainer> 
  <uix:head titleBinding="addFilePageTitle@monitorBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
   <uix:contents>
    <db:form name="monitorAddFileForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
      <uix:formValue name="pageName" value="/database/data/monitorAddFile"/>
      <uix:pageLayout titleBinding="addFileHeader@monitorBean@servletRequest">
      <%@ include file="/database/global.jspf" %>

<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

          <uix:stackLayout>
            <uix:labeledFieldLayout width="75%">
              <uix:messagePrompt labeledNodeId="fileDirectoryObject" promptBinding="FILE_DIRECTORY@exportBundle@servletRequest" />
              <uix:choice name="fileDirectoryObject" id="fileDirectoryObject"
                      selectedValueBinding="fileDirectoryObject@monitorBean@servletRequest">
                <uix:contents childDataBinding="allDirectoryObjects@monitorBean@servletRequest">
                  <uix:option textBinding="."/>
                </uix:contents>
              </uix:choice>
              <uix:messagePrompt labeledNodeId="dumpFileName" promptBinding="FILENAME@DBObjectBundle@servletRequest" />
              <uix:textInput name="dumpFileName" id="dumpFileName"
                      textBinding="dumpFileName@monitorBean@servletRequest" 
                      columns="32"/>
              <uix:messagePrompt promptBinding="FILE_SIZE@monitorBundle@servletRequest"/>
              <uix:radioButton
                    name="autoExtendible"
                    selected="true"
                    textBinding="AUTO_EXTEND@DBObjectBundle@servletRequest"
                    value="true"
                    selectedValueBinding="autoExtendible@monitorBean@servletRequest"/>
                <uix:messagePrompt prompt=""/>
                <uix:rowLayout>
                  <uix:radioButton
                        name="autoExtendible"
                        selected="false"
                        textBinding="FIXED_FILE_SIZE@monitorBundle@servletRequest"
                        value="false"
                        selectedValueBinding="autoExtendible@monitorBean@servletRequest"/>
                  <uix:textInput name="fileSize"
                      textBinding="fileSize@monitorBean@servletRequest"
                      shortDescBinding="FIXED_FILE_SIZE@monitorBundle@servletRequest"
                      text="" columns="16"/>
              </uix:rowLayout>
            </uix:labeledFieldLayout>                
          </uix:stackLayout>
  
          <uix:pageButtons>
              <uix:pageButtonBar>
              <uix:contents>         
                <uix:submitButton shortDescBinding="CANCEL@DBObjectBundle@servletRequest" formName="monitorAddFileForm" textBinding="CANCEL@DBObjectBundle@servletRequest" name="event" value="addFileCancel"/>
                <uix:submitButton shortDescBinding="OK@DBObjectBundle@servletRequest" formName="monitorAddFileForm" textBinding="OK@DBObjectBundle@servletRequest" name="event" value="addFileOK"/>
              </uix:contents>
            </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
	</uix:contents>
  </uix:body>

</uix:document> 
</uix:renderingContext> 
