<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer> 
      <uix:head titleBinding="changeJobStatePageTitle@monitorBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="monitorForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/monitorChangeJobState"/>

          <uix:pageLayout titleBinding="CHANGE_JOB_STATE_TITLE@monitorBundle@servletRequest">
      <%@ include file="/database/global.jspf" %>
<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
         
            <uix:stackLayout>
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer width="20"/> 

                    <uix:stackLayout>

                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" textBinding="JOB_EDIT_TEXT@monitorBundle@servletRequest"/>

                        <oem:radioButton
                                name="jobAction"
                                selectedValueBinding="jobAction@monitorBean@servletRequest"
                                renderedBinding="canSuspendJob@monitorBean@servletRequest"
                                textBinding="JOB_SUSPEND@monitorBundle@servletRequest"
                                value="SUSPEND"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" 
                                  renderedBinding="canSuspendJob@monitorBean@servletRequest"
                                  textBinding="JOB_SUSPEND_TEXT@monitorBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                        <oem:radioButton
                                name="jobAction"
                                selectedValueBinding="jobAction@monitorBean@servletRequest"
                                textBinding="JOB_STOP@monitorBundle@servletRequest"
                                renderedBinding="canStopJob@monitorBean@servletRequest"
                                value="STOP"/>
                          <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" 
                                  renderedBinding="canStopJob@monitorBean@servletRequest"
                                  textBinding="JOB_STOP_TEXT@monitorBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                        <oem:radioButton
                                name="jobAction"
                                selectedValueBinding="jobAction@monitorBean@servletRequest"
                                textBinding="JOB_RESUME@monitorBundle@servletRequest"
                                renderedBinding="canResumeJob@monitorBean@servletRequest"                                
                                value="RESUME"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" 
                                  renderedBinding="canResumeJob@monitorBean@servletRequest"                                
                                  textBinding="JOB_RESUME_TEXT@monitorBundle@servletRequest"/>
                                <uix:checkBox textBinding="JOB_SKIP_CREATION@monitorBundle@servletRequest" name="jobSkipCreation" 
                                  renderedBinding="canSkipJobCreation@monitorBean@servletRequest"
                                  checkedBinding="jobSkipCreation@monitorBean@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton shortDescBinding="CANCEL@DBObjectBundle@servletRequest" formName="monitorForm" textBinding="CANCEL@DBObjectBundle@servletRequest" name="event" value="changeJobStateCancel"/>
                <uix:submitButton shortDescBinding="OK@DBObjectBundle@servletRequest" formName="monitorForm" textBinding="OK@DBObjectBundle@servletRequest" name="event" value="changeJobStateOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
