<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
<uix:metaContainer> 
  <uix:head titleBinding="changeParallelismPageTitle@monitorBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
   <uix:contents>
    <db:form name="monitorChangeParallelismForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
      <uix:formValue name="pageName" value="/database/data/monitorChangeParallelism"/>
      <uix:pageLayout titleBinding="changeParallelismPageTitle@monitorBean@servletRequest">
      <%@ include file="/database/global.jspf" %>

<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

          <uix:stackLayout>
            <uix:rowLayout > 
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText" textBinding="PARALLELISM_TEXT@monitorBundle@servletRequest"/>
              </uix:contents>
            </uix:rowLayout> 
            <uix:rowLayout >                 
              <uix:contents>
                <uix:labeledFieldLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionText" labeledNodeId="parallelism" 
                        textBinding="PARALLELISM@exportBundle@servletRequest"/>
                    <uix:textInput name="parallelism" id="parallelism" 
                        textBinding="parallelism@monitorBean@servletRequest"
                        text="" columns="16">
                      <uix:onSubmitValidater>
                        <uix:decimal maxScale="0"/>
                      </uix:onSubmitValidater>
                    </uix:textInput>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:contents>
            </uix:rowLayout>
          </uix:stackLayout>
  
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:contents>         
              <uix:submitButton
                  formName="monitorChangeParallelismForm"
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                  textBinding="CANCEL@DBObjectBundle@servletRequest"
                  name="event"
                  value="changeParallelismCancel"/>
              <uix:submitButton
                  formName="monitorChangeParallelismForm"
                  shortDescBinding="OK@DBObjectBundle@servletRequest"
                  textBinding="OK@DBObjectBundle@servletRequest"
                  name="event"
                  value="changeParallelismOK"/>
            </uix:contents>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
	</uix:contents>
  </uix:body>

</uix:document> 
</uix:renderingContext> 
