<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer> 
      <uix:head titleBinding="changeJobStatePageTitle@monitorBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="monitorForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/monitorConfirmStop"/>

          <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>
<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
         
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="confirmStopText@monitorBean@servletRequest"/>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer width="20"/> 
                      <uix:styledText
                        styleClass="OraInlineInfoText" 
                        textBinding="JOB_STOP_CONFIRMATION_TEXT@monitorBundle@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    shortDescBinding="NO@DBObjectBundle@servletRequest"
                    formName="monitorForm"
                    textBinding="NO@DBObjectBundle@servletRequest"
                    name="event"
                    value="confirmStopCancel"/>
                <uix:submitButton
                    shortDescBinding="YES@DBObjectBundle@servletRequest"
                    formName="monitorForm"
                    textBinding="YES@DBObjectBundle@servletRequest"
                    name="event"
                    value="confirmStopOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
