<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
<uix:metaContainer> 
  <uix:head titleBinding="viewLogTitle@monitorBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
   <uix:contents>
    <db:form name="monitorHostCredentialsForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
      <uix:formValue name="pageName" value="/database/data/monitorHostCredentials"/>
      <uix:pageLayout titleBinding="viewLogHeader@monitorBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

<uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

        <uix:header textBinding="HOST_CREDENTIALS@exportBundle@servletRequest">
          <uix:contents>
            <%@ include file="/credentials.jspf"%>
          </uix:contents>
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:contents>
              <uix:submitButton
                  formName="monitorHostCredentialsForm"
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                  textBinding="CANCEL@DBObjectBundle@servletRequest"
                  name="event"
                  value="hostCredentialsCancel"/>
              <uix:submitButton
                  formName="monitorHostCredentialsForm"
                  shortDescBinding="OK@DBObjectBundle@servletRequest"
                  textBinding="OK@DBObjectBundle@servletRequest"
                  name="event"
                  value="hostCredentialsOK"/>
            </uix:contents>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
   </uix:contents>
  </uix:body>

</uix:document> 
</uix:renderingContext> 
