<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document>
  <%@ include file="/oemTitle.jspf" %> 
<uix:metaContainer>
  <uix:head titleBinding="monitorJobsTitle@monitorJobsBean@servletRequest"/>
</uix:metaContainer>

<uix:body>  
  <db:form name="monitorJobsForm" destination="/console/database/data/monitorJobs" method="post" copyParams="oname,otype,target,type,cancelURL">
    <uix:formValue name="pageName" value="/database/data/monitorJobs"/>
    <uix:pageLayout titleBinding="monitorJobsHeader@monitorJobsBean@servletRequest">
      <%@ include file="/database/global.jspf" %>
<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

      <uix:styledText styleClass="OraInstructionText" textBinding="MONITOR_JOBS_TEXT@monitorBundle@servletRequest"/>
          <oem:table name="monitorJobsTableUI"
                blockSize="10"
                beanKey="monitorJobsBean"
                destination="/console/database/data/monitorJobs"
                summaryBinding="DATAPUMP_JOBS@monitorBundle@servletRequest"
                formSubmitted="true"
                dataSourceProp="monitorJobsTableUI" width="100%"
                alternateTextBinding="NO_DATAPUMP_JOBS_EXIST@monitorBundle@servletRequest">

            <uix:tableSelection>
              <oem:singleSelection
                  shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                  selectedIndexBinding="selectedIndex@monitorJobsTableDS@monitorJobsBean@servletRequest">

                <uix:submitButton
                    shortDescBinding="DELETE_DATAPUMP_JOB@monitorBundle@servletRequest"
                    textBinding="DELETE_DATAPUMP_JOB@monitorBundle@servletRequest"
                    name="event"
                    value="deleteJob"/>

              </oem:singleSelection>
            </uix:tableSelection>

          </oem:table>

      <uix:pageButtons>
        <uix:pageButtonBar>
         <uix:submitButton
             formName="monitorJobsForm"
             shortDescBinding="OK@DBObjectBundle@servletRequest"
             textBinding="OK@DBObjectBundle@servletRequest"
             name="event"
             value="monitorCancel"/>
        </uix:pageButtonBar>
      </uix:pageButtons>
        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>
    </uix:pageLayout>
  </db:form>
</uix:body>

</uix:document> 
</uix:renderingContext> 
