<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer> 
      <uix:head titleBinding="deleteJobPageTitle@monitorJobsBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="monitorJobsForm" destination="/console/database/data/monitorJobs" method="post" copyParams="oname,otype,target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/monitorJobsConfirmDelete"/>

          <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>
<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
         
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="confirmDeleteText@monitorJobsBean@servletRequest"/>
                <uix:switcher childNameBinding="showDeleteHint@monitorJobsBean@servletRequest">
                  <uix:case name="true">
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:spacer width="20"/> 
                          <uix:styledText
                            styleClass="OraInlineInfoText" 
                            textBinding="EM_JOB_DELETE_HINT@monitorBundle@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>

              </uix:contents>
            </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    shortDescBinding="NO@DBObjectBundle@servletRequest"
                    formName="monitorJobsForm"
                    textBinding="NO@DBObjectBundle@servletRequest"
                    name="event"
                    value="confirmDeleteCancel"/>
                <uix:submitButton
                    shortDescBinding="YES@DBObjectBundle@servletRequest"
                    formName="monitorJobsForm"
                    textBinding="YES@DBObjectBundle@servletRequest"
                    name="event"
                    value="confirmDeleteOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
