<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document>
  <%@ include file="/oemTitle.jspf" %> 
<uix:metaContainer>
  <uix:head titleBinding="monitorPageTitle@monitorBean@servletRequest"/>
</uix:metaContainer>

<uix:body>  
  <db:form name="monitorForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
    <uix:formValue name="pageName" value="/database/data/monitorViewJob"/>
    <uix:pageLayout titleBinding="monitorHeader@monitorBean@servletRequest">
      <%@ include file="/database/global.jspf" %>

<uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

      <uix:switcher childNameBinding="handleValid@monitorBean@servletRequest">
        <uix:case name="true">
          <uix:stackLayout>
              <uix:labeledFieldLayout width="70%">
                <uix:styledText styleClass="OraInstructionText" textBinding="JOB_NAME@exportBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="jobName@monitorBean@servletRequest"/>

                <uix:styledText styleClass="OraInstructionText" textBinding="JOB_STATUS@monitorBundle@servletRequest"/>
                <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="jobState@monitorBean@servletRequest"/>
                    <uix:spacer width="10"/>
                    <uix:submitButton formName="monitorForm" 
                      renderedBinding="canChangeJobState@monitorBean@servletRequest"
                      shortDescBinding="CHANGE_JOB_STATE_BUTTON@monitorBundle@servletRequest"
                      textBinding="CHANGE_JOB_STATE_BUTTON@monitorBundle@servletRequest"
                      name="event" value="changeJobState"/>
                </uix:rowLayout>
                
                <uix:styledText styleClass="OraInstructionText" textBinding="PERCENT_DONE@monitorBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="percentDone@monitorBean@servletRequest"/>
                <uix:styledText styleClass="OraInlineInfoText" text=""/>                
                <uix:styledText styleClass="OraInlineInfoText" textBinding="JOB_PERCENT_DONE_INFO@monitorBundle@servletRequest"/>                

                <uix:styledText styleClass="OraInstructionText" textBinding="ERROR_COUNT@monitorBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="errorCount@monitorBean@servletRequest"/>

<%-- remove view log file until bug 4329180 is implemented
                <uix:styledText styleClass="OraInstructionText" textBinding="LOG_FILE@exportBundle@servletRequest"/>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="logFileDir@monitorBean@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="logFile@monitorBean@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton formName="monitorForm" 
                      renderedBinding="canViewLogFile@monitorBean@servletRequest"
                      shortDescBinding="VIEW_LOG_FILE@monitorBundle@servletRequest"
                      textBinding="VIEW_LOG_FILE@monitorBundle@servletRequest"
                      name="event" value="viewLogFile"/>
                  </uix:contents>
                </uix:rowLayout>
--%>

                <uix:styledText styleClass="OraInstructionText" textBinding="PARALLELISM_LABEL@exportBundle@servletRequest"/>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="parallelism@monitorBean@servletRequest"/>
                  <uix:spacer width="10"/>
                      <uix:submitButton formName="monitorForm" 
                        shortDescBinding="CHANGE_PARALLELISM@monitorBundle@servletRequest" 
                        textBinding="CHANGE_PARALLELISM@monitorBundle@servletRequest" 
                        renderedBinding="canChangeParallelism@monitorBean@servletRequest"
                        name="event" value="changeParallelism"/>
                </uix:rowLayout>
              </uix:labeledFieldLayout> 
          </uix:stackLayout>
        </uix:case>
      </uix:switcher>

      <uix:switcher childNameBinding="handleValid@monitorBean@servletRequest">
        <uix:case name="true">
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:header textBinding="threadTableHeader@monitorBean@servletRequest" size="1">
                <uix:styledText styleClass="OraInstructionText" textBinding="THREAD_TABLE_TEXT@monitorBundle@servletRequest"/>
                <oem:table name="monitorThreadsTableUI"
                      beanKey="monitorBean"
                      destination="/console/database/data/monitor"
                      formSubmitted="true"
                      summaryBinding="threadTableHeader@monitorBean@servletRequest"
                      dataSourceProp="monitorThreadsTableUI" width="100%">
                </oem:table>  		 
              </uix:header>
            </uix:rowLayout>	  
          </uix:tableLayout>
        </uix:case>
      </uix:switcher>

      <uix:switcher childNameBinding="handleValid@monitorBean@servletRequest">
        <uix:case name="true">
          <uix:header textBinding="fileTableHeader@monitorBean@servletRequest" size="1">          
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:submitButton formName="monitorForm"
                    renderedBinding="canAddFile@monitorBean@servletRequest"
                    shortDescBinding="ADD@DBObjectBundle@servletRequest" 
                    textBinding="ADD@DBObjectBundle@servletRequest" 
                    name="event" value="addFile"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <oem:table name="monitorFilesTableUI"
                      blockSize="10"
                      beanKey="monitorBean"
                      renderedBinding="networkOperation@monitorBean@servletRequest"
                      summaryBinding="fileTableHeader@monitorBean@servletRequest"
                      destination="/console/database/data/monitor"
                      formSubmitted="true"
                      dataSourceProp="monitorFilesTableUI" width="100%">
                </oem:table>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInlineInfoText" textBinding="FILE_PERCENT_DONE_INFO@monitorBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:case>
      </uix:switcher>

 
      <uix:pageButtons>
        <uix:pageButtonBar>
         <uix:submitButton
             formName="monitorForm"
             shortDescBinding="OK@DBObjectBundle@servletRequest"
             textBinding="OK@DBObjectBundle@servletRequest"
             name="event"
             value="viewDatapumpJobOK"/>
        </uix:pageButtonBar>
      </uix:pageButtons>
        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>
    </uix:pageLayout>
  </db:form>
</uix:body>

</uix:document> 
</uix:renderingContext> 
