<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
<uix:metaContainer> 
  <uix:head titleBinding="viewLogTitle@monitorBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
   <uix:contents>
    <db:form name="monitorViewLogForm" destination="/console/database/data/monitor" method="post" copyParams="oname,otype,target,type,cancelURL">
      <uix:formValue name="pageName" value="/database/data/monitorViewLog"/>
      <uix:pageLayout titleBinding="viewLogHeader@monitorBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

<uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

        <uix:stackLayout>
          <uix:labeledFieldLayout width="30%">
            <uix:styledText styleClass="OraInstructionText" textBinding="LOG_FILE@exportBundle@servletRequest"/>
            <uix:rowLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="logFileDir@monitorBean@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="logFile@monitorBean@servletRequest"/>
              </uix:contents>
            </uix:rowLayout>
          </uix:labeledFieldLayout> 
          <uix:messagePrompt labeledNodeId="logFileContents" promptBinding="LOG_FILE_CONTENTS@monitorBundle@servletRequest"/>
          <uix:textInput
              name="logFileContents"
              id="logFileContents"
              rows="50"
              shortDescBinding="LOG_FILE_CONTENTS@monitorBundle@servletRequest"
              textBinding="logFileContents@monitorBean@servletRequest"
              columns="100"
              readOnly="true"/>
        </uix:stackLayout>
  
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:contents>         
              <uix:submitButton
                  formName="monitorViewLogForm"
                  shortDescBinding="OK@DBObjectBundle@servletRequest"
                  textBinding="OK@DBObjectBundle@servletRequest"
                  name="event"
                  value="viewLogFileOK"/>
            </uix:contents>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
   </uix:contents>
  </uix:body>

</uix:document> 
</uix:renderingContext> 
