<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
  -- Transport Tablespaces lists 2 options.
  -- Generate a transportable tablespace set, uses export utility to generate a
  -- dump file.
  -- transport from an existing transportable tablespace set, plugs-in the 
  -- tablespaces on the target database.
--%> 
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
   <uix:bundle name="transportBundle"
              class="oracle.sysman.db.rsc.impexp.TransportMsg"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_TRANSPORTABLE_TABLESPACES@transportBundle"/>      
    </uix:metaContainer>

    <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body>
      <uix:contents>

        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/tTS"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/data/transportType"/>

          <uix:pageLayout titleBinding="TITLE_TRANSPORTABLE_TABLESPACES@transportBundle">
            <%@ include file="/database/global.jspf" %>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <%-- Put the borderLayout within a tableLayout that has
              -- a spacer row so there is a couple pixels of space
              -- between the content container and the top repeating
              -- buttons
            --%>
            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer height="3"/>
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>
                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer
                            textBinding="OVERVIEW@transportBundle"
                            width="420">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_1@transportBundle"/>
                                <uix:spacer height="10"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_2@transportBundle"/>
                                <uix:spacer height="10"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_3@transportBundle"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_4@transportBundle"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_5@transportBundle"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_6@transportBundle"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_7@transportBundle"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG_8@transportBundle"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>
                      <%-- Contents of borderLayout --%>
                      <uix:contents>
                        <uix:stackLayout>
                          <uix:contents>                          
                            <uix:radioButton
                                name="transportTablespaceType"                                    
                                selectedValueBinding="transportTablespaceType@servletRequest"                                
                                textBinding="PLUG_OUT@transportBundle@servletRequest"
                                shortDescBinding="PLUG_OUT@transportBundle@servletRequest"
                                value="PLUG_OUT"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/>
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="PLUG_OUT_TEXT@transportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:radioButton
                                name="transportTablespaceType"                                    
                                selectedValueBinding="transportTablespaceType@servletRequest"                                    
                                textBinding="PLUG_IN@transportBundle@servletRequest"
                                shortDescBinding="PLUG_IN@transportBundle@servletRequest"
                                value="PLUG_IN"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/>
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="PLUG_IN_TEXT@transportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout> 

                            <uix:header textBinding="HOST_CREDENTIALS@exportBundle@servletRequest" size="1">
                              <uix:contents>
                                <%@ include file="/credentials.jspf"%>
                              </uix:contents>
                            </uix:header>                            
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:borderLayout>                    
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>


            <%-- pageButtons within pageLayout provide repeating (top and bottom) buttons --%>
            <uix:pageButtons> 
              <uix:pageButtonBar>
                <uix:button 
                    textBinding="CANCEL@DBObjectBundle@servletRequest" 
                    shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                    destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton 
                    textBinding="CONTINUE@DBObjectBundle@servletRequest" 
                    shortDescBinding="CONTINUE@DBObjectBundle@servletRequest"
                    formName="transportForm" name="event" value="transportContinue"/>
              </uix:pageButtonBar>
            </uix:pageButtons> 
            
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
