<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer> 
      <uix:head titleBinding="availableTbsPageTitle@generateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
          name="selectTablespaceForm"
          method="post"
          destination="/console/database/data/generateTTS"
          copyParams="target,type,cancelURL">    

      <uix:formValue 
          name="pageName" 
          value="/database/data/ttsGenerateAvailTablespaces"/>

      <uix:pageLayout
        titleBinding="TITLE_AVAILABLE_TABLESPACES@transportBundle@servletRequest"
        >

        <%@ include file="/database/global.jspf" %>

        <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@generateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@generateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

        <uix:separator/>

        <%-------------------------
         -  Search Filter
         ---------------------------%>
        <uix:header
          textBinding="SEARCH@DBObjectBundle@servletRequest">
          <uix:stackLayout>

            <%-- Use different text for different types of objects --%>
            <uix:rowLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText" 
                  textBinding="ENTER_OBJECT_NAME@DBObjectBundle@servletRequest"/>
                <uix:cellFormat>
                  <uix:contents>
                    <uix:spacer width="5"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:contents>
            </uix:rowLayout>

            <uix:labeledFieldLayout labelWidth="20%"> 
              <uix:contents>
                <%-- Display the object name --%>
                <uix:styledText styleClass="OraPromptText" labeledNodeId="searchFilter"
                  textBinding="TABLESPACE@exportBundle@servletRequest"
                  shortDescBinding="TABLESPACE@exportBundle@servletRequest"/>
                <uix:textInput name="searchFilter" id="searchFilter" textBinding=" @servletRequest"/>
                <uix:styledText styleClass="OraInlineInfoText" text=""/>
                <uix:submitButton 
                  textBinding="GO@DBObjectBundle@servletRequest"
                  shortDescBinding="GO@DBObjectBundle@servletRequest"
                  onFocus="true"
                  selected="true" name="event" value="search"/>
              </uix:contents>
            </uix:labeledFieldLayout>  

          </uix:stackLayout>
        </uix:header>

        <%-------------------------
         -  Available Tablespaces Table
         ---------------------------%>

        <uix:header 
          textBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
          >

          <oem:table 
            width="80%" 
            blockSize="10"
            formSubmitted="true"
            name="availTablespaceTable" 
            beanKey="availableTbsTableBean" 
            dataSourceProp="availTablespaceTable"
            alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest"
            summaryBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
            >           
            <uix:tableSelection>
              <uix:multipleSelection              
                selectionBinding="selection@availableTbsTableBean@servletRequest"
                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                selectedBinding="selected"/>
            </uix:tableSelection>
          </oem:table>
        </uix:header>

        <%-------------------------
         -  PageButtons
         ---------------------------%>
        <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              textBinding="CANCEL@DBObjectBundle@servletRequest"
              shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
              value="cancelSelect"/>

            <uix:submitButton
              name="event" 
              textBinding="SELECT@DBObjectBundle@servletRequest"
              shortDescBinding="SELECT@DBObjectBundle@servletRequest"
              value="selectItems"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

