<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="conversionPageTitle@generateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/generateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsGenerateConversion"/>

          <uix:pageLayout titleBinding="TITLE_CONVERSION@transportBundle@servletRequest">
          
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@generateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@generateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page context (target name) --%>          
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="DISK_SPACE_ESTIMATE@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="diskSpaceEstimate@generateBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
                       
            <uix:separator/>

            <uix:header textBinding="CONVERSION_HEADER@transportBundle@servletRequest" size="1">
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" textBinding="CONVERSION_TEXT@transportBundle@servletRequest"/>
                  <oem:radioButton
                            name="conversionLocation"
                            selectedValueBinding="conversionLocation@generateBean@servletRequest"
                            textBinding="CONVERSION_AT_TARGET@transportBundle@servletRequest"
                            shortDescBinding="CONVERSION_AT_TARGET@transportBundle@servletRequest"
                            value="TARGET"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/> 
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="CONVERSION_AT_SOURCE_TEXT@transportBundle@servletRequest"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                  <oem:radioButton
                            name="conversionLocation"
                            selectedValueBinding="conversionLocation@generateBean@servletRequest"
                            textBinding="CONVERSION_AT_SOURCE@transportBundle@servletRequest"
                            shortDescBinding="CONVERSION_AT_SOURCE@transportBundle@servletRequest"
                            value="SOURCE"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/> 
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="CONVERSION_AT_TARGET_TEXT@transportBundle@servletRequest"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>                                

                 <%--................ datafiles..................--%>
                  <uix:header textBinding="DATAFILE_LOCATION_HEADER@transportBundle@servletRequest">
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" textBinding="DATAFILE_LOCATION_HEADER_TEXT@transportBundle@servletRequest"/>                                                
                      <uix:spacer height="10"/>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:messageLovField name="defaultDatafileDir"
                              textBinding="defaultDatafileDir@generateBean@servletRequest"                              
                              promptBinding="POPULATE_PROMPT@transportBundle@servletRequest"
                              columns="60"
                              searchDescBinding="POPULATE_PROMPT@transportBundle@servletRequest"
                              onClick="startDirectoryBrowser(\'defaultDatafileDir\');"/>                                                  
                            <uix:spacer width="5"/>
                            <uix:submitButton name="event"
                              value="populateDfDir"
                              textBinding="GO_BUTTON_TEXT@transportBundle@servletRequest"
                              shortDescBinding="GO_BUTTON_TEXT@transportBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:tableLayout>  
                      
                      <oem:table 
                        width="80%" 
                        blockSize="10"
                        formSubmitted="true"
                        name="datafilesTableUI" 
                        dataSourceProp="datafilesTableUI"
                        beanKey="generateBean"
                        alternateTextBinding="NO_ITEMS_FOUND@transportBundle@servletRequest"
                        summaryBinding="DATAFILE_LOCATION_HEADER@transportBundle@servletRequest"
                        >
                      </oem:table>
                      
                    </uix:contents>
                  </uix:header>
                  
                </uix:contents>
              </uix:stackLayout>
            </uix:header>         

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>                
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@generateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@generateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
