<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="filesPageTitle@generateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/generateTTS"
            copyParams="target,type,cancelURL">
              
          <uix:formValue name="pageName" value="/database/data/ttsGenerateFiles"/>

          <uix:pageLayout titleBinding="TITLE_TRANSPORT_FILES@transportBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@generateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@generateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <oem:messageBox messageType="confirmation"
                                 errorTableBinding="confirmation@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>                
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
            
            <uix:separator/>

            <uix:stackLayout>
              <uix:contents>
                <uix:header textBinding="DUMP_FILE_HEADER@transportBundle@servletRequest" size="1">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="DUMP_FILE_TEXT@transportBundle@servletRequest"/>
                  <uix:spacer height="3"/>                  
                  <uix:labeledFieldLayout labelWidth="5%">
                    <uix:contents>                  
                      <uix:messageLovField name="dumpFileDir"
                          textBinding="dumpFileDir@generateBean@servletRequest"                          
                          promptBinding="DUMP_FILE_DIRECTORY_LABEL@transportBundle@servletRequest"
                          columns="80"
                          required="yes"
                          searchDescBinding="DUMP_FILE_DIRECTORY_LABEL@transportBundle@servletRequest"
                          onClick="startDirectoryBrowser(\'dumpFileDir\');"/>                                             
                      <uix:messageTextInput
                                      id="dumpFileName"
                                      name="dumpFileName"
                                      textBinding="dumpFileName@generateBean@servletRequest"
                                      shortDescBinding="dumpFileName@generateBean@servletRequest"
                                      promptBinding="DUMP_FILE_LABEL@transportBundle@servletRequest"
                                      required="yes"
                                      columns="40"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:stackLayout>
                </uix:header>
              
                <uix:switcher childNameBinding="convertDatafiles@generateBean@servletRequest">
                  <uix:case name="false">              
                    <uix:header textBinding="DATAFILE_HEADER@transportBundle@servletRequest" size="1">
                    <uix:stackLayout>
                      <uix:styledText styleClass="OraInstructionText" textBinding="DATAFILE_TEXT@transportBundle@servletRequest"/>

                      <oem:radioButton
                                name="copyDatafile"
                                selectedValueBinding="copyDatafile@generateBean@servletRequest"
                                textBinding="COPY_DATAFILE_AUTOMATICALLY@transportBundle@servletRequest"
                                shortDescBinding="COPY_DATAFILE_AUTOMATICALLY@transportBundle@servletRequest"
                                value="AUTO"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="copyDatafileAutoText@generateBean@servletRequest"/>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:rowLayout>
                      <oem:radioButton
                                name="copyDatafile"
                                selectedValueBinding="copyDatafile@generateBean@servletRequest"
                                textBinding="COPY_DATAFILE_MANUALLY@transportBundle@servletRequest"
                                shortDescBinding="COPY_DATAFILE_MANUALLY@transportBundle@servletRequest"
                                value="MANUAL"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="COPY_DATAFILE_MANUALLY_TEXT@transportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:rowLayout>                                
                      
                    </uix:stackLayout>
                    </uix:header>
                  </uix:case>
                </uix:switcher>                    
              </uix:contents>
            </uix:stackLayout>
            

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="transportForm" 
                  textBinding="FINISH@exportBundle@servletRequest" 
                  shortDescBinding="FINISH@exportBundle@servletRequest" 
                  name="event" value="ok"/> 
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@generateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@generateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
