<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="targetCharacteristicsPageTitle@generateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/generateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsGenerateOptions"/>

          <uix:pageLayout titleBinding="TITLE_TARGET_CHARACTERISTICS@transportBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>                     
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@generateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@generateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <oem:messageBox messageType="confirmation"
                                 errorTableBinding="confirmation@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            
            <%-- Use the pageStatus tag to provide page/wizard context (target name)--%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="SOURCE_PLATFORM@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="fromPlatform@generateBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
                         
            <uix:separator/>            
              <uix:stackLayout>
                <uix:contents>
               
                  <uix:header textBinding="TARGET_DATABASE_PLATFORM@transportBundle@servletRequest" size="1">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" textBinding="TARGET_DATABASE_PLATFORM_TEXT@transportBundle@servletRequest"/>
                        <uix:labeledFieldLayout labelWidth="20%">
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="toPlatform" 
                            textBinding="TARGET_PLATFORM@transportBundle@servletRequest"/>
                          <uix:choice name="toPlatform" id="toPlatform" 
                            selectedValueBinding="toPlatform@generateBean@servletRequest">
                            <uix:contents childDataBinding="platformList@generateBean@servletRequest">
                              <uix:option textBinding="."/>
                            </uix:contents>
                          </uix:choice>
                          <uix:styledText styleClass="OraInstructionText" text=""/>
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="CONVERSION_SKIP_TEXT@transportBundle@servletRequest"/>                                                
                        </uix:labeledFieldLayout>                      
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:header>  
                  
                  
                  <uix:header textBinding="TARGET_CHARACTER_SET@transportBundle@servletRequest" size="1">
                    <uix:styledText styleClass="OraInstructionText" textBinding="TARGET_CHARACTER_SET_TEXT@transportBundle@servletRequest"/>
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>
                        <uix:stackLayout>
                        
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:checkBox name="characterSetCompatible" 
                                  checkedBinding="characterSetCompatible@generateBean@servletRequest" 
                                  textBinding="TARGET_CHARACTER_SET_CHECK@transportBundle@servletRequest"
                                  shortDescBinding="TARGET_CHARACTER_SET_CHECK@transportBundle@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          
                          <uix:tableLayout width="100%">
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat width="20"/>
                                <uix:cellFormat width="25%" hAlign="right">
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="toPlatformCharSet" 
                                    textBinding="TARGET_DATABASE_CHARACTER_SET@transportBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat width="10"/>
                                <uix:cellFormat hAlign="left">
                                  <uix:choice name="toPlatformCharSet" id="toPlatformCharSet" 
                                    selectedValueBinding="toPlatformCharSet@generateBean@servletRequest">
                                    <uix:contents childDataBinding="availableCharSetstList@generateBean@servletRequest">
                                      <uix:option textBinding="."/>
                                    </uix:contents>
                                  </uix:choice>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat width="20"/>
                                <uix:cellFormat width="25%" hAlign="right">
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="toPlatformNCharSet" 
                                  textBinding="TARGET_NATIONAL_CHARACTER_SET@transportBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat width="10"/>
                                <uix:cellFormat hAlign="left">
                                  <uix:choice name="toPlatformNCharSet" id="toPlatformNCharSet" 
                                    selectedValueBinding="toPlatformNCharSet@generateBean@servletRequest">
                                    <uix:contents childDataBinding="availableNCharSetsList@generateBean@servletRequest">
                                      <uix:option textBinding="."/>
                                    </uix:contents>
                                  </uix:choice>   
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:tableLayout>

                        </uix:stackLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:header>                    
                </uix:contents>
              </uix:stackLayout>
            <%-- </uix:header> --%>
            
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                    shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                    destinationBinding="cancelURL@servletRequest"/>                
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@generateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@generateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>            

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
