<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="selectTbsPageTitle@generateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/generateTTS"
            copyParams="target,type,cancelURL">
    
          <uix:formValue name="pageName" value="/database/data/ttsGenerateSelectTablespaces"/>

          <uix:pageLayout titleBinding="TITLE_SELECT_TRANSPORT_TABLESPACES@transportBundle@servletRequest">
          
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>                     
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@generateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@generateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
                       
            <uix:separator/>

             <uix:styledText styleClass="OraInstructionText" 
                 textBinding="SELECT_TABLESPACES_TEXT@transportBundle@servletRequest"/>
             <uix:header textBinding="SELECT_TABLESPACES@transportBundle@servletRequest">
              
              <%---  Add Button  ---%>
              <%--- <uix:switcher childNameBinding="privilegedUser@generateBean@servletRequest">  ---%>
                  <uix:tableLayout width="80%"> 
                    <uix:rowLayout hAlign="right"> 
                      <uix:cellFormat> 
                        <uix:contents> 
                          <uix:submitButton 
                            textBinding="ADD@DBObjectBundle@servletRequest"
                            shortDescBinding="ADD@DBObjectBundle@servletRequest"
                            name="event"
                            value="addItems" 
                            formName="transportForm"
                          />
                        </uix:contents> 
                      </uix:cellFormat> 
                    </uix:rowLayout> 
                  </uix:tableLayout> 
                
              <%--- </uix:switcher>  ---%>
              
              <%--- User Table  --%>
              <oem:table 
                width="80%" 
                blockSize="10"
                formSubmitted="true"
                name="tablespaceTable" 
                dataSourceProp="tablespaceTable"
                beanKey="selectedTbsTableBean"
                alternateTextBinding="NO_TABLESPACES_SELECTED@exportBundle@servletRequest"
                summaryBinding="SELECT_TABLESPACES@transportBundle@servletRequest"
                >
                <uix:tableSelection>
                  <oem:singleSelection selectedIndexBinding="selectedIndex@selectedTbsTableBean@servletRequest"
                                       shortDescBinding="SELECT@DBObjectBundle@servletRequest">
                    <uix:submitButton
                      textBinding="REMOVE@exportBundle@servletRequest"
                      shortDescBinding="REMOVE@exportBundle@servletRequest"
                      name="event"
                      value="deleteItems"
                      formName="transportForm"
                    />
                  </oem:singleSelection>
                </uix:tableSelection>
              </oem:table>

            </uix:header>          
            <%-- section for containment --%>
           
            <uix:header textBinding="CONTAINMENT@transportBundle@servletRequest">
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" textBinding="CONTAINMENT_TEXT@transportBundle@servletRequest"/>
                  
                    <uix:messageRadioButton
                      name="fullCheck"
                      selected="true"
                      textBinding="SELF_CONTAINMENT@transportBundle@servletRequest"
                      shortDescBinding="SELF_CONTAINMENT@transportBundle@servletRequest"
                      value="SELF"
                      selectedValueBinding="fullCheck@generateBean@servletRequest"
                      />

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:spacer width="20" height="0"/> 
                        <uix:checkBox
                          name="includeConstraints"
                          checkedBinding="includeConstraints@generateBean@servletRequest"
                          textBinding="INCLUDE_CONSTRAINTS_CHECK@transportBundle@servletRequest"
                          shortDescBinding="INCLUDE_CONSTRAINTS_CHECK@transportBundle@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>   
                      
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:spacer width="20" height="0"/> 
                          <uix:styledText 
                            styleClass="OraInlineInfoText" 
                            textBinding="INCLUDE_CONSTRAINTS_TEXT@transportBundle@servletRequest"
                            shortDescBinding="INCLUDE_CONSTRAINTS_TEXT@transportBundle@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>                      
                  
                    <uix:messageRadioButton
                      name="fullCheck"
                      selected="false"
                      textBinding="FULL_CONTAINMENT@transportBundle@servletRequest"
                      shortDescBinding="FULL_CONTAINMENT@transportBundle@servletRequest"
                      value="FULL"
                      selectedValueBinding="fullCheck@generateBean@servletRequest"
                      />

                    <uix:spacer height="10"/> 
                  
                    <uix:submitButton formName="transportForm" 
                      textBinding="CHECK_CONTAINMENT_BUTTON@transportBundle@servletRequest" 
                      shortDescBinding="CHECK_CONTAINMENT_BUTTON@transportBundle@servletRequest" 
                      name="event" value="checkContainment"/>                  
                    
                    <uix:spacer height="10"/> 
                    
                    <uix:switcher childNameBinding="violationListEmpty@generateBean@servletRequest">
                      <uix:case name="false">
                        <uix:messagePrompt labeledNodeId="violationList" 
                          promptBinding="CONTAINMENT_STATUS@transportBundle@servletRequest"/>                          
                        <uix:textInput name="violationList" id="violationList" rows="10" 
                          textBinding="violationList@generateBean@servletRequest" columns="100"
                          shortDescBinding="violationList@generateBean@servletRequest"                          
                          readOnly="true"/>
                      </uix:case>
                    </uix:switcher>
                  
                </uix:contents>
              </uix:stackLayout>
            </uix:header>
            <%-- section for containment --%>          


            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>                
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@generateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@generateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
