<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="createDirPageTitle@integrateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
	<db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/integrateTTS"
            copyParams="target,type,cancelURL">
        
        <uix:formValue name="pageName" value="/database/data/ttsIntegrateCreateDir"/>
        <uix:formValue name="prevPage" valueBinding="prevPage@servletRequest"/>
        <uix:formValue name="nextPage" valueBinding="nextPage@servletRequest"/>

        <uix:pageLayout titleBinding="WARNING_TITLE_TEXT_INTEGRATE@transportBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>


          <uix:stackLayout>
            <uix:contents>
            <oem:messageBox messageType="warning"
              errorTableBinding="warnings@servletRequest"
              titleTextKey="titleText" 
              mainTextKey="mainText" />


            </uix:contents>
          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="NO@transportBundle@servletRequest" 
                shortDescBinding="NO@transportBundle@servletRequest" 
                name="event" value="createDirNo"/>
              <uix:submitButton textBinding="YES@transportBundle@servletRequest"
                shortDescBinding="YES@transportBundle@servletRequest"
                name ="event" value="createDirYes"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
