<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="datafileDestinationPageTitle@integrateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/integrateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsIntegrateDatafileCopy"/>

          <uix:pageLayout titleBinding="TITLE_INTEGRATE_DATAFILE_DESTINATION@transportBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@integrateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@integrateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>


            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="confirmation"
                                 errorTableBinding="confirmation@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
               <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>                       
                  <uix:messagePrompt
                      promptBinding="DISK_SPACE_ESTIMATE@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="diskSpaceEstimate@integrateBean@servletRequest"/>                      
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
                       
            <uix:separator/>
 
            <uix:header textBinding="datafileDestinationHeader@integrateBean@servletRequest" size="1">                              
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" 
                      textBinding="datafileDestinationText@integrateBean@servletRequest"/>                
                  <uix:switcher childNameBinding="conversionNeeded@integrateBean@servletRequest">
                    <uix:case name="false">                  
                      <uix:messageRadioButton
                          name="copyDatafileOnIntegrate"                          
                          textBinding="DO_NOT_COPY_DATAFILE@transportBundle@servletRequest"
                          shortDescBinding="DO_NOT_COPY_DATAFILE@transportBundle@servletRequest"
                          value="DO_NOT_COPY"
                          selectedValueBinding="copyDatafileOnIntegrate@integrateBean@servletRequest"                        
                          messageBinding="DO_NOT_COPY_DATAFILE_TEXT@transportBundle@servletRequest"/>
                    </uix:case>
                  </uix:switcher>
  
                  <uix:switcher childNameBinding="conversionNeeded@integrateBean@servletRequest">
                    <uix:case name="false">                  
                      <uix:messageRadioButton
                            name="copyDatafileOnIntegrate"                            
                            textBinding="COPY_DATAFILE@transportBundle@servletRequest"
                            shortDescBinding="COPY_DATAFILE@transportBundle@servletRequest"
                            value="COPY"
                            selectedValueBinding="copyDatafileOnIntegrate@integrateBean@servletRequest"                        
                            messageBinding="COPY_DATAFILE_TEXT@transportBundle@servletRequest"/>              
                    </uix:case>
                  </uix:switcher>

                  <%--................ old + new datafiles..................--%>
                  <uix:header textBinding="datafileLocationHeader@integrateBean@servletRequest">                
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" textBinding="DATAFILE_LOCATION_HEADER_TEXT@transportBundle@servletRequest"/>                                                
                      <uix:spacer height="10"/>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:messageLovField name="defaultDatafileDir"
                                textBinding="defaultDatafileDir@integrateBean@servletRequest"
                                promptBinding="POPULATE_PROMPT@transportBundle@servletRequest"
                                columns="60"
                                searchDescBinding="POPULATE_PROMPT@transportBundle@servletRequest"
                                onClick="startDirectoryBrowser(\'defaultDatafileDir\');"/>                            
                            <uix:spacer width="5"/>
                            <uix:submitButton name="event"
                              value="populateDfDir"
                              textBinding="GO_BUTTON_TEXT@transportBundle@servletRequest"
                              shortDescBinding="GO_BUTTON_TEXT@transportBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:tableLayout>                                              
                      <oem:table 
                        width="80%" 
                        blockSize="10"
                        formSubmitted="true"
                        name="convertDatafileTableUI" 
                        dataSourceProp="convertDatafileTableUI"
                        beanKey="integrateBean"
                        alternateTextBinding="NO_ITEMS_FOUND@transportBundle@servletRequest"
                        summaryBinding="datafileLocationHeader@integrateBean@servletRequest"
                        >
                      </oem:table>                                  
                    </uix:contents>
                  </uix:header>                  
                </uix:contents>
              </uix:stackLayout>
            </uix:header>         

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                destinationBinding="cancelURL@servletRequest"/>
                
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@integrateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@integrateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 