<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/remoteBrowser/remoteBrowser.js"/>
<script language="javascript">
function setAction()
{
  document.transportForm.action += "#extMap";
}
</script>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="filesPageTitle@integrateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/integrateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsIntegrateFiles"/>

          <uix:pageLayout titleBinding="TITLE_INTEGRATE_FILES@transportBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@integrateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@integrateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="confirmation"
                                 errorTableBinding="confirmation@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>                
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>            

            <uix:separator/>  
  
            <uix:styledText styleClass="OraInstructionText" 
               textBinding="INTEGRATE_TABLESPACES_TEXT@transportBundle@servletRequest"/>
           
            <uix:stackLayout>
              <uix:contents>              
                <uix:header textBinding="DUMP_FILE_HEADER@transportBundle@servletRequest" size="1">
                  
                  <uix:stackLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="DUMP_FILE_FORMAT_TEXT@transportBundle@servletRequest"/>
                    <uix:spacer height="3"/>  
                                        
                    <uix:messageLovField name="dumpFileName"
                        textBinding="dumpFileName@integrateBean@servletRequest"
                        promptBinding="DUMP_FILE_LABEL@transportBundle@servletRequest"
                        columns="80"
                        required="yes"
                        searchDescBinding="DUMP_FILE_LABEL@transportBundle@servletRequest"
                        onClick="startFileBrowser(\'dumpFileName\');"/>
                        
                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="DUMP_FILE_FORMAT_LABEL@transportBundle@servletRequest"/>
                        <uix:stackLayout>
                          <uix:contents>
                            <oem:radioButton
                                      name="dmpFileFormat10g"
                                      disabledBinding="dbLowerThan10g@integrateBean@servletRequest"
                                      selectedValueBinding="dmpFileFormat10g@integrateBean@servletRequest"
                                      textBinding="DUMP_FILE_FORMAT_CHOICE1@transportBundle@servletRequest"
                                      shortDescBinding="DUMP_FILE_FORMAT_CHOICE1@transportBundle@servletRequest"
                                      selected="true"
                                      value="POST_10g"/>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat>
                        </uix:cellFormat>
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/>
                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="DUMP_FILE_FORMAT_CHOICE1_TEXT@transportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <oem:radioButton
                                      name="dmpFileFormat10g"
                                      selectedValueBinding="dmpFileFormat10g@integrateBean@servletRequest"
                                      textBinding="DUMP_FILE_FORMAT_CHOICE2@transportBundle@servletRequest"
                                      shortDescBinding="DUMP_FILE_FORMAT_CHOICE2@transportBundle@servletRequest"
                                      selected="false"
                                      value="PRE_10g"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/>
                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="DUMP_FILE_FORMAT_CHOICE2_TEXT@transportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                          </uix:contents>
                        </uix:stackLayout>
                      </uix:rowLayout>
                    </uix:tableLayout>
                    
                  </uix:stackLayout>                 
                </uix:header>

                <uix:rawText>
                    <a name="extMap">
                </uix:rawText>

                <uix:header textBinding="DATAFILE_HEADER@transportBundle@servletRequest" size="1">
                  <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_DATAFILE_TEXT@transportBundle@servletRequest"/>
                    <uix:contents>
                                           
                        <uix:rowLayout>
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="directoryName" 
                              textBinding="DIRECTORY_NAME_LABEL@transportBundle@servletRequest"/>
                          <uix:spacer width="5"/>
                          <uix:stackLayout>
                            <uix:textInput name="directoryName" id="directoryName" 
                               textBinding="directoryName@integrateBean@servletRequest" columns="50"/>
                            <uix:messageText messageType="error" messageBinding="directoryName@errors@servletRequest"/>
                          </uix:stackLayout>   
                          <uix:spacer width="5"/>
                          <uix:submitButton 
                            textBinding="ADD_FILES_BUTTON@transportBundle@servletRequest" 
                            shortDescBinding="ADD_FILES_BUTTON@transportBundle@servletRequest" 
                            name="event" 
                            value="populateFiles"
                            onClick = "setAction();submitForm('transportForm',1,{'event':'populateFiles'});return false;"/>
                        </uix:rowLayout>                              
                        <uix:styledText styleClass="OraInstructionText" text=""/>                        
                        <uix:styledText 
                            styleClass="OraInlineInfoText" 
                            textBinding="FILES_TO_INCLUDE_HINT@transportBundle@servletRequest"/>                       
                      
                    </uix:contents>
                    
                    <uix:spacer width="10"/>
              
                    <oem:table name="addDatafileTableUI"
                          width="80%" 
                          blockSize="10"
                          formSubmitted="true"                          
                          dataSourceProp="addDatafileTableUI"
                          destination="/console/database/data/transport"
                          beanKey="integrateBean"
                          alternateTextBinding="NO_ITEMS_FOUND@transportBundle@servletRequest"
                          summaryBinding="DATAFILE_HEADER@transportBundle@servletRequest" >
                      <uix:tableSelection>
                        <oem:singleSelection 
                            shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                            selectedIndexBinding="selectedIndex@addDatafileTableDS@integrateBean@servletRequest">
                            <uix:submitButton
                              textBinding="REMOVE@exportBundle@servletRequest"
                              shortDescBinding="REMOVE@exportBundle@servletRequest"
                              name="event"
                              value="deleteDatafile"
                              onClick = "setAction();submitForm('transportForm',1,{'event':'deleteDatafile'});return false;"/>                              
                        </oem:singleSelection>
                      </uix:tableSelection>
                      <uix:columnFooter>
                        <uix:submitButton 
                          textBinding="ADD_FILE@exportBundle@servletRequest" 
                          shortDescBinding="ADD_FILE@exportBundle@servletRequest" 
                          name="event" 
                          value="addDatafile"
                          onClick = "setAction();submitForm('transportForm',1,{'event':'addDatafile'});return false;"/>
                      </uix:columnFooter>
                    </oem:table>                                        

                  </uix:stackLayout>
                </uix:header>                
              </uix:contents>
            </uix:stackLayout>
            

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>
                
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@integrateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@integrateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
