<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsPageTitle@integrateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/integrateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsIntegrateOptions"/>

          <uix:pageLayout titleBinding="TITLE_INTEGRATE_OPTIONS@transportBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>                     
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@integrateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@integrateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="confirmation"
                                 errorTableBinding="confirmation@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>                
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                  <uix:header textBinding="REMAP_SCHEMAS_HEADER@importBundle@servletRequest" size="1">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" 
                            textBinding="YOU_CAN_MAP_SCHEMAS@importBundle@servletRequest"/>
                                                     
                        <oem:table name="userMappingTableUI"
                                 beanKey="integrateBean"
                                 destination="/console/database/data/transport"
                                 formSubmitted="true"
                                 dataSourceProp="userMappingTableUI"
                                 alternateTextBinding="defaultRemapSchemaMessg@integrateBean@servletRequest"
                                 summaryBinding="REMAP_SCHEMAS_HEADER@importBundle@servletRequest"
                                 >
                          <uix:tableSelection>
                            <uix:singleSelection 
                                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                selectedIndexBinding="selectedIndex@userMappingTableDS@integrateBean@servletRequest">
                              <uix:submitButton 
                                  textBinding="REMOVE@exportBundle@servletRequest" 
                                  shortDescBinding="REMOVE@exportBundle@servletRequest" 
                                  name="event" 
                                  value="deleteUser"/>
                            </uix:singleSelection>
                          </uix:tableSelection>
                          <uix:columnFooter>
                            <uix:submitButton 
                                textBinding="ADD_FILE@exportBundle@servletRequest" 
                                shortDescBinding="ADD_FILE@exportBundle@servletRequest" 
                                name  ="event" 
                                value ="addUser"
                                renderedBinding ="sourceSchemaPresent@integrateBean@servletRequest"/> 
                          </uix:columnFooter>
                        </oem:table>                      
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:header>
                      
                  <uix:header textBinding="READ_WRITE_HEADER@transportBundle@servletRequest" size="1">
                    <uix:contents>
                      <uix:checkBox name="alterTablespaceRW" 
                          checkedBinding="alterTablespaceRW@integrateBean@servletRequest" 
                          textBinding="READ_WRITE_CHECK@transportBundle@servletRequest"
                          shortDescBinding="READ_WRITE_CHECK@transportBundle@servletRequest"/>                  
                    </uix:contents>                                    
                  </uix:header>
                </uix:contents>
              </uix:tableLayout>
            

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="transportForm" 
                    textBinding="FINISH@exportBundle@servletRequest" 
                    shortDescBinding="FINISH@exportBundle@servletRequest" 
                    name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@integrateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@integrateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
