<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="summaryPageTitle@integrateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/integrateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsIntegrateReview"/>

          <uix:pageLayout titleBinding="summaryPageHeader@integrateBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>                     
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@integrateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@integrateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>
                        
            <uix:separator/>
            
            <uix:header textBinding="SUMMARY@transportBundle@servletRequest"> 
              <uix:stackLayout>
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:contents>
                      <uix:messagePrompt promptBinding="JOB_NAME@exportBundle@servletRequest"/>
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="jobName@integrateBean@servletRequest"/>
                      <uix:messageStyledText promptBinding="COPY_DATAFILE@transportBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" 
                          textBinding="copyDatafileOnIntegrate@integrateBean@servletRequest"
                          renderedBinding="copyDatafile@integrateBean@servletRequest"/>                                          
                      <uix:messageStyledText promptBinding="DISK_SPACE_ESTIMATE@transportBundle@servletRequest"
                          styleClass="OraInstructionTextStrong" 
                          textBinding="diskSpaceEstimate@integrateBean@servletRequest"
                          renderedBinding="convertOrCopy@integrateBean@servletRequest"/>                                            
                      <uix:messagePrompt promptBinding="READ_WRITE_HEADER@transportBundle@servletRequest"/>
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="alterTablespaceRW@integrateBean@servletRequest"/>                      
                    </uix:contents>
                  </uix:labeledFieldLayout>
                  
                  <uix:spacer height="10"/>
                  
                    
                  <uix:header textBinding="REMAP_SCHEMAS_HEADER@importBundle@servletRequest">   
                    
                      <uix:contents>
                        <oem:table 
                             width="80%"
                             name="summaryUserMappingTableUI"
                             beanKey="integrateBean"
                             destination="/console/database/data/transport"
                             formSubmitted="true"
                             dataSourceProp="summaryUserMappingTableUI"
                             alternateTextBinding="defaultRemapSchemaMessg@integrateBean@servletRequest"
                             summaryBinding="REMAP_SCHEMAS_HEADER@importBundle@servletRequest">                          
                        </oem:table>                         
                      </uix:contents>
                  </uix:header>
                  
                  <uix:spacer height="10"/>
                  
                  <uix:header textBinding="DUMP_FILE_HEADER@transportBundle@servletRequest">   
                    <uix:labeledFieldLayout labelWidth="15%">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="DUMP_FILE_LABEL@transportBundle@servletRequest"/>
                        <uix:styledText
                            styleClass="OraDataText"
                            textBinding="dumpFileName@integrateBean@servletRequest"/>                      
                        <uix:messagePrompt promptBinding="DUMP_FILE_FORMAT_LABEL@transportBundle@servletRequest"/>
                        <uix:styledText
                            styleClass="OraDataText"
                            textBinding="dmpFileFormat10gText@integrateBean@servletRequest"/>                                            
                      </uix:contents>
                    </uix:labeledFieldLayout>                                    
                  </uix:header>
                  
                  <uix:spacer height="10"/>
                  
                  <uix:header textBinding="DATAFILE_HEADER@transportBundle@servletRequest">
                     <oem:table 
                      width="80%" 
                      blockSize="10"
                      formSubmitted="true"
                      name="summaryDatafilesTableUI" 
                      dataSourceProp="summaryDatafilesTableUI"
                      beanKey="integrateBean"
                      alternateTextBinding="NO_ITEMS_FOUND@transportBundle@servletRequest"
                      summaryBinding="DATAFILE_HEADER@transportBundle@servletRequest">
                    </oem:table>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
            </uix:header>

            <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>
                  <uix:contents>
                    <uix:navigationBar
                      name="ctNav"
                      blockSize="-1"                                          
                      formSubmitted="true"
                      formName="transportForm"
                      maxValueBinding="maxNavValue@integrateBean@servletRequest"
                      minValue="1"
                      valueBinding="navValue@integrateBean@servletRequest"/>
                  </uix:contents>
                  <uix:submitButton formName="transportForm" 
                    textBinding="SUBMIT_JOB@exportBundle@servletRequest" 
                    shortDescBinding="SUBMIT_JOB@exportBundle@servletRequest" 
                    name="event" value="submitIntegrateJob"/>
                </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
