<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="schedulePageTitle@integrateBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form
            name="transportForm"
            method="post"
            destination="/console/database/data/integrateTTS"
            copyParams="target,type,cancelURL">
      
          <uix:formValue name="pageName" value="/database/data/ttsIntegrateSchedule"/>

          <uix:pageLayout titleBinding="schedulePageHeader@integrateBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@integrateBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@integrateBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="50%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@exportBundle@servletRequest"/>                      
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetDBName@servletRequest"/>                      
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@transportBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetUserName@servletRequest"/>                
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

           <%-- <uix:header textBinding="SCHEDULE@transportBundle@servletRequest"> --%>
            <uix:contents>
             <uix:stackLayout>
              <uix:contents>

	             <uix:tableLayout width="100%">
	              <uix:rowLayout>
	               <uix:styledText 	styleClass="OraInstructionText"
			  	        textBinding="JOB_TEXT@exportBundle@servletRequest"/>
	              </uix:rowLayout>
	             </uix:tableLayout>

	             <%--.................. job ...................--%>	
	             <uix:header textBinding="JOB_PARAMETERS@exportBundle@servletRequest">
	              <uix:contents>

	               <uix:tableLayout width="100%">
	                <uix:rowLayout>
	                 <uix:cellFormat hAlign="right" width="20%">
	                  <uix:messagePrompt labeledNodeId="jobName" promptBinding="JOB_NAME@exportBundle@servletRequest"/>
	                 </uix:cellFormat>
	                  <uix:spacer width="5"/>
	                 <uix:cellFormat hAlign="left" width="80%">
	                  <uix:textInput name="jobName" id="jobName" columns="60"
			                 textBinding="jobName@integrateBean@servletRequest"
                       shortDescBinding="jobName@integrateBean@servletRequest"/>
	                 </uix:cellFormat>
	                </uix:rowLayout>

	                <uix:rowLayout>
	                 <uix:cellFormat hAlign="right" width="20%">
	                  <uix:messagePrompt labeledNodeId="jobDescription" promptBinding="JOB_DESCRIPTION@exportBundle@servletRequest"/>
	                 </uix:cellFormat>
	                  <uix:spacer width="5"/>
	                 <uix:cellFormat hAlign="left" width="80%">
	                  <uix:textInput name="jobDescription" id="jobDescription"
			                 textBinding="jobDescription@integrateBean@servletRequest"
                       shortDescBinding="jobDescription@integrateBean@servletRequest"
                       columns="60" />
	                 </uix:cellFormat>
	                </uix:rowLayout>
	               </uix:tableLayout>

	              </uix:contents>
	             </uix:header>

                 <%--...................... schedule .......................--%>
                 <uix:header textBinding="JOB_SCHEDULE@exportBundle@servletRequest"> 
                   <%@ include file="/sdk/schedule/start.jspf" %>  
                 </uix:header>
  
               </uix:contents>
              </uix:stackLayout>
             </uix:contents>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest" 
                  destinationBinding="cancelURL@servletRequest"/>
<%--                <uix:submitButton formName="transportForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>  --%>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="transportForm"
                    maxValueBinding="maxNavValue@integrateBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@integrateBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>
      
          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
