<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext" ><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="processingPageTitle@processBean@servletRequest"/>
    </uix:metaContainer> 


    <uix:body>
    <uix:contents>
        <db:form
            name="processingForm"
            method="post"
            destinationBinding="destinationController@processBean@servletRequest"
            copyParams="target,type,cancelURL">
    
        <uix:formValue name="pageName" value="/database/data/ttsProcessing"/>
        <uix:formValue name="prevPage" valueBinding="prevPage@servletRequest"/>
        <uix:formValue name="nextPage" valueBinding="nextPage@servletRequest"/>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest" 
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest" 
                        titleTextKey="titleText" mainTextKey="mainText"/>     


        <uix:pageLayout titleBinding="processingPageHeader@processBean@servletRequest" 
          messageType="processing">
          <%@ include file="/database/global.jspf" %>

          <uix:pageStatus>
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="progressDescription@processBean@servletRequest"/>
              </uix:contents>
            </uix:stackLayout>
          </uix:pageStatus>

          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:spacer height="5" />
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="MAY_TAKE_SEVERAL_MIN@exportBundle@servletRequest"/>
                <uix:spacer height="20" /> 
               
                <uix:processing 
                         timeInterval="<%=processingPageInterval%>">
                  <uix:contents>
                    <uix:styledText styleClass="OraProcessingStatusFixed" 
                      textBinding="progressDescription@processBean@servletRequest"/>
                  </uix:contents>
                </uix:processing>
                <uix:spacer width="10"/>
                <uix:tip>
                  <uix:styledText textBinding="OPERATION_CANNOT_BE_CANCELLED@exportBundle@servletRequest" styleClass="OraInstructionText"/>
                </uix:tip>
              </uix:contents>
            </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>

      </db:form>  
    </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
