<%-- ================  Legend =================== 
   MODIFIED    (MM/DD/YY)
    rimmidi     04/11/07 - Bug fix 5875523
    rimmidi     09/27/06 - 11gr1_project_18517_broker_state_changes.
    sjconnol    10/17/05 - Add archive dest checkbox
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.dg.util.StandbyProperties" %>
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>

<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="flashTitle@stateBean@configBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
     <db:form name="afoFlashbackForm" method="POST" destination="/console/database/dataguard" copyParams="target,type">
      <uix:pageLayout titleBinding="flashHeader@stateBean@configBean@servletRequest">
      <uix:formValue name="pageName" value="database/dataguard/afoFlashback"/>

      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

		<uix:pageButtons >
			<uix:pageButtonBar>
				<uix:contents>      
					<uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="afoFlashbackForm"
					name="event" valueBinding="cancelEventValue@stateBean@configBean@servletRequest" shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/>  
					<uix:submitButton textBinding="BACK@DGMsgBundle@servletRequest" formName="afoFlashbackForm"
					name="event" value="editOK" renderedBinding="editAfoBeanType@stateBean@configBean@servletRequest" shortDescBinding="BACK@DGMsgBundle@servletRequest"/>  
					<uix:submitButton textBinding="CONTINUE@DGMsgBundle@servletRequest"
					formName="afoFlashbackForm" name="event" valueBinding="continueEventValue@stateBean@configBean@servletRequest" shortDescBinding="CONTINUE@DGMsgBundle@servletRequest"/> 
				</uix:contents>
			</uix:pageButtonBar>
		</uix:pageButtons>					
				
	   

      <uix:rowLayout renderedBinding="editAfoBeanType@stateBean@configBean@servletRequest">
       <uix:cellFormat headers=""> 
        <uix:styledText styleClass="OraFieldText" textBinding="AFO_FLASHBACK_INFO1@DGMsgBundle@servletRequest"/> 
       </uix:cellFormat>
      </uix:rowLayout>


      <uix:rowLayout renderedBinding="editAfoBeanType@stateBean@configBean@servletRequest">
       <uix:tip> 
        <uix:styledText textBinding="AFO_FLASHBACK_TIP1@DGMsgBundle@servletRequest"/>
       </uix:tip>
      </uix:rowLayout>


		
      <uix:header textBinding="AFO_FLASHBACK_PRMY_HEADER@DGMsgBundle@servletRequest" renderedBinding="isPrimaryRecDetailsRequired@stateBean@configBean@servletRequest">
        <uix:stackLayout>

            <uix:switcher childNameBinding="needPrmyFlash@stateBean@configBean@servletRequest">
             <uix:case name="true">
              <uix:styledText styleClass="OraInstructionText" textBinding="prmyFlashOffInfo@stateBean@configBean@servletRequest"/>
             </uix:case>
             <uix:case name="false">
              <uix:styledText styleClass="OraInstructionText" textBinding="prmyFlashOnInfo@stateBean@configBean@servletRequest"/>
             </uix:case>
            </uix:switcher>

            <uix:labeledFieldLayout labelWidth="30%" renderedBinding="needPrmyFlash@stateBean@configBean@servletRequest">
             <uix:contents>
             <uix:switcher childNameBinding="showPrmyASM@stateBean@configBean@servletRequest">
             <uix:case name="false">
              <uix:messageTextInput
                name="prmyRecArea" 
                columns="50"
                promptBinding="FlashRecoveryArea@DGMsgBundle@servletRequest"
                disabledBinding="prmyUsingRecArea@stateBean@configBean@servletRequest"
                textBinding="prmyRecArea@stateBean@configBean@servletRequest"
                messageBinding="RECOVERY_AREA_DESC@DGMsgBundle@servletRequest" 
                messageType="info"
                messageTypeBinding="prmyRecArea@messageTypes@servletRequest"
                longDescURL="<%=StandbyProperties.getPropertyDest(DGMsgID.RECOVERY_AREA)%>"/>
             </uix:case>
             <uix:case name="true">
             <uix:messageLovField name="prmyRecArea" 
                                  id="prmyRecArea"
                                  disabledBinding="prmyUsingRecArea@stateBean@configBean@servletRequest"
                                  promptBinding="FlashRecoveryArea@DGMsgBundle@servletRequest"
                                  textBinding="prmyRecArea@stateBean@configBean@servletRequest"
                                  shortDescBinding="FlashRecoveryArea@DGMsgBundle@servletRequest"
                                  messageBinding="RECOVERY_AREA_DESC_ASM@DGMsgBundle@servletRequest" 
                                  messageType="info"
                                  messageTypeBinding="prmyRecArea@messageTypes@servletRequest"
                                  longDescURL="<%=StandbyProperties.getPropertyDest(DGMsgID.RECOVERY_AREA)%>"
                                  onClick = "startLov('prmyRecArea', 'ListDiskGroup')"/>
             </uix:case>
             </uix:switcher>

              <uix:messageTextInput
                name="prmyRecSize"
                columns="3"
                promptBinding="destSize@DGMsgBundle@servletRequest"
                textBinding="prmyRecSize@stateBean@configBean@servletRequest"
                messageBinding="ADD_DRWIZ_OPTIONS_PAGE_SIZE_TIP@DGMsgBundle@servletRequest" 
                messageType="info"
                messageTypeBinding="prmyRecSize@messageTypes@servletRequest"
                longDescURL="<%=StandbyProperties.getPropertyDest(DGMsgID.destSize)%>">
              </uix:messageTextInput>

              <uix:messageTextInput
                name="prmyRecRetention"
                columns="3"
                promptBinding="AFO_FLASHBACK_RETENTION_TIME@DGMsgBundle@servletRequest"
                textBinding="prmyRecRetention@stateBean@configBean@servletRequest"
                messageBinding="AFO_FLASHBACK_RETENTION_TIME_TIP@DGMsgBundle@servletRequest" 
                messageType="info"
                messageTypeBinding="prmyRecRetention@messageTypes@servletRequest"
                longDescURL="<%=StandbyProperties.getPropertyDest(DGMsgID.destSize)%>">
                <uix:end>
                 <uix:choice name="prmyRetentionUnits" shortDescBinding="AFO_FLASHBACK_RETENTION_TIME@DGMsgBundle@servletRequest" 
                  selectedValueBinding="prmyRetentionUnits@stateBean@configBean@servletRequest" >
                   <uix:option textBinding="HOURS@DGMsgBundle@servletRequest" value="HR" />
                   <uix:option textBinding="MINUTES@DGMsgBundle@servletRequest" value="MIN" />
                 </uix:choice>
                </uix:end>
              </uix:messageTextInput>

             </uix:contents>
            </uix:labeledFieldLayout>

            <uix:rowLayout width="90%" renderedBinding="showPrmySetArchDest@stateBean@configBean@servletRequest">
              <uix:messageCheckBox 
                   name="prmySetArchDest" 
                   styleClass="OraFieldText" 
                   textBinding="AFO_SET_ARCH_DEST@DGMsgBundle@servletRequest" 
                   messageBinding="prmySetArchDestTip@stateBean@configBean@servletRequest"
                   checkedBinding="prmySetArchDest@stateBean@configBean@servletRequest"/>
            </uix:rowLayout>
        </uix:stackLayout> 
      </uix:header>


      <uix:header textBinding="AFO_FLASHBACK_STBY_HEADER@DGMsgBundle@servletRequest" renderedBinding="editAfoBeanType@stateBean@configBean@servletRequest">
      	<%@ include file="/database/dataguard/afoStandby.jspf" %>
      </uix:header>
      
      <uix:stackLayout renderedBinding="convertBeanType@stateBean@configBean@servletRequest">
        <%@ include file="/database/dataguard/afoStandby.jspf" %>
      </uix:stackLayout>
      
    </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
