<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.util.StandbyProperties" %>
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>

<db:script src="/database/LOV.js"/>

<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if ((i=data.indexOf('".')) > 0)
  {
    if(destField == "observerHost")
    {
      document.forms[0].observerHost.value=data.substring(1,i);
      s = data.substring(i+2, data.length);

      if ((t=s.indexOf('"')) >= 0)
      {
        document.forms[0].observerHome.value=s.substring(t+1, s.length -1);
      }
      else
      {
        document.forms[0].observerHome.value=s;
      }
    }
    else if(destField == "altObserverHost")
    {
      document.forms[0].altObserverHost.value=data.substring(1,i);
      s = data.substring(i+2, data.length);

      if ((t=s.indexOf('"')) >= 0)
      {
        document.forms[0].altObserverHome.value=s.substring(t+1, s.length -1);
      }
      else
      {
        document.forms[0].altObserverHome.value=s;
      }
    }
  }
  else if ((i=data.indexOf('.')) >= 0)
  {
    if(destField == "observerHost")
    {
      document.forms[0].observerHost.value=data.substring(0,i);
      s = data.substring(i+1, data.length);
      if ((t=s.indexOf('"')) > 0)
      {
        document.forms[0].observerHome.value=s.substring(t+1, s.length -1);
      }
      else
      {
        document.forms[0].observerHome.value=s;
      }
    }
    if(destField == "altObserverHost")
    {
      if ((t=s.indexOf('"')) >= 0)
      {
        document.forms[0].altObserverHome.value=s.substring(t+1, s.length -1);
      }
      else
      {
        document.forms[0].altObserverHome.value=s;
      }
    }
  }
}
</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

<jsp:useBean id="dbBean" class="oracle.sysman.db.dg.util.DBInfo" scope="request"/>

    <uix:metaContainer> 
      <uix:head titleBinding="observerTitle@editProtBean@configBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
    <db:form name="afoObserverForm" method="POST" 
        destination="/em/console/database/dataguard/afoObserver" copyParams="target,type">
      <uix:formValue name="pageEvent" value="editConfig"/>
      <uix:formValue name="lovVersion" valueBinding="homeFilterVer@editProtBean@configBean@servletRequest"/>
     <uix:pageLayout titleBinding="observerHeader@editProtBean@configBean@servletRequest">
      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>
    
      <uix:pageButtons>
	    <uix:pageButtonBar>
          <uix:contents>
    					<uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="afoObserverForm"  
                  name="event" value="cancelObserver"  shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/> 
    					<uix:submitButton textBinding="OK@DGMsgBundle@servletRequest" formName="afoObserverForm" 
                  name="event" value="setObserver" disabledBinding="disableProtModeApply@servletRequest" shortDescBinding="OK@DGMsgBundle@servletRequest"/> 
	        </uix:contents>
      </uix:pageButtonBar>
      </uix:pageButtons>


	<uix:header textBinding="AFO_OBSERVER_PAGE_SUB_HEADER_1@DGMsgBundle@servletRequest">
     <uix:contents>
     <%--uix:header textBinding="AFO_OBSERVER_SUB_HEADER1@DGMsgBundle@servletRequest"--%>

      <uix:styledText styleClass="OraFieldText" 
                       textBinding="observerInfo@editProtBean@configBean@servletRequest"/>                
      <uix:tip renderedBinding="showCAOption@editProtBean@configBean@servletRequest">
         <uix:styledText textBinding="OBS_RESTART_ALT_HOST_TIP@DGMsgBundle@servletRequest"/>
      </uix:tip>
      <uix:spacer height="10"/>
      <uix:labeledFieldLayout labelWidth="23%">
       <uix:contents>

        <uix:messageLovField name="observerHost" id="observerHost"
              promptBinding="AFO_CONFIG_OBSERVER_HOSTNAME@DGMsgBundle@servletRequest"
              textBinding="observerHost@editProtBean@configBean@servletRequest"
              shortDescBinding="AFO_CONFIG_OBSERVER_SHORT_DESC@DGMsgBundle@servletRequest"
              searchDescBinding="AFO_CONFIG_OBSERVER_SHORT_DESC@DGMsgBundle@servletRequest"
              onClick = "setWindowSize(800,700); useCallBack(); setBindSqlParm('lovVersion'); startLov('observerHost', 'ListOracleHomes');"/>

        <uix:messagePrompt
                labeledNodeId="observerLoc"
                promptBinding="AFO_CONFIG_OBSERVER_HOME@DGMsgBundle@servletRequest"/>
        <uix:textInput 
                id="observerHome"
                name="observerHome"
                columns="40"
                textBinding="observerHome@editProtBean@configBean@servletRequest"/>


       <uix:messageCheckBox name="restartObserver" 
                           styleClass="OraFieldText" 
                           renderedBinding="showRestartObserver@editProtBean@configBean@servletRequest" 
                           textBinding="AFO_RESTART_OBSERVER@DGMsgBundle@servletRequest" 
                           messageBinding="AFO_RESTART_OBSERVER_TIP@DGMsgBundle@servletRequest" 
                           checkedBinding="restartObserver@editProtBean@configBean@servletRequest" 
                           value="true"/>

        <uix:spacer height="10"/>
        <uix:messageLovField name="altObserverHost" id="altObserverHost"
              renderedBinding="showCAOption@editProtBean@configBean@servletRequest"
              promptBinding="ALT_OBSERVER_HOSTNAME@DGMsgBundle@servletRequest"
              textBinding="altObserverHost@editProtBean@configBean@servletRequest"
              shortDescBinding="AFO_CONFIG_OBSERVER_SHORT_DESC@DGMsgBundle@servletRequest"
              searchDescBinding="AFO_CONFIG_OBSERVER_SHORT_DESC@DGMsgBundle@servletRequest"
              onClick = "setWindowSize(800,700); useCallBack(); setBindSqlParm('lovVersion'); startLov('altObserverHost', 'ListOracleHomes');"/>

        <uix:messagePrompt
                renderedBinding="showCAOption@editProtBean@configBean@servletRequest"
                labeledNodeId="altObserverHome"
               
                promptBinding="ALT_OBSERVER_HOME@DGMsgBundle@servletRequest"/>
        <uix:textInput 
                renderedBinding="showCAOption@editProtBean@configBean@servletRequest"
                id="altObserverHome"
                name="altObserverHome"
                columns="40"
                textBinding="altObserverHome@editProtBean@configBean@servletRequest"/>
       </uix:contents>
      </uix:labeledFieldLayout>
     </uix:contents>
	</uix:header>

	<uix:spacer height="10"/>
	
	<uix:header textBinding="AFO_OBSERVER_PAGE_SUB_HEADER_2@DGMsgBundle@servletRequest" renderedBinding="is110@configBean@servletRequest">
     <uix:contents>
      <uix:styledText styleClass="OraFieldText" textBinding="AFO_OBSERVER_CONNECT_ID_INTRO@DGMsgBundle@servletRequest"/>
      <uix:spacer height="10"/>
       <uix:labeledFieldLayout labelWidth="23%">
	      <uix:contents>
		     <uix:messageTextInput
                name="prmyDGAddress" 
                promptBinding="AFO_PRMY_OBSERVER_CONNECT_ID@DGMsgBundle@servletRequest"
                messageType="info" 
                longDescURL="<%=dbBean.getPropertyDest(StandbyProperties.OBS_CONNECT_ID)%>"

                textBinding="prmyDGAddress@editProtBean@configBean@servletRequest"
                messageBinding="AFO_PRMY_OBSERVER_CONNECT_ID_DESC@DGMsgBundle@servletRequest" 
                rows="3" columns="80"/>
		
              <uix:messageTextInput
                name="stbyDGAddress" 
                promptBinding="AFO_STBY_OBSERVER_CONNECT_ID@DGMsgBundle@servletRequest"
                messageType="info" 
                longDescURL="<%=dbBean.getPropertyDest(StandbyProperties.OBS_CONNECT_ID)%>"
                textBinding="stbyDGAddress@editProtBean@configBean@servletRequest"
                messageBinding="AFO_STBY_OBSERVER_CONNECT_ID_DESC@DGMsgBundle@servletRequest" 
                rows="3" columns="80"/>

        </uix:contents>
       </uix:labeledFieldLayout>
      </uix:contents>
	</uix:header>
     <%--/uix:header--%>

     <%--
     <uix:header textBinding="AFO_OBSERVER_SUB_HEADER2@DGMsgBundle@servletRequest" renderedBinding="showCAOption@editProtBean@configBean@servletRequest">

      <uix:styledText  styleClass="OraFieldText" textBinding="OBS_RESTART_TIP@DGMsgBundle@servletRequest"/>
      <uix:tip renderedBinding="noObserver@editProtBean@configBean@servletRequest"> 
         <uix:styledText textBinding="OBS_RESTART_ALT_HOST_TIP1@DGMsgBundle@servletRequest"/>
      </uix:tip>

      <uix:labeledFieldLayout width="90%" labelWidth="26%">
       <uix:contents>

        <uix:messageLovField name="altObserverHost" id="altObserverHost"
              promptBinding="ALT_OBSERVER_HOSTNAME@DGMsgBundle@servletRequest"
              textBinding="altObserverHost@editProtBean@configBean@servletRequest"
              shortDescBinding="AFO_CONFIG_OBSERVER_SHORT_DESC@DGMsgBundle@servletRequest"
              searchDescBinding="AFO_CONFIG_OBSERVER_SHORT_DESC@DGMsgBundle@servletRequest"
              onClick = "setWindowSize(800,700); useCallBack(); setBindSqlParm('lovVersion'); startLov('altObserverHost', 'ListOracleHomes');"/>

        <uix:messagePrompt
                labeledNodeId="altObserverHome"
               
                promptBinding="ALT_OBSERVER_HOME@DGMsgBundle@servletRequest"/>
        <uix:textInput 
                id="altObserverHome"
                name="altObserverHome"
                columns="40"
                textBinding="altObserverHome@editProtBean@configBean@servletRequest"/>

       </uix:contents>
      </uix:labeledFieldLayout>

     </uix:header>
     --%>

	      

     </uix:pageLayout>
    </db:form>
   </uix:body>

  </uix:document> 
</uix:renderingContext>
