<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<db:script src="/database/LOV.js"/>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext  id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

   <%@ include file="/completePPR.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="confirmVerifyTitle@processBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
    <db:form name="confirmVerifyForm" method="POST" destination="/em/console/database/dataguard" copyParams="target,type">
     <uix:pageLayout titleBinding="confirmVerifyHeader@processBean@servletRequest" messageType="confirmation">
      <uix:formValue name="pageEvent" value="confirmVerifySRL"/>
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest" 
                      titleTextKey="titleText" mainTextKey="mainText"/> 
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest" 
                      titleTextKey="titleText" mainTextKey="mainText"/>     
    
       <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>
          <uix:switcher childNameBinding="showData@processBean@servletRequest" defaultCase="false">
           <uix:case name="true">
            <uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="confirmVerifyForm" 
                name="event" value="cancelConfirmVerify"  shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/> 
            </uix:case>
            </uix:switcher>
            <uix:submitButton textBinding="OK@DGMsgBundle@servletRequest" formName="confirmVerifyForm" 
                  name="event" value="confirmVerify"  shortDescBinding="OK@DGMsgBundle@servletReques"/> 
          </uix:contents>
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:rowLayout renderedBinding="isNotDisplayOnlySRLTable@processBean@servletRequest">
          <uix:contents>
            <uix:spacer width="18"/>         
            <uix:styledText styleClass="OraInstructionTextStrong" textBinding="confirmVerifyWarningText@processBean@servletRequest"/>
            <uix:spacer width="5"/>         
            <uix:styledText styleClass="OraInstructionText" textBinding="CV_RESULTS@DGMsgBundle@servletRequest"/>
          </uix:contents> 
        </uix:rowLayout>

      <uix:switcher childNameBinding="showSRLS@processBean@servletRequest" defaultCase="false">
       <uix:case name="true">
        <uix:rowLayout>
          <uix:contents>
            <uix:spacer width="5"/>         
            <uix:styledText styleClass="OraInstructionTextStrong" textBinding="SRLS_RECOMMENDED@DGMsgBundle@servletRequest"/>
            <uix:spacer width="5"/>         
            <uix:styledText styleClass="OraInstructionText" textBinding="SRLS_OK@DGMsgBundle@servletRequest"/>
          </uix:contents> 
        </uix:rowLayout>
     </uix:case>
    </uix:switcher>

      <uix:header textBinding="CV_DETAILS@DGMsgBundle@servletRequest" renderedBinding="isNotDisplayOnlySRLTable@processBean@servletRequest">
          <uix:stackLayout>
            <uix:textInput shortDescBinding="CV_DETAILS@DGMsgBundle@servletRequest" textBinding="output@processBean@servletRequest" 
              readOnly="true" columns="80"  wrap="off" rows="16"/>
           </uix:stackLayout>
     </uix:header>   

  <%-- Inconsistent Properties - Begin --%>  
  <uix:switcher childNameBinding="showInconsistentProps@processBean@servletRequest" defaultCase="false">
   <uix:case name="true">

      <uix:header textBinding="CV_IPROPS@DGMsgBundle@servletRequest">
        <uix:rowLayout width="80%">
          <uix:contents>
            <uix:stackLayout>
             <uix:contents>
              <uix:styledText styleClass="OraFieldText" textBinding="CV_IPROPS_DESC@DGMsgBundle@servletRequest" />
              <uix:spacer height="2"/>         
              <uix:labeledFieldLayout labelWidth="30%">
               <uix:contents>
                 <uix:messageRadioButton 
                    name="fixProps" selected="true" value="useBroker"
                    promptBinding="CV_FIX_PROP@DGMsgBundle@servletRequest" 
                    textBinding="CV_FIX_BROKER@DGMsgBundle@servletRequest" />
                <uix:messageRadioButton 
                    name="fixProps" selected="false" value="useDatabase"
                    textBinding="CV_FIX_DB@DGMsgBundle@servletRequest" />
                 </uix:contents>
            </uix:labeledFieldLayout>
           </uix:contents> 
          </uix:stackLayout>
         </uix:contents> 
        </uix:rowLayout>

        <uix:contents>
        <oem:table name="ipropsTable" width="80%" beanKey="processBean" id="inconsistentProperties"
                dataSourceProp="inconsistentPropsTable" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest" 
                formSubmitted="true" destination="/em/console/database/dataguard/confirmProtMode"
                partialRenderMode="self" summaryBinding="CV_IPROPS@DGMsgBundle@servletRequest" >
        </oem:table>
        </uix:contents>
        <uix:tip>
          <uix:contents>
            <uix:styledText 
              textBinding="CV_IPROP_TIP@DGMsgBundle@servletRequest"/>
          </uix:contents>
        </uix:tip>
      </uix:header>
     </uix:case>
    </uix:switcher>
    <%-- Inconsistent Properties - end --%>

    <%-- Standby Redo Logs - Begin --%>
      <uix:switcher childNameBinding="showSRLS@processBean@servletRequest" defaultCase="false">
       <uix:case name="true">
       <uix:header textBinding="CV_SRLS@DGMsgBundle@servletRequest">
        <uix:rowLayout width="80%">
          <uix:contents>
            <uix:stackLayout>
             <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="CV_SRLS_DESC@DGMsgBundle@servletRequest"/>
              <uix:spacer height="5"/>         
              <uix:checkBox name="createSRLs" 
                            styleClass="OraFieldText" 
                            textBinding="CREATE_SRLS@DGMsgBundle@servletRequest" 
                            onClick="submitForm('confirmVerifyForm', true, {'event':'createSRLs'})"
                            checked="true" 
			    renderedBinding="isNotDisplayOnlySRLTable@processBean@servletRequest"
                            checkedBinding="createSRLs@servletRequest"
                            value="true"/>
              <uix:spacer height="5"/>         
            </uix:contents> 
         </uix:stackLayout>
        </uix:contents> 
        </uix:rowLayout> 

    <uix:rowLayout width="90%">
     <uix:messageCheckBox 
          name="useOMF" 
          styleClass="OraFieldText" 
          textBinding="SRL_OMF_CHECKBOX@DGMsgBundle@servletRequest" 
          checkedBinding="useOMF@verifyBean@configBean@servletRequest"
          renderedBinding="showOMFCheckbox@verifyBean@configBean@servletRequest"
          disabled="false"
          disabledBinding="disableSRLTable@servletRequest"
          value="true" 
          onClick="submitForm('confirmVerifyForm', true, {'event':'useOMFSRL'})"/>
    </uix:rowLayout>

    <uix:rowLayout width="80%" renderedBinding="showOMFCheckbox@verifyBean@configBean@servletRequest">
     <uix:contents>
      <uix:spacer width="22"/>			   
      <uix:styledText styleClass="OraInlineInfoText" textBinding="useOMFTip@verifyBean@configBean@servletRequest"/>
     </uix:contents>
    </uix:rowLayout>

        <uix:contents>
        <oem:table name="standbyRedoLogsTable" 
                   id="standbyRedoLogsTable" 
                   width="80%" 
                   blockSize="10"
                   beanKey="processBean" 
                   dataSourceProp="standbyRedoLogsTable" 
                   summaryBinding="CV_SRLS@DGMsgBundle@servletRequest"
                   formSubmitted="true"
                   shortDescBinding="CREATE_SRLS@DGMsgBundle@servletRequest">
        </oem:table>
        <uix:spacer width="3"/>
       </uix:contents>
      </uix:header>
     </uix:case>
    </uix:switcher>
    <%-- Standby Redo Logs - End --%>

     </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document> 
</uix:renderingContext>
