<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.dg.util.StandbyProperties" %>
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>
<db:script src="/database/dbclone/remoteSelector.js"/>
<db:script src="/database/LOV.js"/>
<SCRIPT LANGUAGE="JavaScript">

function disableNormalCreds() {
  createForm.mntrUserName.disabled = true;
  createForm.mntrPassword.disabled = true;
  createForm.mntrConfirmPassword.disabled = true;
}

function enableNormalCreds() {
  createForm.mntrUserName.disabled = false;
  createForm.mntrPassword.disabled = false;
  createForm.mntrConfirmPassword.disabled = false;
}

function enablePmryDGAddressField() {
  createForm.pmryDGAddress.disabled = false;
}

function disablePmryDGAddressField() {
  createForm.pmryDGAddress.disabled = true;
}

function enableStbyDGAddressField() {
  createForm.DGAddress.disabled = false;
}

function disableStbyDGAddressField() {
  createForm.DGAddress.disabled = true;
}

function disableOrEnableOnLoad() {
  disableOrEnableDGAddresses();
  if(createForm.mntrCreds)
  {
    if(createForm.mntrCreds[0].checked)
      enableNormalCreds();
    else
      disableNormalCreds();
  }
}

function disableOrEnableDGAddresses(){
  if(createForm.pmryDGAddressSelection)
  {
    if(createForm.pmryDGAddressSelection[0].checked)
      disablePmryDGAddressField();
    else
      enablePmryDGAddressField();
  }

  if(createForm.stbyDGAddressSelection)
  {
    if(createForm.stbyDGAddressSelection[0].checked)
      disableStbyDGAddressField();
    else
      enableStbyDGAddressField();
  }
}

</SCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
 <uix:document>

   <%@ include file="/database/dataguard/createHead.jspf" %>
   <uix:body onLoad="disableOrEnableOnLoad()">
   <db:form name="createForm" method="POST" destination="/console/database/dataguard/create" copyParams="target,type">
    <uix:pageLayout titleBinding="ADD_DRWIZ_OPTIONS_PAGE_TITLE@defaultMsgBundle@servletRequest">
      <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/dataguard/createTrain.jspf" %>
       <%@ include file="/database/dataguard/createNav.jspf" %>
       <%@ include file="/database/dataguard/createTop.jspf" %>
          <uix:formValue name="pageName" value="/database/dbclone/dbClone_DestConfig"/>
          <uix:formValue name="DGpageName" value="database/dataguard/createOptions"/>
          <uix:formValue name="lovName"/>
          <uix:formValue name="fetchType"/>

          <% if(createBean.getIsCreateNew()) { %>
          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>
          <uix:separator/>
          <% } %>

           <uix:stackLayout>

          <uix:header textBinding="ADD_DRWIZ_OPTIONS_PAGE_STBY_PARAMS@defaultMsgBundle@servletRequest">
            <uix:spacer height="3"/>

            <!-- Beginning of unique page content -->
            <uix:labeledFieldLayout labelWidth="20%">
             <uix:contents>
              <uix:messageTextInput
                name="destGlobalDbName"
                promptBinding="destGlobalDbName@defaultMsgBundle@servletRequest"
                textBinding="destGlobalDbName@defaultBean@servletRequest"
                messageBinding="ADD_DRWIZ_OPTIONS_PAGE_DBNAME_MSG@defaultMsgBundle@servletRequest"
                required="uiOnly"
                renderedBinding="showDBName@defaultBean@servletRequest"/>

              <uix:messageTextInput
                name="spName"
                promptBinding="spName@defaultMsgBundle@servletRequest"
                textBinding="spName@defaultBean@servletRequest"
                messageBinding="ADD_DRWIZ_OPTIONS_PAGE_SPNAME_MSG@defaultMsgBundle@servletRequest"
                required="uiOnly"
                messageType="info"
                renderedBinding="showSPName@defaultBean@servletRequest"
                longDescURL="<%=StandbyProperties.getPropertyDest11g(DGMsgID.spName)%>"/>

              <uix:messageTextInput
                name="stbyTargetName"
                promptBinding="stbyTargetName@defaultMsgBundle@servletRequest"
                textBinding="stbyTargetName@defaultBean@servletRequest"
                messageBinding="stbyTargetNameMsg@defaultBean@servletRequest"
                required="uiOnly"
                renderedBinding="isCreateNew@defaultBean@servletRequest"/>

              <uix:switcher childNameBinding="isCreateNew@defaultBean@servletRequest" defaultCase="false">
              <uix:case name="true">
              <uix:messageLovField id="stbyArchDest"
                name="stbyArchDest"
                disabledBinding="usingRecArea@defaultBean@servletRequest"
                renderedBinding="showSAL@defaultBean@servletRequest"
                promptBinding="StandbyArchiveLocation@defaultMsgBundle@servletRequest"
                textBinding="stbyArchDest@defaultBean@servletRequest"
                messageBinding="stbyArchDestMsg@defaultBean@servletRequest"
                required="uiOnly"
                onClickBinding = "stbyArchLOV@defaultBean@servletRequest"/>
             </uix:case>
             <uix:case name="false">
              <uix:messageTextInput id="stbyArchDest"
                name="stbyArchDest"
                disabledBinding="usingRecArea@defaultBean@servletRequest"
                renderedBinding="showSAL@defaultBean@servletRequest"
                promptBinding="StandbyArchiveLocation@defaultMsgBundle@servletRequest"
                textBinding="stbyArchDest@defaultBean@servletRequest"
                messageBinding="stbyArchDestMsg@defaultBean@servletRequest"
                required="uiOnly"/>
             </uix:case>
             </uix:switcher>
             </uix:contents>
            </uix:labeledFieldLayout>

            <uix:switcher childNameBinding="showRecArea@defaultBean@servletRequest" defaultCase="false">
             <uix:case name="true">
              <uix:labeledFieldLayout labelWidth="25%">
               <uix:contents>
                <uix:spacer height="0"/>
                <uix:stackLayout>
                 <uix:contents>

                  <uix:rowLayout renderedBinding="show10gFeatures@defaultBean@servletRequest">
                   <uix:contents>
                    <uix:spacer width="20"/>
                     <uix:radioButton name="destType"
                       onClick="submitForm('createForm', true, {'event':'destType'})"
                       value="REG_DEST"
                       selectedValueBinding="destType@defaultBean@servletRequest"
                       disabledBinding="disableSALChoice@defaultBean@servletRequest"
                       textBinding="ADD_DRWIZ_OPTIONS_PAGE_USE_DIR@defaultMsgBundle@servletRequest"/>
                   </uix:contents>
                  </uix:rowLayout>

                  <uix:rowLayout>
                   <uix:contents>
                    <uix:spacer width="20"/>
                    <uix:stackLayout>
                     <uix:contents>
                      <uix:messageRadioButton name="destType"
                       renderedBinding="show10gFeatures@defaultBean@servletRequest"
                       onClick="submitForm('createForm', true, {'event':'destType'})"
                       value="REC_AREA"
                       selectedValueBinding="destType@defaultBean@servletRequest"
                       disabledBinding="disableSALChoice@defaultBean@servletRequest"
                       textBinding="ADD_DRWIZ_OPTIONS_PAGE_USE_REC_AREA@defaultMsgBundle@servletRequest"/>
                      <uix:rowLayout>
                       <uix:contents>
                        <uix:spacer width="20"/>
                        <uix:messageTextInput
                          name="destSize"
                          disabledBinding="useRegDest@defaultBean@servletRequest"
                          columns="3"
                          promptBinding="destSize@defaultMsgBundle@servletRequest"
                          textBinding="destSize@defaultBean@servletRequest"
                          messageType="info"
                          longDescURL="<%=StandbyProperties.getPropertyDest11g(DGMsgID.destSize)%>"/>
                       </uix:contents>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:spacer width="20"/>
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="ADD_DRWIZ_OPTIONS_PAGE_SIZE_TIP@defaultMsgBundle@servletRequest"/>
                      </uix:rowLayout>

                      <uix:rowLayout renderedBinding="isPhysical@defaultBean@servletRequest" width="100%">
                        <uix:spacer width="20"/>
                        <uix:messageCheckBox
                             name="autoDelete"
                             styleClass="OraFieldText"
                             textBinding="ADD_DRWIZ_OPTIONS_PAGE_DELETION_POLICY@defaultMsgBundle@servletRequest"
                             checkedBinding="autoDelete@defaultBean@servletRequest"
                             messageBinding="ADD_DRWIZ_OPTIONS_PAGE_DELETION_POLICY_TIP@defaultMsgBundle@servletRequest"
                             value="true"
                             disabledBinding="useRegDest@defaultBean@servletRequest" />
                      </uix:rowLayout>

                     </uix:contents>
                    </uix:stackLayout>
                   </uix:contents>
                  </uix:rowLayout>

                 </uix:contents>
                </uix:stackLayout>

               </uix:contents>
              </uix:labeledFieldLayout>
             </uix:case>
            </uix:switcher>


            <uix:header textBinding="LOG_DEST_TITLE@defaultMsgBundle@servletRequest" renderedBinding="showLogDestTable@defaultBean@servletRequest">
             <uix:stackLayout>

             <uix:switcher childNameBinding="maxSites@defaultBean@servletRequest" defaultCase="false">
              <uix:case name="false">
              <uix:stackLayout>
               <uix:styledText styleClass="OraInstructionText" textBinding="LOG_DEST_INFO1_MATCH@defaultMsgBundle@servletRequest"/>
               <uix:spacer height="5"/>
               <uix:styledText styleClass="OraInstructionText" textBinding="LOG_DEST_INFO2_MATCH@defaultMsgBundle@servletRequest"/>
              </uix:stackLayout>
              </uix:case>
              <uix:case name="true">
              <uix:stackLayout>
               <uix:styledText styleClass="OraInstructionText" textBinding="LOG_DEST_INFO1_MAX@defaultMsgBundle@servletRequest"/>
               <uix:spacer height="5"/>
               <uix:styledText styleClass="OraInstructionText" textBinding="LOG_DEST_INFO2_MAX@defaultMsgBundle@servletRequest"/>
              </uix:stackLayout>
              </uix:case>
             </uix:switcher>

             <uix:spacer height="5"/>
             <uix:tip renderedBinding="showNoCancel@processBean@servletRequest">
              <uix:contents>
                <uix:styledText textBinding="LOG_DEST_TIP@defaultMsgBundle@servletRequest"/>
              </uix:contents>
             </uix:tip>
             <uix:spacer height="5"/>
               <uix:rowLayout width="95%">
                <uix:contents>
                 <oem:table name="logDestTable" beanKey="defaultBean" width="100%" dataSourceProp="logDestTable" alternateTextBinding="NO_DATA@defaultMsgBundle@servletRequest" formSubmitted="true" blockSize="10"
                        summaryBinding="LOG_DEST_TITLE@defaultMsgBundle@servletRequest" partialRenderMode="self" id="logDestTable">
                  <uix:tableSelection>
                   <uix:singleSelection selectedIndexBinding="selectedDest@defaultBean@servletRequest">
                    <uix:submitButton textBinding="SELECT_NONE@defaultMsgBundle@servletRequest" name="event" value="selectNone" formName="createForm" shortDescBinding="SELECT_NONE@defaultMsgBundle@servletRequest"/>
                   </uix:singleSelection>
                  </uix:tableSelection>
                 </oem:table>
                </uix:contents>
               </uix:rowLayout>

             </uix:stackLayout>
            </uix:header>
          </uix:header>

          <uix:header textBinding="DGMonitoringCreds@defaultMsgBundle@servletRequest" renderedBinding="isCreateNew@defaultBean@servletRequest" >
                <uix:stackLayout>
                  <uix:contents>

                  <uix:rowLayout renderedBinding="isPhysical@defaultBean@servletRequest" >
                     <uix:styledText textBinding="DGMntrNormalCredsMessage@defaultMsgBundle@servletRequest" styleClass="OraInstructionText" />
                  </uix:rowLayout>

                  <uix:rowLayout width="100%">
                    <uix:contents>
                      <uix:messageRadioButton name="mntrCreds"
                        value="NORMAL_CREDS"
                        textBinding="DGMntrNormalCreds@defaultMsgBundle@servletRequest"
                        selectedValueBinding="mntrCreds@defaultBean@servletRequest"
                        messageBinding="normalCredsMsg@defaultBean@servletRequest"
                        onClick="enableNormalCreds()"/>

                    </uix:contents>
                  </uix:rowLayout>

                  <uix:labeledFieldLayout labelWidth="20%">
                    <uix:contents>
                      <uix:messageTextInput name="mntrUserName"
                        promptBinding="DGMntrUserName@defaultMsgBundle@servletRequest"
                        textBinding="mntrUserName@defaultBean@servletRequest"
                        noAutoComplete="true"
                        columns="40"/>

                      <uix:messageTextInput name="mntrPassword"
                        promptBinding="DGMntrPassword@defaultMsgBundle@servletRequest"
                        textBinding="mntrPassword@defaultBean@servletRequest"
                        secret="true"
                        noAutoComplete="true"
                        columns="40"/>

                      <uix:messageTextInput name="mntrConfirmPassword"
                        promptBinding="DGMntrConfirmPassword@defaultMsgBundle@servletRequest"
                        textBinding="mntrConfirmPassword@defaultBean@servletRequest"
                        secret="true"
                        noAutoComplete="true"
                        columns="40"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>

                  <uix:rowLayout width="100%">
                    <uix:contents>
                      <uix:messageRadioButton name="mntrCreds"
                        value="SYSDBA_CREDS"
                        textBinding="DGMntrSYSDBACreds@defaultMsgBundle@servletRequest"
                        selectedValueBinding="mntrCreds@defaultBean@servletRequest"
                        tipBinding="DGMntrSYSDBACredsTip@defaultMsgBundle@servletRequest"
                        onClick="disableNormalCreds()"/>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:stackLayout>
          </uix:header>

          <uix:header textBinding="DG_HEAD@defaultMsgBundle@servletRequest" renderedBinding="showBrokerOption@defaultBean@servletRequest" >
           <uix:messageCheckBox
                name="useBroker"
		styleClass="OraFieldText"
                textBinding="ADD_DRWIZ_OPTIONS_PAGE_USE_BROKER@defaultMsgBundle@servletRequest"
                checkedBinding="useBroker@defaultBean@servletRequest"
                
                value="true" />
           <uix:rowLayout width="70%" renderedBinding="showBrokerOption@defaultBean@servletRequest">
             <uix:spacer width="20"/>
               <uix:styledText styleClass="OraInlineInfoText" textBinding="ADD_DRWIZ_OPTIONS_PAGE_USE_BROKER_TIP@defaultMsgBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:header>


         <uix:hideShowHeader
                       formSubmitted="true"
                       renderedBinding="is11g@defaultBean@servletRequest"
                       id="dgHideShow"
                       textBinding="DG_CONNECT_IDS@defaultMsgBundle@servletRequest"
                       disclosedBinding="advancedOptions@defaultBean@servletRequest">

          <uix:contents>

          <uix:stackLayout>
           <uix:contents>

           <uix:styledText styleClass="OraInstructionText" textBinding="DG_CONNECT_INTRO@defaultMsgBundle@servletRequest"/>
           <uix:tip> 
             <uix:styledText textBinding="DG_CONNECT_TIP@defaultMsgBundle@servletRequest"/>
           </uix:tip>

            <uix:labeledFieldLayout labelWidth="20%">
              <uix:contents>
                <uix:messageRadioButton name="pmryDGAddressSelection"
                  value="EM_CONNECT_IDENTIFIER"
                  textBinding="ConnectIDMessageExisting@defaultMsgBundle@servletRequest"
                  selectedValueBinding="pmryDGAddressSelection@defaultBean@servletRequest"
                  renderedBinding="showPmryDGAddress@defaultBean@servletRequest"
                  promptBinding="PrimaryDGConnectIdentifier@defaultMsgBundle@servletRequest"
                  required="uiOnly"
                  tipBinding="PrimaryConnectIdentifierDefaultTipExisting@defaultMsgBundle@servletRequest"
                  onClick="disablePmryDGAddressField()"/>

                <uix:messageRadioButton name="pmryDGAddressSelection"
                  value="CUSTOM_CONNECT_IDENTIFIER"
                  textBinding="ConnectIDMessage2@defaultMsgBundle@servletRequest"
                  renderedBinding="showPmryDGAddress@defaultBean@servletRequest"
                  selectedValueBinding="pmryDGAddressSelection@defaultBean@servletRequest"
                  prompt=" "
                  onClick="enablePmryDGAddressField()"/>

                <uix:messageTextInput
                  name="pmryDGAddress"
                  textBinding="pmryDGAddress@defaultBean@servletRequest"
                  tipBinding="PrimaryConnectIdentifierCustomTip@defaultMsgBundle@servletRequest"
                  renderedBinding="showPmryDGAddress@defaultBean@servletRequest"
                  rows="3" columns="80"/>
              </uix:contents>
            </uix:labeledFieldLayout>

            <uix:labeledFieldLayout labelWidth="20%">
              <uix:contents>
                <uix:messageRadioButton name="stbyDGAddressSelection"
                  value="EM_CONNECT_IDENTIFIER"
                  textBinding="ConnectIDMessageExisting@defaultMsgBundle@servletRequest"
                  selectedValueBinding="stbyDGAddressSelection@defaultBean@servletRequest"
                  promptBinding="StandbyDGConnectIdentifier@defaultMsgBundle@servletRequest"
                  required="uiOnly"
                  tipBinding="StandbyConnectIdentifierDefaultTipExisting@defaultMsgBundle@servletRequest"
                  onClick="disableStbyDGAddressField()"/>

                <uix:messageRadioButton name="stbyDGAddressSelection"
                  value="CUSTOM_CONNECT_IDENTIFIER"
                  textBinding="ConnectIDMessage2@defaultMsgBundle@servletRequest"
                  selectedValueBinding="stbyDGAddressSelection@defaultBean@servletRequest"
                  prompt=" "
                  onClick="enableStbyDGAddressField()"/>

                <uix:messageTextInput
                  name="DGAddress"
                  textBinding="DGAddress@defaultBean@servletRequest"
                  tipBinding="StandbyConnectIdentifierCustomTip@defaultMsgBundle@servletRequest"
                  renderedBinding="is11g@defaultBean@servletRequest"
                  rows="3" columns="80"/>
              </uix:contents>
            </uix:labeledFieldLayout>
           </uix:contents>
          </uix:stackLayout>

            </uix:contents>
          </uix:hideShowHeader>


            <!-- End of unique page content -->
           </uix:stackLayout>

    </uix:pageLayout>
   </db:form>
   </uix:body>
 </uix:document>
</uix:renderingContext>
