<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 
	 <%@ include file="/database/dataguard/createHead.jspf" %>

    <uix:body>
      <uix:contents>
       
    		<db:form name="createForm" method="post" destination="/console/database/dataguard/create" copyParams="target,type">
        <uix:formValue name="pageName" value="database/dataguard/createSchedule"/>
        <uix:formValue name="DGpageName" value="database/dataguard/createSchedule"/>
        
        <uix:pageLayout titleBinding="ADD_DRWIZ_SCHEDULE_PAGE_TITLE@defaultMsgBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
        	<%@ include file="/database/dataguard/createTrain.jspf" %>
          <%@ include file="/database/dataguard/createNav.jspf" %>
          <%@ include file="/database/dataguard/createTop.jspf" %>

          <%-- context info --%>
          <uix:pageStatus>
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="prmyDBName@defaultBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"
                    renderedBinding="showHost@defaultBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@defaultBean@servletRequest"
                    renderedBinding="showHost@defaultBean@servletRequest"/>
                </uix:labeledFieldLayout>
          </uix:pageStatus>
          <%-- end context info --%>

          <uix:separator/>

          <uix:tableLayout width="100%" summary="tl"> 
            <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="SCHEDULE_INSTRUCTION@dbCloneBundle@servletRequest"/>
              </uix:rowLayout>
          </uix:tableLayout>

          <%--.................. job ...................--%>	
          <uix:header textBinding="JOB_HEADER@dbCloneBundle@servletRequest">
            <uix:contents>

              <uix:labeledFieldLayout labelWidth="15%">
                <uix:contents>
                  <uix:messageTextInput id="jobName"
                    name="jobName"
                    promptBinding="JOB_NAME_PROMPT@dbCloneBundle@servletRequest"
                    textBinding="jobName@dbCloneBean@servletRequest"
                    columns="60" 
                    messageBinding="(JOB_NAME_PROMPT@dbCloneBundle@servletRequest)@messages@servletRequest"
                    messageTypeBinding="(JOB_NAME_PROMPT@dbCloneBundle@servletRequest)@messageTypes@servletRequest"
                    required="uiOnly"/>
                  <uix:messagePrompt labeledNodeId="jobDescription" promptBinding="DESCRIPTION_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:textInput id="jobDescription" name="jobDescription"
                    textBinding="jobDescription@dbCloneBean@servletRequest"
                    columns="60" />
                </uix:contents>
              </uix:labeledFieldLayout>

            </uix:contents>
          </uix:header>
             
          <%--...................... schedule .......................--%>
          <%@ include file="/sdk/schedule/start.jspf"%>
          
        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
