<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<db:script src="/database/dbclone/remoteSelector.js"/>
<db:script src="/database/LOV.js"/>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
 <uix:document> 		
	 <%@ include file="/database/dataguard/createHead.jspf" %>
	 <uix:body>
    <uix:contents>
   <db:form name="createForm" method="post" destination="/console/database/dataguard/create" copyParams="target,type">
		<uix:pageLayout titleBinding="sourcePageTitle@defaultBean@servletRequest">
			<%@	include file="/database/global.jspf" %>
     	<%@ include file="/database/dataguard/createTrain.jspf" %>
      <%@ include file="/database/dataguard/createNav.jspf" %>
      <%@ include file="/database/dataguard/createTop.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

            <uix:formValue name="pageName" value="/database/dbclone/dbClone_SourceOptions"/>
            <uix:formValue name="DGpageName" value="database/dataguard/createSource"/>
	    <uix:formValue name="lovName"/>
            <uix:formValue name="fetchType"/>

            <uix:pageStatus>
                <uix:labeledFieldLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SOURCE_DBNAME_PROMPT@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="prmyDBName@defaultBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="SOURCE_HOSTNAME_PROMPT@dbCloneBundle@servletRequest"
                    renderedBinding="showHost@defaultBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="srcHostName@defaultBean@servletRequest"
                    renderedBinding="showHost@defaultBean@servletRequest"/>
                </uix:labeledFieldLayout>
          </uix:pageStatus>
          <uix:separator/>
					
						<uix:stackLayout>

              <!-- Beginning of unique page content -->
              <%@ include file="/database/dbclone/sourceBackupSet.jspf" %>
              <!-- End of unique page content -->

<%-- Standby Redo Logs - Begin --%>

  <uix:header textBinding="PM_EDIT_SRL_PRMY_HEADER@defaultMsgBundle@servletRequest" renderedBinding="showSRLTable@addBean@defaultBean@servletRequest">

    <uix:rowLayout width="90%">
      <uix:contents>
        <uix:stackLayout>
         <uix:contents>
          <uix:styledText styleClass="OraFieldText" labeledNodeId="standbyRedoLogsTable"
                  textBinding="PM_EDIT_SRL_UPGRADE_PRMY_INFO@defaultMsgBundle@servletRequest"/>
          <uix:spacer height="10"/>			   
        </uix:contents>	
     </uix:stackLayout>
    </uix:contents>	
    </uix:rowLayout>

    <uix:rowLayout width="90%">
     <uix:messageCheckBox 
          name="useOMF" 
          styleClass="OraFieldText" 
          textBinding="SRL_OMF_CHECKBOX@defaultMsgBundle@servletRequest" 
          checkedBinding="useOMF@standbyRedoLogsTable@defaultBean@servletRequest"
          renderedBinding="showOMFCheckbox@standbyRedoLogsTable@defaultBean@servletRequest"
          messageBinding="useOMFTip@addBean@defaultBean@servletRequest"
          value="true" 
          onClick="submitForm('createForm', true, {'event':'useOMFSRL'})"/>
    </uix:rowLayout>

    <uix:contents>
    <oem:table name="standbyRedoLogsTable" 
               id="standbyRedoLogsTable" 
               blockSize="10"
               partialRenderMode="self"
               width="80%" 
               beanKey="defaultBean" 
               dataSourceProp="standbyRedoLogsTable" 
               summaryBinding="PM_EDIT_SRL_SRL_HEADER@defaultMsgBundle@servletRequest"
               alternateTextBinding="SRL_COUNT_OK@defaultMsgBundle@servletRequest" 
               shortDescBinding="SELECT@DBMsgBundle@servletRequest" 
               formSubmitted="true"> 
    </oem:table>
    <uix:spacer width="4"/>
    </uix:contents>

  </uix:header>

						</uix:stackLayout>

    </uix:pageLayout>
		</db:form>
    </uix:contents>
	 </uix:body>
 </uix:document> 
</uix:renderingContext> 
