<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
 <uix:document> 		
	 <%@ include file="/database/dataguard/createHead.jspf" %>
	 <uix:body>
   <db:form name="createForm" method="POST" destination="/console/database/dataguard/create" copyParams="target,type">
		<uix:pageLayout titleBinding="summaryPageTitle@defaultBean@servletRequest">
			<%@	include file="/database/global.jspf" %>
    	<%@ include file="/database/dataguard/createTrain.jspf" %>
      <%@ include file="/database/dataguard/createNav.jspf" %>
      <%@ include file="/database/dataguard/createTop.jspf" %>

      <uix:formValue name="pageName" value="database/dataguard/createSummary"/>
      <uix:formValue name="DGpageName" value="database/dataguard/createSummary"/>

  		 <uix:stackLayout>
        <!-- Beginning of unique page content -->
        <uix:formattedText styleClass="OraInstructionText" textBinding="summaryIntro@defaultBean@servletRequest"/> 

        <%--
         
        <uix:spacer height="10"/>

        <% if(createBean.getIsCreateNew() && createBean.getIsStandbyCreation()) { %>
          <uix:formattedText styleClass="OraInstructionText" textBinding="jobMsg@defaultBean@servletRequest"/>
        <% } %>
        --%>

          <%--.................. Details ........................--%>
            
          <uix:tableLayout width="100%" cellSpacing="2" summary="tl">           
            <uix:rowLayout vAlign="top">
	
          <%-- Source database or backup files related options --%>
              <uix:header textBinding="SITE_TYPE_PRIMARY@defaultMsgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="45%">

        <% if(createBean.getIsCreateNew()) { %>
                   <uix:styledText styleClass="OraPromptText" textBinding="stbyTargetName@defaultMsgBundle@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="prmyTarget@defaultBean@servletRequest"/>

                    <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="sourceDBName@defaultBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="SID_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcSID@defaultBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="DB_VERSION_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="compatibleDbVersion@defaultBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcOracleHome@defaultBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="HOST_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcHostName@defaultBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@dbCloneBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="compatibleOSType@defaultBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="compatibleOSVersion@defaultBean@servletRequest"/>
                    </uix:flowLayout>
                    <uix:messagePrompt promptBinding="HOST_USERNAME@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcHostUserName@defaultBean@servletRequest"/>
                   <uix:switcher childNameBinding="showExBkpLocOnDest@defaultBean@servletRequest" renderedBinding="showBackupSetLocation@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:messagePrompt promptBinding="ADD_DRWIZ_SUMMARY_BU_DIR@defaultMsgBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="false">
                     <uix:messagePrompt promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"/>
                    </uix:case>
                   </uix:switcher>

                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="srcBsLocation@defaultBean@servletRequest"
                      renderedBinding="showBackupSetLocation@defaultBean@servletRequest"/>

                    <uix:messagePrompt promptBinding="RETAIN_WORKING_DIRECTORY@dbCloneBundle@servletRequest" renderedBinding="showExBkpLocOnSrc@defaultBean@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="retainWorkingDir@defaultBean@servletRequest" renderedBinding="showExBkpLocOnSrc@defaultBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="DG_COMPRESS_FILES@dbCloneBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="compressBackupFilesForUI@defaultBean@servletRequest"/>
        <% } else { %>
                   <uix:styledText styleClass="OraPromptText" textBinding="stbyTargetName@defaultMsgBundle@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="prmyTarget@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraPromptText" textBinding="HOST@defaultMsgBundle@servletRequest" renderedBinding="showHost@defaultBean@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="hostName@prmySite@addBean@defaultBean@servletRequest" renderedBinding="showHost@defaultBean@servletRequest"/>
                  
        <% } %>
                  </uix:labeledFieldLayout>
                </uix:contents>	
              </uix:header>

          <%-- Destination Oracle Home related options --%>
          <uix:header textBinding="SITE_TYPE_STANDBY@defaultMsgBundle@servletRequest" renderedBinding="isStandbyCreation@defaultBean@servletRequest">
            <uix:contents>

              <uix:labeledFieldLayout labelWidth="45%">
        <% if(createBean.getIsCreateNew()) { %>
                   <uix:styledText styleClass="OraPromptText" textBinding="stbyTargetName@defaultMsgBundle@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="stbyTargetName@defaultBean@servletRequest"/>

                <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@dbCloneBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="destGlobalDbName@defaultBean@servletRequest"/>
                <uix:messagePrompt promptBinding="SID_PROMPT@dbCloneBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="destSid@defaultBean@servletRequest"/>
                <uix:messagePrompt promptBinding="COL_ORACLE_SERVER_VER@dbCloneBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="destHomeVersion@defaultBean@servletRequest"/>
                <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@dbCloneBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="destOracleHome@defaultBean@servletRequest"/>
                <uix:messagePrompt promptBinding="HOST_PROMPT@dbCloneBundle@servletRequest"/>      
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="destHostName@defaultBean@servletRequest"/>
                <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@dbCloneBundle@servletRequest"/>
                <uix:flowLayout>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="destOSType@defaultBean@servletRequest"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="destOSVersion@defaultBean@servletRequest"/>
                </uix:flowLayout>
                <uix:messagePrompt promptBinding="HOST_USERNAME@dbCloneBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                    textBinding="destHostUserName@defaultBean@servletRequest"/>
                <uix:messagePrompt promptBinding="ADD_DRWIZ_SUMMARY_BU_TYPE@defaultMsgBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="backupTypeStr@defaultBean@servletRequest"/>

                   <uix:switcher childNameBinding="isExBkpOnStby@defaultBean@servletRequest" renderedBinding="isDiffHost@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:messagePrompt promptBinding="ADD_DRWIZ_SUMMARY_BU_DIR@defaultMsgBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="false">
                     <uix:messagePrompt promptBinding="BS_LOCATION_PROMPT@dbCloneBundle@servletRequest"/>
                    </uix:case>
                   </uix:switcher>

                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="destBsLocation@defaultBean@servletRequest"
                  renderedBinding="isDiffHost@defaultBean@servletRequest"/>

                <uix:switcher childNameBinding="fileTransferUsed@defaultBean@servletRequest" renderedBinding="isDiffHost@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:messagePrompt promptBinding="TRANSFER_FILE_MECHANISM@dbCloneBundle@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:messagePrompt promptBinding="BACKUP_SET_LOCATION_HEADER@dbCloneBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="fileTransferUsed@defaultBean@servletRequest" renderedBinding="isDiffHost@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="fileTransferMechanism@defaultBean@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                   <uix:switcher childNameBinding="isExBkpOnStby@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="ADD_DRWIZ_SUMMARY_BU_ON_STBY@defaultMsgBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText styleClass="OraInstructionTextStrong" 
                        textBinding="ADD_DRWIZ_SUMMARY_SHARE_FILES@defaultMsgBundle@servletRequest"/>
                    </uix:case>
                   </uix:switcher>

                  </uix:case>
                </uix:switcher>

                <uix:styledText styleClass="OraPromptText" textBinding="spName@defaultMsgBundle@servletRequest" renderedBinding="showSPName@defaultBean@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="spName@defaultBean@servletRequest" renderedBinding="showSPName@defaultBean@servletRequest"/>

                <uix:messagePrompt promptBinding="DEST_DB_STORAGE@dbCloneBundle@servletRequest" renderedBinding="convertASMFlag@defaultBean@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" renderedBinding="convertASMFlag@defaultBean@servletRequest"
                      textBinding="storageTypeForReview@dbCloneBean@servletRequest"/>
                      
                 <uix:messageStyledText promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest" 
                      styleClass="OraInstructionTextStrong" textBinding="asmInstance@convertBean@servletRequest"
                      renderedBinding="convertASMFlag@dbCloneBean@servletRequest"/>

        <% } else { %>
                   <uix:styledText styleClass="OraPromptText" textBinding="stbyTargetName@defaultMsgBundle@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="stbyTargetName@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraPromptText" textBinding="HOST@defaultMsgBundle@servletRequest" renderedBinding="showStbyHost@defaultBean@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="hostName@stbySite@addBean@defaultBean@servletRequest" renderedBinding="showStbyHost@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraPromptText" textBinding="CLUSTER@defaultMsgBundle@servletRequest" renderedBinding="showStbyCluster@defaultBean@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="clusterName@stbySite@addBean@defaultBean@servletRequest" renderedBinding="showStbyCluster@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraPromptText" textBinding="spName@defaultMsgBundle@servletRequest" renderedBinding="showSPName@defaultBean@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="spName@defaultBean@servletRequest" renderedBinding="showSPName@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraPromptText" textBinding="destSid@defaultMsgBundle@servletRequest" renderedBinding="showStbyHost@defaultBean@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="destSid@defaultBean@servletRequest" renderedBinding="showStbyHost@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraPromptText" textBinding="ORACLE_HOME@defaultMsgBundle@servletRequest"/>
                   <uix:styledText styleClass="OraInstructionTextStrong" textBinding="destOracleHome@defaultBean@servletRequest"/>

        <% } %>
               <uix:styledText styleClass="OraPromptText" textBinding="ADD_DRWIZ_SUMMARY_PAGE_STANDBY_TYPE@defaultMsgBundle@servletRequest"/>
               <uix:styledText styleClass="OraInstructionTextStrong" textBinding="typeString@defaultBean@servletRequest"/>

                <uix:messagePrompt renderedBinding="showDGOMF@defaultBean@servletRequest" promptBinding="DATABASE_AREA_LOC@dbCloneBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  renderedBinding="showDGOMF@defaultBean@servletRequest"
                  textBinding="databaseAreaForReview@dbCloneBean@servletRequest"/>

                <uix:messagePrompt renderedBinding="useRecArea@defaultBean@servletRequest" promptBinding="RECOVERY_AREA_LOC@dbCloneBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  renderedBinding="useRecArea@defaultBean@servletRequest"
                  textBinding="recoveryAreaForReview@dbCloneBean@servletRequest"/>

               <uix:styledText styleClass="OraPromptText" textBinding="stbyArchDest@defaultMsgBundle@servletRequest" renderedBinding="showStbyArchDest@defaultBean@servletRequest"/>
               <uix:styledText styleClass="OraInstructionTextStrong" textBinding="stbyArchDestDisplay@defaultBean@servletRequest" renderedBinding="showStbyArchDest@defaultBean@servletRequest"/>

               <uix:styledText styleClass="OraPromptText" textBinding="destSize@defaultMsgBundle@servletRequest" renderedBinding="useRecArea@defaultBean@servletRequest"/>
               <uix:styledText styleClass="OraInstructionTextStrong" 
                               textBinding="recAreaSize@defaultBean@servletRequest"
                               renderedBinding="useRecArea@defaultBean@servletRequest"/>
               <uix:styledText styleClass="OraPromptText" textBinding="ADD_DRWIZ_SUMMARY_AUTO_DELETE@defaultMsgBundle@servletRequest" renderedBinding="useRecArea@defaultBean@servletRequest"/>
                <uix:switcher childNameBinding="autoDelete@defaultBean@servletRequest" renderedBinding="useRecArea@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="YES@defaultMsgBundle@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="NO@defaultMsgBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>

              </uix:labeledFieldLayout>	
            </uix:contents>	
          </uix:header>

         </uix:rowLayout>                
        </uix:tableLayout> 

        <% if(createBean.getIsCreateNew() && createBean.getIsStandbyCreation()) { %>
          <uix:hideShowHeader disclosedBinding="showDatabaseFiles@dbCloneBean@servletRequest"
            formSubmitted="true" id="hideShow"
            textBinding="databaseFileLocationsHeaderForReview@dbCloneBean@servletRequest">
            <uix:contents>
    
              <uix:stackLayout>
                <uix:contents>
                
                  <uix:spacer height="10" />
                  
                  <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messageStyledText promptBinding="DATABASE_AREA_FILE_LOCATIONS_HEADER@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="databaseAreaForReview@dbCloneBean@servletRequest"
                      renderedBinding="showOMFSpecForReview@dbCloneBean@servletRequest"/> 
                    <uix:messageStyledText promptBinding="RECOVERY_AREA_FILE_LOCATIONS_HEADER@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="recoveryAreaForReview@dbCloneBean@servletRequest"
                      renderedBinding="showRecoveryAreaSpecForReview@dbCloneBean@servletRequest"/> 
                    <uix:messageStyledText promptBinding="MULTIPLEX_LOG_CTL_FILES@dbCloneBundle@servletRequest"
                      styleClass="OraInstructionTextStrong" textBinding="multiplexLocationsForReview@dbCloneBean@servletRequest"
                      renderedBinding="showOMFSpecForReview@dbCloneBean@servletRequest"/> 
                  </uix:labeledFieldLayout>
                  
                  <uix:header textBinding="dataFilesHeaderForReview@dbCloneBean@servletRequest"
                    renderedBinding="showDataFilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewDatafileListTable"
                        summaryBinding="dataFilesHeaderForReview@dbCloneBean@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewDatafileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="TEMPFILES_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="showTempfilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        summaryBinding="TEMPFILES_HEADER@dbCloneBean@servletRequest"
                        name="reviewTempfileListTable"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewTempfileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="LOGFILES_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="showLogFilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewLogfileListTable"
                        summaryBinding="LOGFILES_HEADER@dbCloneBean@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewLogfileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="CONTROLFILES_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="showControlFilesForReview@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%"
                        blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewControlfileListTable"
                        summaryBinding="CONTROLFILES_HEADER@dbCloneBean@servletRequest"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        dataSourceProp="reviewControlfileListTable"
                        copyParams="target,type,cancelURL,oname"/>  
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="DIR_OBJ_HEADER@dbCloneBundle@servletRequest">
                    <uix:contents>
                      <oem:table width="80%" blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewDirectoryObjListTable"
                        beanKey="dbCloneBean"
                        formSubmitted="true"
                        summaryBinding="DIR_OBJ_HEADER@dbCloneBean@servletRequest"
                        dataSourceProp="reviewDirectoryObjListTable"
                        copyParams="target,type,cancelURL,oname"/>
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="EXTERNAL_FILE_HEADER@dbCloneBundle@servletRequest"
                    renderedBinding="is9iOrHigher@dbCloneBean@servletRequest">
                    <uix:contents>
                      <oem:table width="80%" blockSize="10"
                        alternateTextBinding="NO_ITEMS_FOUND@dbCloneBundle@servletRequest"
                        name="reviewExternalFileListTable"
                        beanKey="dbCloneBean"
                        summaryBinding="EXTERNAL_FILE_HEADER@dbCloneBean@servletRequest"
                        formSubmitted="true"
                        dataSourceProp="reviewExternalFileListTable"
                        copyParams="target,type,cancelURL,oname"/>
                    </uix:contents>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>

            </uix:contents>
          </uix:hideShowHeader>
        <% } %>
       <!-- End of unique page content -->

			</uix:stackLayout>

    </uix:pageLayout>
	 </db:form>
	 </uix:body>
 </uix:document> 
</uix:renderingContext> 
              
