<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/completePPR.jspf" %>
    <uix:metaContainer> 
      <uix:head titleBinding="configTitle@configBean@servletRequest"/> 
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %>>
    </uix:metaContainer> 
    <uix:body>
     <db:form name="configForm" method="post" destination="/em/console/database/dataguard" copyParams="target,type">
      <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <%--  start Info/error/refresh section --%>
        <oem:messageBox messageType="info"       
                        destTableBinding="msgUrls@servletRequest"
                        errorTableBinding="info@servletRequest" 
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <oem:messageBox messageType="error" 
                        destTableBinding="errorUrls@servletRequest"
                        errorTableBinding="errors@servletRequest" 
                        titleTextKey="titleText" mainTextKey="mainText"/>     
        <oem:messageBox messageType="confirmation" 
                        errorTableBinding="confirmation@servletRequest" 
                        titleTextKey="titleText" mainTextKey="mainText"/>     
         <%--  end Info/error section --%>

        <uix:header textBinding="configHeader@configBean@servletRequest">

        <%  String valid = (String)request.getAttribute("validConfig"); 
            if (valid == null || (valid != null && valid.equals("true"))) {
        %>
         <%-- Refresh/View Data --%>
        <uix:tableLayout width="100%"  summary="tl"> 
        
            <uix:rowLayout>

               <uix:cellFormat hAlign="left"  headers=""> 
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="timestamp@configBean@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>
        
          <uix:cellFormat hAlign="right" vAlign="center"  headers=""> 
            <uix:styledText textBinding="VIEW_DATA_LABEL@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice" styleClass="OraInstructionText"/>
            <uix:spacer width="5"/>
            <uix:choice name="refreshChoice" id="refreshChoice" onChange="submitForm('configForm', true, {'event':'doLoad'})"
                selectedValueBinding="refreshChoice@servletRequest" >
              <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="99999" />
              <uix:option textBinding="REAL_TIME_30_SEC@DBMsgBundle@servletRequest" value="30" />
              <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest" value="60" />
              <uix:option textBinding="REAL_TIME_5_MIN@DBMsgBundle@servletRequest" value="300" />
            </uix:choice>

         </uix:cellFormat>       
              <uix:cellFormat hAlign="right" vAlign="center"  headers=""> 
              <uix:contents>
                  <uix:image sourceBinding="refreshImage@servletRequest" 
                           destinationBinding="homePageDest@configBean@servletRequest"
                           shortDescBinding="REFRESH_PAGE@DGMsgBundle@servletRequest" />
             </uix:contents>
         </uix:cellFormat>       
        </uix:rowLayout>
       </uix:tableLayout>
         <%-- end of Refresh/View Data --%>
        
        <%  } %>

        <%-- The following scriptlet shows the rest of the page if data guard is enabled. --%>        
        
          <%  
              if (valid == null || (valid != null && valid.equals("true"))) {
          %>

          <uix:tableLayout width="100%" summary="tl"> 
           <uix:contents>

             <%--  start General section --%>
              <uix:cellFormat vAlign="top" width="45%" headers=""> 
               <uix:contents>
                <uix:stackLayout>
                 <uix:contents>

                  <uix:header textBinding="DG_OVERVIEW@DGMsgBundle@servletRequest">
                      <uix:borderLayout>
                       <uix:contents>
                         <uix:labeledFieldLayout labelWidthBinding="overviewWidth@servletRequest">
                           <uix:contents>
                        
                            <uix:messagePrompt promptBinding="OVERALL_STATUS@DGMsgBundle@servletRequest"/>
                            <uix:rowLayout>
                             <uix:contents>
                              <uix:image sourceBinding="configStatusIcon@configBean@servletRequest" shortDescBinding="configStatus@configBean@servletRequest"/>
                              <uix:spacer width="5"/>
                              <uix:styledText styleClass="OraDataText" textBinding="configStatus@configBean@servletRequest" />
                            </uix:contents>
                            </uix:rowLayout>

                            <uix:messagePrompt promptBinding="PROT_MODE@DGMsgBundle@servletRequest"/>
                            <uix:link 
                                 textBinding="protectionModeString@configBean@servletRequest" 
                                 destinationBinding="editProtDest@configBean@servletRequest"
                                 disabledBinding="isSAMode@servletRequest"/>
                            <uix:messagePrompt 
                                 renderedBinding="is102@configBean@servletRequest"
                                 promptBinding="AUTO_FAILOVER@DGMsgBundle@servletRequest"/>
                            <uix:link 
                                 renderedBinding="is102@configBean@servletRequest"
                                 disabledBinding="isSAMode@servletRequest"
                                 textBinding="afoModeString@configBean@servletRequest" 
                              destinationBinding="editAfoDest@configBean@servletRequest"/>
                            <uix:messagePrompt 
                                 renderedBinding="showObserver@configBean@servletRequest"
                                 promptBinding="AFO_CONFIG_OBSERVER_HOST@DGMsgBundle@servletRequest"/>
                            <uix:styledText styleClass="OraDataText" 
                                            renderedBinding="showObserver@configBean@servletRequest"
                                            textBinding="afoObserver@configBean@servletRequest"/>

                            </uix:contents>
                           </uix:labeledFieldLayout>
                       </uix:contents>        
                      </uix:borderLayout>
                  </uix:header>

                  <uix:header textBinding="primaryDBHeader@configBean@servletRequest">
                      <uix:borderLayout>
                       <uix:contents>
                         <uix:labeledFieldLayout labelWidthBinding="overviewWidth@servletRequest">
                           <uix:contents>
                        
                            <uix:messagePrompt promptBinding="NAME@DGMsgBundle@servletRequest"/>
                            <uix:link textBinding="configName@configBean@servletRequest" 
                              destinationBinding="primaryDBDest@configBean@servletRequest"/>
                    
                            <uix:messagePrompt promptBinding="primaryHostLabel@configBean@servletRequest"/>

                            <uix:switcher childNameBinding="hostLink@configBean@servletRequest" defaultCase="false">
                            <uix:case name="true">

                            <uix:link textBinding="primaryHostName@configBean@servletRequest" 
                              destinationBinding="primaryHostDest@configBean@servletRequest"/>
                            </uix:case>
                            <uix:case name="false">
                            <uix:styledText styleClass="OraDataText" textBinding="primaryHostName@configBean@servletRequest" />
                            </uix:case>
                            </uix:switcher> 

                            <uix:messagePrompt promptBinding="OVERALL_STATUS@DGMsgBundle@servletRequest"/>
                            <uix:rowLayout>
                             <uix:contents>
                              <uix:image sourceBinding="primaryStatus@configBean@servletRequest" shortDescBinding="configStatusText@configBean@servletRequest"/>
                              <uix:spacer width="5"/>
                              <uix:link textBinding="configStatusText@configBean@servletRequest" 
                                destinationBinding="editPrimaryDBDest@configBean@servletRequest"/>
                            </uix:contents>
                            </uix:rowLayout>

                            <uix:messagePrompt promptBinding="CURRENT_LOG@DGMsgBundle@servletRequest"/>
                            <uix:link textBinding="currentLog@configBean@servletRequest" 
                              destinationBinding="logSummaryDest@configBean@servletRequest"/>

                            <uix:messagePrompt promptBinding="EDIT_PROPERTIES@DGMsgBundle@servletRequest"/>
                            <uix:link textBinding="EDIT@DGMsgBundle@servletRequest"
                                destinationBinding="editPrimaryDBDest@configBean@servletRequest"/>

                            </uix:contents>
                           </uix:labeledFieldLayout>
                       </uix:contents>
                      </uix:borderLayout>
                    </uix:header>
                   </uix:contents>
                  </uix:stackLayout>
               </uix:contents>
              </uix:cellFormat>
             <%--  end General section --%>

             <%--  start PDL Chart section --%>
              <uix:cellFormat vAlign="top" width="55%"  renderedBinding="isEnterpriseMode@servletRequest"  headers=""> 
               <uix:contents>
                <uix:header textBinding="SPS@DGMsgBundle@servletRequest" >
                <uix:stackLayout>
                 <uix:contents>

                <uix:rowLayout>
                <uix:contents>
                <uix:styledText styleClass="OraInlineInfoText" 
                    textBinding="chartDesc@configBean@servletRequest"/>
                </uix:contents>
                </uix:rowLayout>

                   <oem:chart 
                        chartType="barChart"
                        orientationBinding="chartOrientation@configBean@servletRequest"
                        yAxisLabelBinding="chartUnits@configBean@servletRequest"
                        heightBinding="chartHeight@configBean@servletRequest" 
                        widthBinding="chartWidth@configBean@servletRequest"
                        barLabelling="out"
                        shadowEffect="3d"
                        legendPositionBinding="chartLegendPosition@configBean@servletRequest"
                        legendVisible="true"
                         >
                      <uix:contents>
                        <oem:boundChartDataSource 
                          chartDataSourceBinding="applyBehindChart@configBean@servletRequest" />
                        <oem:chartColumn
                          displayLabel="Name"
                          sourceIndex="0" 
                          isKey="true" 
                        />
                        <oem:chartColumn
                          displayLabelBinding="titlePDL@configBean@servletRequest" 
                          sourceIndex="1"
                        />
                        <oem:chartColumn
                          displayLabelBinding="titleRNA@configBean@servletRequest" 
                          sourceIndex="2"
                        />
                      </uix:contents>
                    </oem:chart>

                 </uix:contents>
                </uix:stackLayout>
                </uix:header>
               </uix:contents>
              </uix:cellFormat>
          <%--  end PDL Chart section --%>

        </uix:contents>
       </uix:tableLayout>

        <%--  start Standby Database section --%>
        <uix:header textBinding="STBY_DB@DGMsgBundle@servletRequest">
        <uix:contents>
          <uix:tableLayout width="100%" summary="tl"> 
            <uix:contents>
              <uix:rowLayout hAlign="right">
                <db:button textBinding="ADD_STBY_DB@DGMsgBundle@servletRequest" 
                  shortDescBinding="ADD_STBY_DB@DGMsgBundle@servletRequest" 

                  disabledBinding="isSAMode@servletRequest"
                  destination="/em/console/database/dataguard/create" copyParams="target,type"/>
              </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>  

        <oem:table name="dbList" width="100%" beanKey="configBean" dataSourceProp="DBList" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest"  
            summaryBinding="STBY_DB@DGMsgBundle@servletRequest" formSubmitted="true" destination="/console/database/dataguard/dataguardConfig"> 
          <uix:tableSelection> 
           <uix:singleSelection shortDescBinding="SELECT@DBMsgBundle@servletRequest" selectedIndex="0">
            <uix:submitButton textBinding="EDIT@DGMsgBundle@servletRequest" name="event" value="editDatabase" formName="configForm" shortDescBinding="EDIT@DGMsgBundle@servletRequest"/> 
            <uix:submitButton textBinding="REMOVE@DGMsgBundle@servletRequest" name="event" value="confirmRemoveDatabase" formName="configForm" shortDescBinding="REMOVE@DGMsgBundle@servletRequest"/> 
            <uix:submitButton disabledBinding="isSAMode@servletRequest" textBinding="SWITCHOVER@DGMsgBundle@servletRequest" name="event" value="switchover" formName="configForm" shortDesc="SWITCHOVER@DGMsgBundle@servletRequest"/> 
            <uix:submitButton disabledBinding="isSAMode@servletRequest" textBinding="FAILOVER@DGMsgBundle@servletRequest"  name="event" value="failover" formName="configForm" shortDescBinding="FAILOVER@DGMsgBundle@servletRequest"/> 
	    <uix:submitButton renderedBinding="is110@configBean@servletRequest" disabledBinding="isSAMode@servletRequest" textBinding="CONVERT@DGMsgBundle@servletRequest"  name="event" value="convert" formName="configForm" shortDescBinding="CONVERT@DGMsgBundle@servletRequest"/> 
           </uix:singleSelection>
          </uix:tableSelection>
        </oem:table>
         <uix:spacer width="4"/>  
        </uix:contents> 
        </uix:header>
        <%--  end Standby Database section --%>
          
        <%--  start Links section --%>
        <uix:tableLayout width="100%" summary="tl"> 
         <uix:contents>

            <uix:cellFormat vAlign="top" width="50%" headers=""> 
             <uix:contents>             
              <uix:header textBinding="PERFORMANCE@DGMsgBundle@servletRequest">
              <uix:stackLayout>
               <uix:contents>
               <uix:styledText textBinding="PERF_OVER@DGMsgBundle@servletRequest" destinationBinding="perfLink@servletRequest" renderedBinding="isEnterpriseMode@servletRequest" />
               <uix:styledText textBinding="LOG_FILE_DETAILS@DGMsgBundle@servletRequest" destinationBinding="logFileLink@servletRequest" />
               </uix:contents>
              </uix:stackLayout>
             </uix:header>
            </uix:contents>
           </uix:cellFormat>

            <uix:cellFormat vAlign="top" width="50%" headers=""> 
             <uix:contents>
              <uix:header textBinding="ADDITIONAL_ADMIN@DGMsgBundle@servletRequest">
              <uix:stackLayout>
               <uix:contents>
               <uix:styledText textBinding="VERIFY@DGMsgBundle@servletRequest" destinationBinding="verifyLink@servletRequest" renderedBinding="isEnterpriseMode@servletRequest"/>
               <uix:styledText textBinding="REMOVE_CONFIG@DGMsgBundle@servletRequest" destinationBinding="removeLink@servletRequest"/>
               </uix:contents>
              </uix:stackLayout>
             </uix:header>
            </uix:contents>
           </uix:cellFormat>

          </uix:contents>
         </uix:tableLayout>
         <%--  end Links section --%>

        <%  }  else { %>

        <uix:rowLayout width="80%" hAlign="center">
         <uix:contents>        
         <uix:styledText text=""/>
         <uix:contentContainer 
            width="100%" >
            <uix:contents>
             <uix:stackLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText"
                    textBinding="DG_DESC@DGMsgBundle@servletRequest" />
                <uix:bulletedList>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="DG_FEATURE2@DGMsgBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="DG_FEATURE5@DGMsgBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="DG_FEATURE4@DGMsgBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="DG_FEATURE3@DGMsgBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="DG_FEATURE1@DGMsgBundle@servletRequest"/>
                 </uix:bulletedList>

                </uix:contents>
               </uix:stackLayout>
              </uix:contents>
           </uix:contentContainer>
          </uix:contents>
         </uix:rowLayout>

        <%  } %>

        </uix:header>
       </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
