<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.*" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="perfTitle@chartBean@servletRequest"/> 
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChart") %> >
    </uix:metaContainer> 

    <uix:body>
     <db:form name="perfForm" method="POST" destination="/console/database/dataguard" copyParams="target,type">
      <uix:formValue name="event" value="perfOverview"/>
      <uix:pageLayout>

      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest" 
                      titleTextKey="titleText" mainTextKey="mainText"/> 
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest" 
                      titleTextKey="titleText" mainTextKey="mainText"/>     

      <uix:tableLayout width="100%"  summary="tl"> 
        <uix:rowLayout hAlign="right">
        <uix:cellFormat headers=""> 
          <uix:styledText textBinding="VIEW_DATA_LABEL@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice" styleClass="OraInstructionText"/>
          <uix:spacer width="5"/>
          <uix:choice name="refreshChart" id="refreshChoice" onChange="submitForm('perfForm', true, {'event':'perfOverview'})"
              selectedValueBinding="refreshChart@servletRequest" >
            <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="99999" />
            <uix:option textBinding="REAL_TIME_30_SEC@DBMsgBundle@servletRequest" value="30" />
            <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest" value="60" />
            <uix:option textBinding="REAL_TIME_5_MIN@DBMsgBundle@servletRequest" value="300" />
          </uix:choice>
         </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:header textBinding="PERF_OVER@DGMsgBundle@servletRequest" >

        <uix:tableLayout width="100%"  summary="tl"> 
          <uix:rowLayout vAlign="top" hAlign="right">
              <uix:cellFormat width="97%" hAlign="right" vAlign="center" headers=""> 
                 <uix:contents> 
                  <oem:pageRefreshed/>
                 </uix:contents>
              </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="center" headers=""> 
              <uix:contents>
                  <uix:image sourceBinding="refreshImage@servletRequest" 
                           destinationBinding="performanceDest@configBean@servletRequest"
                           shortDescBinding="REFRESH_PAGE@DGMsgBundle@servletRequest" />
             </uix:contents>
           </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>

        <uix:tableLayout cellSpacing="2" width="100%"  summary="tl"> 
         <uix:cellFormat vAlign="top" width="45%" headers=""> 
          <uix:contents>

          <uix:stackLayout>
               <oem:chart 
                    titleBinding="ARCHIVE_RATE_MB@DGMsgBundle@servletRequest"
                    chartType="timeSeriesChart"
                    orientation="vertical"
                    width="350"
                    height="160" 
                    timeGranularity="SECOND"
                    legendPosition="south"
                    seriesColorsAutomatic="true">
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="archiveRateChart@chartBean@servletRequest" />
                    <oem:chartColumn
                      displayLabel="Name"
                      sourceIndex="0" 
                      isKey="true" 
                    />
                    <oem:chartColumn
                      displayLabel="Time"
                      sourceIndex="1" 
                      isTimeColumn="true" 
                    />
                    <oem:chartColumn
                      displayLabelBinding="ARCHIVE_RATE_MB@DGMsgBundle@servletRequest" 
                      sourceIndex="2"
                    />
                  </uix:contents>
                </oem:chart>
           </uix:stackLayout>
          </uix:contents>
        </uix:cellFormat>

     <uix:cellFormat vAlign="top" width="55%" headers=""> 
      <uix:contents>
          <uix:stackLayout>
              <oem:chart 
                  titleBinding="SPS@DGMsgBundle@servletRequest"
                  chartType="barChart"
                  orientation="vertical"
                  heightBinding="chartHeight@chartBean@servletRequest" 
                  widthBinding="chartWidth@chartBean@servletRequest"
                  legendPositionBinding="chartLegendPosition@chartBean@servletRequest"
                  shadowEffect="3d"
                  barLabelling="out"
                   >
                <uix:contents>
                  <oem:boundChartDataSource 
                    chartDataSourceBinding="applyBehindChart@chartBean@servletRequest" />
                  <oem:chartColumn
                    displayLabel="Name"
                    sourceIndex="0" 
                    isKey="true" 
                  />
                  <oem:chartColumn
                    displayLabelBinding="titlePDL@chartBean@servletRequest" 
                    sourceIndex="1"
                  />
                  <oem:chartColumn
                    displayLabelBinding="titleRNA@chartBean@servletRequest" 
                    sourceIndex="2"
                  />
               </uix:contents>
              </oem:chart>
         </uix:stackLayout>
          </uix:contents>
        </uix:cellFormat>
          
     </uix:tableLayout>

       <% ChartBean chartBean = (ChartBean)(request.getAttribute("chartBean"));
         if (chartBean != null && chartBean.showTestApp()) { %>

        <uix:tableLayout cellSpacing="2" width="100%"  summary="tl"> 

         <uix:cellFormat vAlign="top" width="45%" headers=""> 
          <uix:contents>
          <uix:stackLayout>
               <oem:chart 
                    titleBinding="APPLY_RATE_MB@DGMsgBundle@servletRequest"
                    chartType="timeSeriesChart"
                    orientation="vertical"
                    width="350"
                    heightBinding="applyRateHeight@chartBean@servletRequest" 
                    legendPosition="south"
                    timeGranularity="SECOND"
                    seriesColorsAutomatic="true">
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="applyRateChart@chartBean@servletRequest" />
                    <oem:chartColumn
                      displayLabel="Name"
                      sourceIndex="0" 
                      isKey="true" 
                    />
                    <oem:chartColumn
                      displayLabel="Time"
                      sourceIndex="1" 
                      isTimeColumn="true" 
                    />
                    <oem:chartColumn
                      displayLabelBinding="APPLY_RATE_MB@DGMsgBundle@servletRequest" 
                      sourceIndex="2"
                    />
                  </uix:contents>
                </oem:chart>
           </uix:stackLayout>
        </uix:contents>
       </uix:cellFormat>
           
     <uix:cellFormat vAlign="top" width="55%" headers=""> 
      <uix:contents>

        <uix:switcher childNameBinding="showStatusChart@chartBean@servletRequest" defaultCase="false">
          <uix:case name="true">
        
           <uix:header textBinding="LOG_FILE_STATUS@DGMsgBundle@servletRequest">

            <uix:stackLayout>
            <uix:contents>
  
          <uix:tableLayout width="100%"  summary="tl"> 
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" headers=""> 
                <uix:contents> 
                <uix:styledText styleClass="OraInlineInfoText" textBinding="LOG_FILE_STATUS_DESC@DGMsgBundle@servletRequest" />
                <uix:spacer width="5"/>
              </uix:contents>
            </uix:cellFormat>
           </uix:rowLayout>
  
            <uix:spacer width="5"/>
            <oem:table name="ChartList" width="90%" beanKey="chartBean" dataSourceProp="logStatus" summaryBinding="LOG_FILE_STATUS@DGMsgBundle@servletRequest" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest" >
            </oem:table>

          </uix:tableLayout>

            </uix:contents>
            </uix:stackLayout>
            </uix:header>

            </uix:case>
           </uix:switcher>

          </uix:contents>
        </uix:cellFormat>        
     </uix:tableLayout>

        <uix:tableLayout cellSpacing="2" width="100%"  summary="tl"> 
         <uix:cellFormat vAlign="top" width="45%" headers=""> 
          <uix:contents>

        <% chartBean = (ChartBean)(request.getAttribute("chartBean"));
           if (chartBean != null && chartBean.showTestApp()) { %>
           <uix:header textBinding="testHeader@chartBean@servletRequest">
          <uix:tableLayout width="100%"  summary="tl"> 

            <uix:rowLayout>
              <uix:cellFormat hAlign="left" width="80%" headers=""> 
                <uix:contents> 
                <uix:styledText styleClass="OraInlineInfoText" 
                    textBinding="TEST_APP_DESC@DGMsgBundle@servletRequest" />
                <uix:spacer width="4"/>
              </uix:contents>
            </uix:cellFormat>
           </uix:rowLayout>
  
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" headers=""> 
                <uix:contents> 
                    <uix:submitButton textBinding="TEST_APP_START@DGMsgBundle@servletRequest" name="event" value="startTest" formName="perfForm" shortDescBinding="TEST_APP_START@DGMsgBundle@servletRequest"/> 
                    <uix:submitButton textBinding="TEST_APP_STOP@DGMsgBundle@servletRequest" name="event" value="stopTest" formName="perfForm" shortDescBinding="TEST_APP_STOP@DGMsgBundle@servletRequest"/> 
                      <% chartBean = (ChartBean)(request.getAttribute("chartBean"));
                    if (chartBean != null && chartBean.getShowTestButtons()) { %>
                    <uix:submitButton textBinding="TEST_APP_PAUSE@DGMsgBundle@servletRequest" name="event" value="pauseTest" formName="perfForm" shortDescBinding="TEST_APP_PAUSE@DGMsgBundle@servletRequest"/> 
                    <% } %>
              </uix:contents>
            </uix:cellFormat>
           </uix:rowLayout>
           
          </uix:tableLayout>
         </uix:header>
         <% } %>


          </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat vAlign="top" width="55%" headers=""> 
          <uix:contents>
          </uix:contents>
        </uix:cellFormat>        

     </uix:tableLayout>
         <% } %>

     </uix:header>
    </uix:pageLayout>
   </db:form>
  </uix:body>
 </uix:document> 
</uix:renderingContext> 
