<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.*" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="perfTitle@chartBean@servletRequest"/> 
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChart") %> >
    </uix:metaContainer> 

    <uix:body>
     <db:form name="perfForm" method="get" destination="/console/database/dataguard" copyParams="target,type">
      <uix:formValue name="event" value="perfOverview"/>
      <uix:pageLayout>

      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"       
                      errorTableBinding="info@servletRequest" 
                      titleTextKey="titleText" mainTextKey="mainText"/> 
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest" 
                      titleTextKey="titleText" mainTextKey="mainText"/>     

      <uix:header textBinding="perfHeader@chartBean@servletRequest" >          
      
          <uix:tableLayout width="100%" summary="tl"> 
            <uix:rowLayout>

               <uix:cellFormat hAlign="left"  headers=""> 
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="timestamp@configBean@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>
                
          <uix:cellFormat hAlign="right" vAlign="center"  headers=""> 
          <uix:styledText textBinding="VIEW_DATA_LABEL@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice" styleClass="OraInstructionText"/>
          <uix:spacer width="5"/>
          <uix:choice name="refreshChart" id="refreshChoice" onChange="submitForm('perfForm', true, {'event':'perfOverview'})"
              selectedValueBinding="refreshChart@servletRequest" >
            <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="99999" />
            <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest" value="60" />
            <uix:option textBinding="REAL_TIME_5_MIN@DBMsgBundle@servletRequest" value="300" />
          </uix:choice>
         </uix:cellFormat>       
              <uix:cellFormat hAlign="right" vAlign="center"  headers=""> 
              <uix:contents>
                  <uix:image sourceBinding="refreshImage@servletRequest" 
                           destinationBinding="performanceDest@configBean@servletRequest"
                           shortDescBinding="REFRESH_PAGE@DGMsgBundle@servletRequest" />
             </uix:contents>
         </uix:cellFormat>       
        </uix:rowLayout>
       </uix:tableLayout>

<% ChartMetrics bean = ((ChartMetrics)(request.getAttribute("chartBean"))); 
    int cur  = 0; %>

    <uix:tableLayout width="100%" summary="tl">             
      <%@ include file="dgPerfSummary.jspf" %>        
    </uix:tableLayout>

    <uix:tableLayout width="100%" renderedBinding="isEnterpriseMode@servletRequest" summary="tl"> 
<%  if (bean != null)
    {
    int max  = bean.getMaxCharts(); 
    int rows = bean.getNumRows();
    int cols = bean.getNumCols();
    cur++;
    for (int i = 0; i < rows; i++)
      { %>        
      <uix:rowLayout vAlign="top">
  <%  for (int j = 0; j < cols; j++) { %>
            <%@ include file="dgPerfChart.jspf" %>
<%       if (cur++ >= (max-1))
        break;
        } %>
        </uix:rowLayout>
<%    } 
    } %> 
      </uix:tableLayout>
     </uix:header>
    </uix:pageLayout>
   </db:form>
  </uix:body>
 </uix:document> 
</uix:renderingContext> 
