<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
     <uix:head titleBinding="modeTitle@editProtBean@configBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
     <db:form name="editAfoModeForm" method="POST" destination="/console/database/dataguard" copyParams="target,type">
      <uix:pageLayout titleBinding="modeHeader@editProtBean@configBean@servletRequest">

      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

      <uix:pageButtons>
	    <uix:pageButtonBar>
          <uix:contents>
    					<uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="editAfoModeForm" 
                  name="event" value="doLoad"  shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/> 
    					<uix:submitButton textBinding="CONTINUE@DGMsgBundle@servletRequest" formName="editAfoModeForm" 
                  name="event" value="editOK"  shortDescBinding="CONTINUE@DGMsgBundle@servletRequest"/> 
	        </uix:contents>
      </uix:pageButtonBar>
      </uix:pageButtons>

<%-- AFO Mode Section - Begin --%>
   <uix:tableLayout cellSpacing="2" width="80%" summary="tl"> 
    <uix:contents>
     <uix:cellFormat vAlign="top" width="100%" headers=""> 

    <uix:rowLayout>
    <uix:cellFormat headers=""> 

       <uix:stackLayout>
        <uix:contents>

<%-- Row 1 AFO description --%>
        <uix:rowLayout>
         <uix:cellFormat headers=""> 
          <uix:styledText styleClass="OraFieldText" textBinding="AFO_EDIT_DESC@DGMsgBundle@servletRequest"/> 
         </uix:cellFormat>
        </uix:rowLayout>

       <uix:spacer height="5"/>

<%-- Row 2 Protection Mode tip
        <uix:rowLayout>
         <uix:cellFormat headers=""> 
           <uix:tip> <uix:styledText textBinding="afoEditTip@editProtBean@configBean@servletRequest"/>
           </uix:tip>
         </uix:cellFormat>
        </uix:rowLayout>
 --%>

       <uix:spacer height="5"/>

<%-- Row 3 Enable --%>
        <uix:rowLayout width="95%">
         <uix:cellFormat headers=""> 
          <uix:messageRadioButton name="afoMode" 
                                  value="ENABLED" 
                                  onClick="submitForm('editAfoModeForm', true, {'event':'changeAFOMode'})"
                                  selectedValueBinding="afoMode@editProtBean@configBean@servletRequest"
                                  messageBinding="AFO_EDIT_CHANGE_PROPS_TIP@DGMsgBundle@servletRequest"
                                  textBinding="AFO_EDIT_CHANGE_PROPS@DGMsgBundle@servletRequest"/>
         </uix:cellFormat>
        </uix:rowLayout>

       <uix:spacer height="5"/>

<%-- Row 4 Disable --%>
        <uix:rowLayout width="95%">
         <uix:cellFormat headers=""> 
          <uix:messageRadioButton name="afoMode" 
                                  value="DISABLED" 
                                  onClick="submitForm('editAfoModeForm', true, {'event':'changeAFOMode'})"
                                  selectedValueBinding="afoMode@editProtBean@configBean@servletRequest"
                                  messageBinding="AFO_EDIT_DISABLED@DGMsgBundle@servletRequest"
                                  textBinding="DISABLE@DGMsgBundle@servletRequest"/>
         </uix:cellFormat>
        </uix:rowLayout>

<%-- Row 5 Stop Observer --%>
        <uix:rowLayout width="95%">
         <uix:spacer width="5"/>
         <uix:cellFormat headers=""> 
          <uix:messageCheckBox name="stopObserver" 
                               styleClass="OraFieldText" 
                               textBinding="AFO_EDIT_STOP_OBSERVER@DGMsgBundle@servletRequest" 
                               messageBinding="AFO_EDIT_STOP_OBSERVER_TIP@DGMsgBundle@servletRequest" 
                               checkedBinding="stopObserver@editProtBean@configBean@servletRequest" 
                               disabledBinding="disableStopObserver@editProtBean@configBean@servletRequest" 
                               value="true"/>
         </uix:cellFormat>
        </uix:rowLayout>

       <uix:spacer height="5"/>

        </uix:contents>
        </uix:stackLayout>

     </uix:cellFormat>
     </uix:rowLayout>

     </uix:cellFormat>

     </uix:contents>
     </uix:tableLayout>

  </uix:pageLayout>
  </db:form>
  </uix:body>
  </uix:document> 
</uix:renderingContext>
