<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <jsp:useBean id="dbBean" class="oracle.sysman.db.dg.util.DBInfo" scope="request"/>
    <uix:metaContainer> 
      <uix:head titleBinding="nameHeaderTitle@dbBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
     <db:form name="editDBForm" method="post" destination="/console/database/dataguard" copyParams="target,type">
      <uix:formValue name="pageNum" value="2"/>
      <uix:formValue name="dbName" valueBinding="name@dbBean@servletRequest"/>
      <uix:formValue name="pageName" value="/database/dataguard/editCommonProps"/>

      <uix:pageLayout titleBinding="nameHeader@dbBean@servletRequest">

      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

       <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="2">          
                <uix:link textBinding="GENERAL@DGMsgBundle@servletRequest"
                  onClick="submitForm('editDBForm', true, {event:'editDBGeneral'})"/>
                <uix:link textBinding="STBY_ROLE@DGMsgBundle@servletRequest"
                  onClick="submitForm('editDBForm', true, {event:'editDBStandby'})"/>
                <uix:link textBinding="COMM_ROLE@DGMsgBundle@servletRequest"/>
            </uix:subTabBar>
          </uix:subTabs>

        <uix:spacer width="8"/>

          <uix:tableLayout  cellSpacing="3" summary="tl"> 
           <uix:contents>
          <uix:rowLayout>
           <uix:contents>
          <uix:spacer width="3"/>
          <uix:tip>
            <uix:contents>
              <uix:styledText 
                textBinding="COMM_TIP@DGMsgBundle@servletRequest"/>
            </uix:contents>
          </uix:tip>
           </uix:contents>
          </uix:rowLayout>
          </uix:contents>
         </uix:tableLayout>

        <uix:spacer width="8"/>

          <uix:labeledFieldLayout width="75%">
           <uix:contents>

					<uix:messageTextInput 
                  renderedBinding="is110@dbBean@servletRequest"
                  name="<%=dbBean.getPropertyString(DGMsgID.DG_CONNECT_ID)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.DG_CONNECT_ID)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.DG_CONNECT_ID)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.DG_CONNECT_ID)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.DG_CONNECT_ID,DGMsgID.DG_CONNECT_ID_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.DG_CONNECT_ID)%>"
                  rows="3"
                  columns="80" >
  				</uix:messageTextInput>

					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.LOGARCHIVEMAXPROCESSES)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.LOGARCHIVEMAXPROCESSES)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.LOGARCHIVEMAXPROCESSES)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.LOGARCHIVEMAXPROCESSES)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.LOGARCHIVEMAXPROCESSES,DGMsgID.LOGARCHMAXPROT_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.LOGARCHIVEMAXPROCESSES)%>"
                  columns="8" >
  				</uix:messageTextInput>

<%           if (dbBean.isRAC()) { %>
        
              <uix:rowLayout  hAlign="right">
               <uix:contents>
                <uix:image sourceBinding="detailsImage@servletRequest" shortDescBinding="DETAILS@DGMsgBundle@servletRequest"
                    destination="<%=dbBean.getPropertyDest(DGMsgID.LOGARCHIVETRACE)%>" />            
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraPromptText" labeledNodeId="<%=dbBean.getPropertyName(DGMsgID.LOGARCHIVETRACE)%>"
                      text="<%=dbBean.getPropertyName(DGMsgID.LOGARCHIVETRACE)%>" />
              </uix:contents>
              </uix:rowLayout>
              <oem:table name="<%=dbBean.getPropertyString(DGMsgID.LOGARCHIVETRACE)%>" 
                id="<%=dbBean.getPropertyName(DGMsgID.LOGARCHIVETRACE)%>"
                beanKey="dbBean" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest" summaryBinding="LOGARCHIVETRACE@DGMsgBundle@servletRequest"
                dataSourceProp="logArchiveTraceRAC"  formSubmitted="true" destination="/console/database/dataguard/dataguardConfig"/> 
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
              <uix:styledText styleClass="<%=dbBean.getStyleClass(DGMsgID.LOGARCHIVETRACE)%>" text="<%=dbBean.getMessage(DGMsgID.LOGARCHIVETRACE,DGMsgID.LOGARCHTRACE_RACDESC)%>" />
<% } else { %>
  					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.LOGARCHIVETRACE)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.LOGARCHIVETRACE)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.LOGARCHIVETRACE)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.LOGARCHIVETRACE)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.LOGARCHIVETRACE,DGMsgID.LOGARCHTRACE_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.LOGARCHIVETRACE)%>"
                  columns="8" >
    				</uix:messageTextInput>
<% } %>          
           </uix:contents>
          </uix:labeledFieldLayout>

        <uix:spacer width="5"/>

        </uix:subTabLayout>
   
      <uix:pageButtons>
        <uix:pageButtonBar>
                <uix:submitButton textBinding="REVERT@DGMsgBundle@servletRequest" name="event" value="revert" unvalidated="true" formName="editDBForm" shortDescBinding="REVERT@DGMsgBundle@servletRequest"/> 
                <uix:submitButton textBinding="APPLY@DGMsgBundle@servletRequest" name="event" value="apply" formName="editDBForm" shortDescBinding="APPLY@DGMsgBundle@servletRequest"/> 
        </uix:pageButtonBar>
      </uix:pageButtons>

     </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document> 
</uix:renderingContext> 
