<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>
<SCRIPT LANGUAGE="JavaScript">

function disableOnLoad (param) {
  obj = eval (document.forms[0][param]);

  var runningDbFlag = editDBForm.dgState[0].checked;
  var disabledDbFlag = editDBForm.dgState[0].disabled;

  if(!obj.value){
    if(runningDbFlag && !disabledDbFlag) {
      editDBForm.adgEnable.disabled=false;
    }
    else {
      editDBForm.adgEnable.disabled=true;
      editDBForm.adgEnable.checked=false;
    }
  }
}//disable

function disableRadioButtons (val) {
  if(val=="1") {
    editDBForm.adgEnable.disabled=false;
  }
  else if(val=="2") {
    editDBForm.adgEnable.disabled=true;
    editDBForm.adgEnable.checked=false;
  }  
}
</SCRIPT>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/completePPR.jspf" %>
    <jsp:useBean id="dbBean" class="oracle.sysman.db.dg.util.DBInfo" scope="request"/>
    <jsp:useBean id="failedTxnBean" class="oracle.sysman.db.dg.util.LsbySkipTxn" scope="request"/>
    <uix:metaContainer> 
      <uix:head titleBinding="nameHeaderTitle@dbBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body onLoad="disableOnLoad('adgDisableControl')">
     <db:form name="editDBForm" method="post" destination="/console/database/dataguard" copyParams="target,type">
      <uix:formValue name="pageNum" value="1"/>
      <uix:formValue name="dbName" valueBinding="name@dbBean@servletRequest"/>
      <uix:formValue name="pageName" value="/database/dataguard/editDatabase"/>

      <uix:pageLayout titleBinding="nameHeader@dbBean@servletRequest">

      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

       <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="GENERAL@DGMsgBundle@servletRequest"/>
                <uix:link textBinding="STBY_ROLE@DGMsgBundle@servletRequest"
                       onClick="submitForm('editDBForm', true, {event:'editDBStandby'})"/>
                <uix:link textBinding="COMM_ROLE@DGMsgBundle@servletRequest"
                       onClick="submitForm('editDBForm', true, {event:'editDBCommon'})"/>
            </uix:subTabBar>
          </uix:subTabs>

          <uix:tableLayout cellSpacing="2" width="100%" summary="tl"> 
           <uix:contents>
            <uix:spacer height="13"/>
            <uix:rowLayout vAlign="top">
             <uix:contents>

              <uix:cellFormat vAlign="top" width="100%" headers=""> 
               <uix:contents>

                  <uix:stackLayout>
                   <uix:contents>
                    <uix:rowLayout>
                     <uix:contents>
                      <uix:borderLayout>
                       <uix:contents>
                        <uix:tableLayout hAlign="left" summary="tl"> 
                         <uix:contents>

                          <uix:rowLayout>
                           <uix:contents>
                             <uix:cellFormat hAlign="right" vAlign="center" headers=""> 
                              <uix:contents>
                                <uix:spacer width="18"/>
                                 <uix:image sourceBinding="detailsImage@servletRequest" shortDescBinding="DETAILS@DGMsgBundle@servletRequest"
                                    destination="<%=dbBean.getErrorDest()%>" />            
                                 <uix:spacer width="5"/>
                               <uix:messagePrompt promptBinding="STATUS@DGMsgBundle@servletRequest"/>
                              </uix:contents>
                             </uix:cellFormat>
                            <uix:spacer width="8"/>

                             <uix:cellFormat hAlign="left" vAlign="center" headers=""> 
                              <uix:contents>
                               <uix:image sourceBinding="statusIcon@dbBean@servletRequest" shortDescBinding="errorString@dbBean@servletRequest"/>                                  
                               <uix:spacer width="5"/>
                               <uix:styledText styleClass="OraDataText" 
                                  textBinding="errorString@dbBean@servletRequest"  />
                              </uix:contents>
                             </uix:cellFormat>
                           </uix:contents>
                          </uix:rowLayout>

                           <uix:rowLayout>
                           <uix:contents>
                             <uix:cellFormat hAlign="right" headers=""> 
                              <uix:contents>
                               <uix:spacer width="5"/>
                                <uix:messagePrompt promptBinding="ROLE@DGMsgBundle@servletRequest"/>
                              </uix:contents>
                             </uix:cellFormat>
                            <uix:spacer width="8"/>
                            <uix:styledText styleClass="OraDataText" textBinding="typeString@dbBean@servletRequest" />
                           </uix:contents>
                          </uix:rowLayout>

                    <uix:switcher childNameBinding="showRestartButton@dbBean@servletRequest" defaultCase="false">
                      <uix:case name="true">
                        <uix:rowLayout>
                         <uix:contents>
                           <uix:cellFormat hAlign="right" headers=""> 
                            <uix:contents>
                             <uix:spacer width="5"/>

                            <% if (dbBean.getShowChangeStatus()) { %>
                             <uix:button textBinding="restartButtonText@dbBean@servletRequest" destination="<%=dbBean.getChangeStatusDest()%>"   />
                            <% } else { %>                             
                             <uix:submitButton textBinding="restartButtonText@dbBean@servletRequest" name="event" value="reset" formName="editDBForm"    shortDescBinding="restartButtonText@dbBean@servletRequest"/> 
                            <% } %>
                        
                            </uix:contents>
                           </uix:cellFormat>
                             <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraInlineInfoText" 
                                textBinding="restartButtonTip@dbBean@servletRequest"/>
                         </uix:contents>
                        </uix:rowLayout>
                     </uix:case>
                    </uix:switcher>

                         </uix:contents>
                        </uix:tableLayout>
                       </uix:contents>

                      </uix:borderLayout>
                     </uix:contents>
                    </uix:rowLayout>
                   </uix:contents>
                  </uix:stackLayout>

<%           if (dbBean.getShowStatusReport()) { %>
                    <uix:header textBinding="RELATED_STATUS@DGMsgBundle@servletRequest">
                     <oem:table name="StatusReport" summaryBinding="RELATED_STATUS@DGMsgBundle@servletRequest" beanKey="dbBean" dataSourceProp="statusReport" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest" />
                    </uix:header>
<% } %>

               <uix:switcher childNameBinding="showFailedTxn@failedTxnBean@servletRequest" defaultCase="false">
                  <uix:case name="true">
                    <%@ include file="lsbyFailedTxn.jspf" %>
                  </uix:case>
                </uix:switcher>

               </uix:contents>
              </uix:cellFormat>

             </uix:contents>
            </uix:rowLayout>
           </uix:contents>
          </uix:tableLayout>

 <% if (dbBean.showStateAndEnabled()) { %>
 <% if (!dbBean.isSnapshotStandby()) { %>
        <uix:header textBinding="applyTransportHeader@dbBean@servletRequest">
        <uix:stackLayout>
         <uix:contents>

            <uix:tableLayout cellSpacing="5" width="90%" summary="tl"> 

              <uix:rowLayout>
               <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" textBinding="logApplyXPTDESC@dbBean@servletRequest"/>
               </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                 <uix:stackLayout>
                  <uix:contents>
                  
                   <uix:messageRadioButton 
                        disabled="<%=!dbBean.isEnabled()%>"            
                        name="dgState" 
                        selectedValueBinding="currentState@dbBean@servletRequest" 
                        valueBinding="onlineStateValue@dbBean@servletRequest" 
                        textBinding="onlineStateString@dbBean@servletRequest"
                        messageBinding="onlineStateTip@dbBean@servletRequest"
                        onClick="disableRadioButtons(1)"/>

                   <uix:rowLayout renderedBinding="showActiveDG@dbBean@servletRequest" width="100%">
                    <uix:contents>
                     <uix:spacer width="18"/>			   

                     <uix:stackLayout>
                      <uix:contents>

                        <uix:rowLayout>
                         <uix:contents>
                          <uix:image sourceBinding="detailsImage@servletRequest" shortDescBinding="DETAILS@DGMsgBundle@servletRequest" destination="<%=dbBean.getPropertyDest(DGMsgID.RTQ_ENABLE)%>"/>
                          <uix:spacer width="5"/>
                          <uix:styledText styleClass="OraInstructionText" 
                              textBinding="RTQ_INFO@DGMsgBundle@servletRequest"/>
                         </uix:contents>
                        </uix:rowLayout>

                        <uix:tip renderedBinding="adgDisableControl@dbBean@servletRequest"> 
                          <uix:styledText styleClass="OraInstructionText" textBinding="RTQ_NOT_POSSIBLE@DGMsgBundle@servletRequest"/>
                        </uix:tip>

                        <uix:messageCheckBox 
                             name="adgEnable" 
                             styleClass="OraFieldText" 
                             textBinding="RTQ_ENABLE@DGMsgBundle@servletRequest"
                             checkedBinding="adgEnabled@dbBean@servletRequest"
                             messageBinding="RTQ_ENABLED@DGMsgBundle@servletRequest"
                             value="true" 
                             disabledBinding="adgDisableControl@dbBean@servletRequest"/>
    
                      </uix:contents>
                     </uix:stackLayout>
                    </uix:contents>
                   </uix:rowLayout>

                   <uix:messageRadioButton 
                        disabled="<%=!dbBean.isEnabled()%>"            
                        name="dgState" 
                        selectedValueBinding="currentState@dbBean@servletRequest" 
                        valueBinding="applyTransportOffStateValue@dbBean@servletRequest" 
                        textBinding="applyTransportOffStateString@dbBean@servletRequest"
                        messageBinding="applyTransportOffStateTip@dbBean@servletRequest"
                        onClick="disableRadioButtons(2)"/>


          <uix:switcher childNameBinding="physicalStandbyDB@dbBean@servletRequest" defaultCase="false">
            <uix:case name="true">
                   <uix:messageRadioButton 
                        disabled="<%=!dbBean.isEnabled()%>"            
                        name="dgState" 
                        selectedValueBinding="currentState@dbBean@servletRequest" 
                        valueBinding="PHYSICAL_READONLY_STATE@dbBean@servletRequest" 
                        textBinding="readonlyStateString@dbBean@servletRequest"
                        messageBinding="READ_ONLY_DESC@DGMsgBundle@servletRequest"
			renderedBinding="isNot110@dbBean@servletRequest"/>
           </uix:case>
          </uix:switcher>
<% if (dbBean.showOffline()) { // debug only %>
                   <uix:messageRadioButton 
                        disabled="<%=!dbBean.isEnabled()%>"            
                        name="dgState" 
                        selectedValueBinding="currentState@dbBean@servletRequest" 
                        valueBinding="OFFLINE@dbBean@servletRequest" 
                        textBinding="offlineStateString@dbBean@servletRequest"
                        messageBinding="OFFLINE_DESC@DGMsgBundle@servletRequest"/>
<% } %>
                  </uix:contents>
                 </uix:stackLayout>
                </uix:contents>
               </uix:rowLayout>
               </uix:tableLayout>
              </uix:contents>

            
        </uix:stackLayout>
       </uix:header>
<% } %>
       <uix:header textBinding="DIAGNOSTICS@DGMsgBundle@servletRequest">
        <uix:stackLayout>
         <uix:contents>
           <oem:table name="ShowLinks" beanKey="dbBean" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest"
             summaryBinding="DIAGNOSTICS@DGMsgBundle@servletRequest" dataSourceProp="showLinks"  formSubmitted="true" destination="/console/database/dataguard/dataguardConfig"/> 
         </uix:contents>
        </uix:stackLayout>
       </uix:header>

<% if (dbBean.showOffline()) { // debug only %>

        <uix:header textBinding="ENABLED_HDR@DGMsgBundle@servletRequest">
        <uix:stackLayout>
         <uix:contents>

            <uix:tableLayout cellSpacing="5" summary="tl"> 
              <uix:rowLayout>
                   <uix:messageRadioButton 
                        name="dgEnabled" 
                        selectedValueBinding="currentEnabled@dbBean@servletRequest"
                        valueBinding="YES@dbBean@servletRequest" 
                        textBinding="ENABLED@DGMsgBundle@servletRequest"
                        messageBinding="ENABLED_DESC@DGMsgBundle@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
                   <uix:messageRadioButton 
                        name="dgEnabled" 
                        selectedValueBinding="currentEnabled@dbBean@servletRequest"
                        valueBinding="NO@dbBean@servletRequest" 
                        textBinding="DISABLED@DGMsgBundle@servletRequest"
                        messageBinding="DISABLED_DESC@DGMsgBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:tableLayout>
         </uix:contents>
        </uix:stackLayout>
       </uix:header>

  <% } // Enabled %>
<% } // showStateandEnabled %>

      </uix:subTabLayout>
       
      <uix:pageButtons>
        <uix:pageButtonBar>
                <uix:submitButton textBinding="REVERT@DGMsgBundle@servletRequest" name="event" value="revert" unvalidated="true" formName="editDBForm" shortDescBinding="REVERT@DGMsgBundle@servletRequest"/> 
                <uix:submitButton textBinding="APPLY@DGMsgBundle@servletRequest" name="event" value="apply" formName="editDBForm" shortDescBinding="APPLY@DGMsgBundle@servletRequest"/> 
        </uix:pageButtonBar>
      </uix:pageButtons>

     </uix:pageLayout>
    </db:form>
   </uix:body>

  </uix:document> 
</uix:renderingContext> 
