<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="failoverConditionTitle@editProtBean@configBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
      <db:form name="editFailoverConditionsForm" method="POST" 
          destination="/em/console/database/dataguard/editFailoverConditions" copyParams="target,type">
        <uix:formValue name="pageEvent" value="editFailoverConditions"/>
        <uix:pageLayout titleBinding="failoverHeader@editProtBean@configBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/dataguard/errors.jspf" %>    
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:contents>
                <uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="editFailoverConditionsForm"  
                        name="event" value="cancelEditFailoverConditions"  shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/> 
                <uix:submitButton textBinding="OK@DGMsgBundle@servletRequest" formName="editFailoverConditionsForm" 
                        name="event" value="setEditFailoverConditions" shortDesc="OK@DGMsgBundle@servletRequest"/> 
              </uix:contents>
            </uix:pageButtonBar>
          </uix:pageButtons>
  
          <uix:header textBinding="AFO_USER_CONFIG_FAILOVER_SUB_HEADER1@DGMsgBundle@servletRequest">
            <uix:styledText styleClass="OraFieldText" 
                         textBinding="AFO_FAILOVER_INFO@DGMsgBundle@servletRequest"/>                
            <uix:tableLayout summary="tl"> 
              <uix:rowLayout>
                <oem:table name="failoverCondsTable"
                           beanKey="editAfoBean"
                           destination="/em/console/database/dataguard/editFailoverConditions"
                           id="failoverCondsTable"
                           formSubmitted="true"
                           dataSourceProp="failoverCondsTable"
                           alternateTextBinding="NO_ITEMS_FOUND@DGMsgBundle@servletRequest">
                  <uix:tableSelection>
                    <uix:multipleSelection
                         selectionBinding="selection@failoverCondsTable@editProtBean@configBean@servletRequest"
                         shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                         selectedBinding="selected"/>
                  </uix:tableSelection>

                </oem:table>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
  
          <uix:header textBinding="AFO_USER_CONFIG_FAILOVER_SUB_HEADER2@DGMsgBundle@servletRequest">
            <uix:styledText  styleClass="OraFieldText" textBinding="AFO_ORA_ERROR_CONDITIONS_INFO@DGMsgBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionText" text=""/>
            <uix:tableLayout summary="tl"> 
              <uix:rowLayout>
                <oem:table name="oraErrCondsTable"
                           beanKey="editAfoBean"
                           destination="/em/console/database/dataguard/editFailoverConditions"
                           formSubmitted="true"
                           dataSourceProp="oraErrCondsTable"
                           alternateTextBinding="NO_ITEMS_FOUND@DGMsgBundle@servletRequest">
                  <uix:tableSelection>
                    <uix:singleSelection selectedIndexBinding="selectedIndex@oraErrCondsTable@editProtBean@configBean@servletRequest">
                    </uix:singleSelection>
                  </uix:tableSelection>
                  <uix:footer>
                  </uix:footer>
                </oem:table>
              </uix:rowLayout>
            </uix:tableLayout>      
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
