<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="modeTitle@editProtBean@configBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
     <db:form name="editProtModeForm" method="POST" destination="/console/database/dataguard" copyParams="target,type">
      <uix:pageLayout titleBinding="modeHeader@editProtBean@configBean@servletRequest">

      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

      <uix:pageButtons>
	    <uix:pageButtonBar>
          <uix:contents>
    					<uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="editProtModeForm" 
                  name="event" value="doLoad"  shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/> 
    					<uix:submitButton textBinding="CONTINUE@DGMsgBundle@servletRequest" formName="editProtModeForm" 
                  name="event" value="editOK"  shortDescBinding="CONTINUE@DGMsgBundle@servletRequest"/> 
	        </uix:contents>
      </uix:pageButtonBar>
      </uix:pageButtons>

<%-- Protection Mode Section - Begin --%>
   <uix:tableLayout cellSpacing="2" width="80%" summary="tl"> 
    <uix:contents>
     <uix:cellFormat vAlign="top" width="100%" headers=""> 

    <uix:rowLayout>
    <uix:cellFormat headers=""> 

       <uix:stackLayout>
        <uix:contents>

<%-- Row 1 Protection Mode description --%>
        <uix:rowLayout>
         <uix:cellFormat headers=""> 
          <uix:styledText styleClass="OraFieldText" textBinding="PM_EDIT_DESC@DGMsgBundle@servletRequest"/> 
         </uix:cellFormat>
        </uix:rowLayout>

       <uix:spacer height="5"/>

<%-- Row 2 Protection Mode tip --%>
        <uix:rowLayout renderedBinding="showBounceTip@editProtBean@configBean@servletRequest">
         <uix:cellFormat headers=""> 
          <uix:tip> <uix:styledText textBinding="PM_EDIT_BOUNCE_TIP@DGMsgBundle@servletRequest"/>
          </uix:tip>
         </uix:cellFormat>
        </uix:rowLayout>

       <uix:spacer height="5"/>

<%-- Row 3 Maximum Protection --%>
        <uix:rowLayout>
         <uix:cellFormat headers=""> 
          <oem:radioButton name="protMode" value="1" selectedValueBinding="curProtectionMode@configBean@servletRequest"
                           textBinding="MAX_PROT@DGMsgBundle@servletRequest"/>
         </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout  width="90%">
          <uix:contents>
            <uix:spacer width="22"/>			   
            <uix:cellFormat  vAlign="top" headers=""> 
              <uix:contents>
                <uix:styledText styleClass="OraInlineInfoText" 
                                textBinding="PM_EDIT_MAX_PROT_DESC@DGMsgBundle@servletRequest"/>
              </uix:contents>
            </uix:cellFormat>

          </uix:contents>
        </uix:rowLayout>

       <uix:spacer height="5"/>

<%-- Row 4 Maximum Availability --%>
        <uix:rowLayout>
         <uix:cellFormat headers=""> 
          <oem:radioButton name="protMode" value="2" selectedValueBinding="curProtectionMode@configBean@servletRequest"
                           textBinding="MAX_AVAIL@DGMsgBundle@servletRequest"/>
         </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout  width="90%">
          <uix:contents>
            <uix:spacer width="22"/>			   
            <uix:cellFormat hAlign="left" vAlign="top" headers=""> 
              <uix:contents>
                <uix:styledText styleClass="OraInlineInfoText" 
                                textBinding="PM_EDIT_MAX_AVAIL_DESC@DGMsgBundle@servletRequest"/>
              </uix:contents>
            </uix:cellFormat>

          </uix:contents>
        </uix:rowLayout>

       <uix:spacer height="5"/>

<%-- Row 5 Maximum Performance --%>
        <uix:rowLayout>
         <uix:cellFormat headers=""> 
          <oem:radioButton name="protMode" value="3" selectedValueBinding="curProtectionMode@configBean@servletRequest"
                           textBinding="MAX_PERF@DGMsgBundle@servletRequest"/>
         </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout  width="90%">
          <uix:contents>
            <uix:spacer width="22"/>			   
            <uix:cellFormat hAlign="left" vAlign="top" headers=""> 
              <uix:contents>
                <uix:styledText styleClass="OraInlineInfoText" 
                                textBinding="PM_EDIT_MAX_PERF_DESC@DGMsgBundle@servletRequest"/>
              </uix:contents>
            </uix:cellFormat>

          </uix:contents>
        </uix:rowLayout>

        </uix:contents>
        </uix:stackLayout>

     </uix:cellFormat>
     </uix:rowLayout>

     </uix:cellFormat>

     </uix:contents>
     </uix:tableLayout>

  </uix:pageLayout>
  </db:form>
  </uix:body>
  </uix:document> 
</uix:renderingContext>
