<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.util.StandbyProperties" %>
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>

<db:script src="/database/LOV.js"/>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="configTitle@editProtBean@configBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
    <db:form name="editProtSRLForm" method="POST" 
        destination="/em/console/database/dataguard/editProtSRL" copyParams="target,type">
      <uix:formValue name="pageEvent" value="editConfig"/>
     <uix:pageLayout titleBinding="configHeader@editProtBean@configBean@servletRequest">
      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

      <uix:pageButtons>
	    <uix:pageButtonBar>
          <uix:contents>
    					<uix:submitButton textBinding="CANCEL@DGMsgBundle@servletRequest" formName="editProtSRLForm" 
                  name="event" value="doLoad"  shortDescBinding="CANCEL@DGMsgBundle@servletRequest"/> 
    					<uix:submitButton textBinding="BACK@DGMsgBundle@servletRequest" formName="editProtSRLForm" 
                  name="event" valueBinding="backEvent@editProtBean@configBean@servletRequest" renderedBinding="showAfoEnabledUI@editProtBean@configBean@servletRequest" shortDescBinding="BACK@DGMsgBundle@servletRequest"/> 
    					<uix:submitButton textBinding="CONTINUE@DGMsgBundle@servletRequest" formName="editProtSRLForm" 
                  name="event" value="editConfirmUpgrade" disabledBinding="disableProtModeApply@servletRequest" shortDescBinding="CONTINUE@DGMsgBundle@servletRequest"/> 
	        </uix:contents>
      </uix:pageButtonBar>
      </uix:pageButtons>

     <uix:tip renderedBinding="showAfoBounceTip@editProtBean@configBean@servletRequest"> 
       <uix:styledText textBinding="afoEditTip@editProtBean@configBean@servletRequest"/>
     </uix:tip>

<%-- Standby Databases - Begin --%>

  <uix:header textBinding="dbPrompt@editProtBean@configBean@servletRequest">

    <uix:rowLayout width="90%">
      <uix:contents>
        <uix:stackLayout>
         <uix:contents>
          <uix:styledText styleClass="OraFieldText" textBinding="dbInfo@editProtBean@configBean@servletRequest"/>
          <uix:spacer height="10"/>			   
        </uix:contents>	
     </uix:stackLayout>
    </uix:contents>	
    </uix:rowLayout>

    <uix:switcher childNameBinding="showMaxProtInfo@editProtBean@configBean@servletRequest" defaultCase="false">
    <uix:case name="true">              
    <uix:rowLayout width="90%">
      <uix:contents>
        <uix:stackLayout>
         <uix:contents>
          <uix:styledText styleClass="OraFieldText" labeledNodeId="dataProtectionTable"
                    textBinding="PM_EDIT_SRL_UPGRADE_MAXPROT_INFO@DGMsgBundle@servletRequest"/>
          <uix:spacer height="10"/>			   
        </uix:contents>	
     </uix:stackLayout>
    </uix:contents>	
    </uix:rowLayout>
    </uix:case>
    </uix:switcher>

    <uix:contents>
    <oem:table name="dataProtectionTable" width="60%" beanKey="configBean" 
            dataSourceProp="dataProtectionTable" alternateText="" id="dataProtectionTable"
            onClickBinding="dbTableClick@editProtBean@configBean@servletRequest"
            formSubmitted="true" summaryBinding="PM_EDIT_SRL_DB_HEADER@DGMsgBundle@servletRequest" > 
    <uix:tableSelection>                

    <uix:switcher childNameBinding="isAfo@editProtBean@configBean@servletRequest" defaultCase="false">
    <uix:case name="false">              
     <uix:multipleSelection selectionBinding="selection@dataProtectionTable@configBean@servletRequest" 
            shortDescBinding="SELECT@DBMsgBundle@servletRequest" selectedBinding="selected"/>
    </uix:case>
    <uix:case name="true">              
     <uix:singleSelection   
            selectedIndexBinding="selectedIndex@dataProtectionTable@configBean@servletRequest"/>
    </uix:case>
    </uix:switcher>
    </uix:tableSelection>
    </oem:table>
    <uix:spacer width="4"/>
    </uix:contents>

    <uix:switcher childNameBinding="supportedDB@editProtBean@configBean@servletRequest" defaultCase="false">
    <uix:case name="true">              
      <uix:tip> 
        <uix:styledText textBinding="PM_EDIT_SRL_UPGRADE_SUPPORT_TIP@DGMsgBundle@servletRequest"/>
      </uix:tip>
    </uix:case>
    </uix:switcher>

    <uix:switcher childNameBinding="nonSupportedDB@dataProtectionTable@configBean@servletRequest" defaultCase="false">
    <uix:case name="true">              
      <uix:tip> 
        <uix:styledText textBinding="nonSupportTip@editProtBean@configBean@servletRequest"/>
      </uix:tip>
    </uix:case>
    </uix:switcher>

  </uix:header>
<%-- Standby Databases - End --%>

<%-- AFO Properties - Begin --%>
  <uix:header textBinding="AFO_CONFIG_OBSERVER_HEADER@DGMsgBundle@servletRequest"
              renderedBinding="isAfo@editProtBean@configBean@servletRequest">

    <uix:rowLayout width="90%">
      <uix:contents>
          <uix:styledText styleClass="OraFieldText" textBinding="AFO_CONFIG_PROP_INFO@DGMsgBundle@servletRequest"/>
     </uix:contents>	
    </uix:rowLayout>

    <uix:rowLayout width="90%">
      <uix:contents>
      <uix:tip>  
        <uix:styledText textBinding="AFO_CONFIG_PROP_TIP1@DGMsgBundle@servletRequest"/>
      </uix:tip>
    </uix:contents>	
    </uix:rowLayout>

    <uix:spacer height="5"/>			   

    <uix:rowLayout>
     <uix:contents>
      <uix:spacer width="50"/>			   
      <uix:tableLayout summary="tl"> 
       <uix:contents>
        <uix:rowLayout>
         <uix:contents>
          <uix:cellFormat hAlign="right" headers=""> 
           <uix:contents>
            <uix:messagePrompt
                promptBinding="AFO_CONFIG_OBSERVER_HOST@DGMsgBundle@servletRequest"
                messageType="info"/>
            <uix:spacer width="10"/>			   
           </uix:contents>	
          </uix:cellFormat>
         </uix:contents>	
        </uix:rowLayout>

        <uix:switcher childNameBinding="showCAOption@editProtBean@configBean@servletRequest" defaultCase="false">
          <uix:case name="true">
            <uix:rowLayout>
             <uix:contents>
              <uix:cellFormat hAlign="right" headers=""> 
               <uix:contents>
                <uix:messagePrompt
                    promptBinding="ALT_OBSERVER_HOST@DGMsgBundle@servletRequest"
                    messageType="info"/>
                <uix:spacer width="10"/>			   
               </uix:contents>	
              </uix:cellFormat>
             </uix:contents>	
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>
       </uix:contents>	
      </uix:tableLayout>

      <uix:tableLayout summary="tl"> 
       <uix:contents>
        <uix:rowLayout>
         <uix:contents>
          <uix:cellFormat hAlign="left" headers=""> 
           <uix:contents>
            <uix:styledText styleClass="OraInstructionTextStrong" 
                       textBinding="observerHost2@editProtBean@configBean@servletRequest"/>
           </uix:contents>	
          </uix:cellFormat>
         </uix:contents>	
        </uix:rowLayout>

        <uix:switcher childNameBinding="showCAOption@editProtBean@configBean@servletRequest" defaultCase="false">
          <uix:case name="true">
            <uix:rowLayout>
             <uix:contents>
              <uix:cellFormat hAlign="left" headers=""> 
               <uix:contents>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                           textBinding="altObserverHost2@editProtBean@configBean@servletRequest"/>
               </uix:contents>	
              </uix:cellFormat>
             </uix:contents>	
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>
      </uix:contents>	
      </uix:tableLayout>

      <uix:spacer width="10"/>			   
  <uix:submitButton textBinding="observerButton@editProtBean@configBean@servletRequest" 
                    formName="editProtSRLForm" 
                    name="event" value="editObserver"  shortDescBinding="observerButton@editProtBean@configBean@servletRequest"/> 
     </uix:contents>	
    </uix:rowLayout>
  </uix:header>

  <uix:header textBinding="AFO_CONFIG_PROP_HEADER@DGMsgBundle@servletRequest"
              renderedBinding="isAfo@editProtBean@configBean@servletRequest">
    <uix:spacer height="10"/>
    <uix:tableLayout width="100%" summary="tl"> 
        
      <uix:rowLayout>
        <uix:stackLayout>
          <uix:contents>
            <uix:labeledFieldLayout width="80%" labelWidth="30%">    
              <uix:messageTextInput name="afoTimeout"
                          id="afoTimeout" 
                          columns="3" labeledNodeId="timeUnits"
                          promptBinding="AFO_CONFIG_AFO_TIMEOUT@DGMsgBundle@servletRequest"
                          textBinding="afoTimeout@editProtBean@configBean@servletRequest"
                          messageBinding="AFO_CONFIG_AFO_TIMEOUT_TIP@DGMsgBundle@servletRequest"
                          messageType="info"
                          longDescURL="<%=StandbyProperties.getPropertyDest(DGMsgID.AFO_CONFIG_AFO_TIMEOUT)%>">
                <uix:end>
                  <uix:flowLayout>
                    <uix:contents>
                      <uix:choice name="timeUnits" 
                                selectedValueBinding="timeUnits@editProtBean@configBean@servletRequest" >
                        <uix:option textBinding="SECONDS@DGMsgBundle@servletRequest" value="SEC" />
                        <uix:option textBinding="MINUTES@DGMsgBundle@servletRequest" value="MIN" />
                      </uix:choice>
                      <%-- uix:submitButton textBinding="AFO_CONFIG_THRESHOLD_TUNING_ADVISOR@DGMsgBundle@servletRequest"
                                formName="editProtSRLForm"
                                renderedBinding="shouldThresholdAdvisorRendered@editProtBean@configBean@servletRequest"
                                name="event" value="thresholdTuningAdvisor"/ --%>
                    </uix:contents>
                  </uix:flowLayout>
                </uix:end>
              </uix:messageTextInput>
            </uix:labeledFieldLayout>
          </uix:contents>
        </uix:stackLayout>
      </uix:rowLayout>

      <uix:rowLayout  renderedBinding="showFSFOLagLimit@editProtBean@configBean@servletRequest" >
        <uix:stackLayout>
          <uix:contents>         
            <uix:labeledFieldLayout width="80%" labelWidth="30%">
            
              <uix:messageTextInput name="fsfoLagLimit"
                      id="fsfoLagLimit" 
                      columns="3" labeledNodeId="fsfoLagLimitUnits"
                      promptBinding="AFO_CONFIG_FSFO_LAG_LIMIT@DGMsgBundle@servletRequest"
                      messageBinding="AFO_CONFIG_FSFO_LAG_LIMIT_TIP@DGMsgBundle@servletRequest"
                      textBinding="fsfoLagLimit@editProtBean@configBean@servletRequest" >
                <uix:end>
                  <uix:flowLayout>
                    <uix:contents>
                      <uix:choice name="fsfoLagLimitUnits" 
                                selectedValueBinding="fsfoLagLimitUnits@editProtBean@configBean@servletRequest" >
                        <uix:option textBinding="SECONDS@DGMsgBundle@servletRequest" value="SEC" />
                        <uix:option textBinding="MINUTES@DGMsgBundle@servletRequest" value="MIN" />
                      </uix:choice>
                    </uix:contents>
                  </uix:flowLayout>
                </uix:end>
              </uix:messageTextInput>
              
            </uix:labeledFieldLayout>
          </uix:contents>
        </uix:stackLayout>            
      </uix:rowLayout>
      
      <uix:rowLayout renderedBinding="is110@configBean@servletRequest">
        <uix:stackLayout>
          <uix:contents>         
            <uix:labeledFieldLayout width="80%" labelWidth="30%">
              <uix:contents>
                <uix:styledText textBinding="AFO_CONFIG_FAILOVER_CONDITIONS@DGMsgBundle@servletRequest" />
                <uix:submitButton textBinding="EDIT@DGMsgBundle@servletRequest"
                                  formName="editProtSRLForm"
                                  name="event" value="editFailoverConditions"  shortDescBinding="EDIT@DGMsgBundle@servletRequest"/> 
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:contents>
        </uix:stackLayout>            
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:header>
      


  <uix:header textBinding="AFO_CONFIG_DB_PROP_HEADER@DGMsgBundle@servletRequest"
              renderedBinding="isAfoAnd110@editProtBean@configBean@servletRequest">
    <uix:spacer height="10"/>
    <uix:tableLayout width="100%" summary="tl"> 

     <uix:rowLayout>
        <uix:stackLayout>
          <uix:contents>         
            <uix:labeledFieldLayout width="80%" labelWidth="30%">
              <uix:contents>
                <uix:styledText textBinding="AFO_CONFIG_REINSTATE_PRIMARY@DGMsgBundle@servletRequest" />
                <uix:choice name="reinstatePrimary" 
                        selectedValueBinding="reinstatePrimary@editProtBean@configBean@servletRequest" >
                        <uix:option textBinding="YES@DGMsgBundle@servletRequest" value="YES" />
                        <uix:option textBinding="NO@DGMsgBundle@servletRequest" value="NO" />
                </uix:choice>
                <uix:styledText styleClass="OraInlineInfoText" text="" />
                <uix:styledText styleClass="OraInlineInfoText" textBinding="reinstatePrimaryTip@editProtBean@configBean@servletRequest" />
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:contents>
        </uix:stackLayout>            
      </uix:rowLayout>

     <uix:rowLayout>
        <uix:stackLayout>
          <uix:contents>         
            <uix:labeledFieldLayout width="80%" labelWidth="30%">
              <uix:contents>
                <uix:styledText textBinding="AFO_CONFIG_SHUTDOWN_PRIMARY@DGMsgBundle@servletRequest" />
                    <uix:choice name="shutdownPrimary" 
                        selectedValueBinding="shutdownPrimary@editProtBean@configBean@servletRequest" >
                        <uix:option textBinding="YES@DGMsgBundle@servletRequest" value="YES" />
                        <uix:option textBinding="NO@DGMsgBundle@servletRequest" value="NO" />
                </uix:choice>
                <uix:styledText styleClass="OraInlineInfoText" text="" />
                <uix:styledText styleClass="OraInlineInfoText" textBinding="shutdownPrimaryTip@editProtBean@configBean@servletRequest" />
          </uix:contents>
        </uix:labeledFieldLayout>
      </uix:contents>
    </uix:stackLayout>            
  </uix:rowLayout>    
 </uix:tableLayout>
</uix:header>

<%-- AFO Properties - End --%>

<%-- Standby Redo Logs - Begin --%>

  <uix:header textBinding="PM_EDIT_SRL_SRL_HEADER@DGMsgBundle@servletRequest" renderedBinding="showSRLTable@editProtBean@configBean@servletRequest">

    <uix:rowLayout width="90%">
      <uix:contents>
        <uix:stackLayout>
         <uix:contents>
          <uix:styledText styleClass="OraFieldText" labeledNodeId="standbyRedoLogsTable"
                  textBinding="PM_EDIT_SRL_UPGRADE_SRL_INFO@DGMsgBundle@servletRequest"/>
          <uix:spacer height="10"/>			   
        </uix:contents>	
     </uix:stackLayout>
    </uix:contents>	
    </uix:rowLayout>

    <uix:rowLayout width="90%">
     <uix:messageCheckBox 
          name="useOMF" 
          styleClass="OraFieldText" 
          textBinding="SRL_OMF_CHECKBOX@DGMsgBundle@servletRequest" 
          checkedBinding="useOMF@editProtBean@configBean@servletRequest"
          renderedBinding="showOMFCheckbox@editProtBean@configBean@servletRequest"
          value="true" 
          onClick="submitForm('editProtSRLForm', true, {'event':'useOMFSRL'})"/>
    </uix:rowLayout>

    <uix:rowLayout width="80%" renderedBinding="showOMFCheckbox@editProtBean@configBean@servletRequest">
     <uix:contents>
      <uix:spacer width="22"/>			   
      <uix:styledText styleClass="OraInlineInfoText" textBinding="useOMFTip@editProtBean@configBean@servletRequest"/>
     </uix:contents>
    </uix:rowLayout>

    <uix:contents>
    <oem:table name="standbyRedoLogsTable" 
               id="standbyRedoLogsTable" 
               blockSize="10"
               partialRenderMode="self"
               width="80%" 
               beanKey="configBean" 
               dataSourceProp="standbyRedoLogsTable" 
               summaryBinding="PM_EDIT_SRL_SRL_HEADER@DGMsgBundle@servletRequest"
               alternateTextBinding="SRL_COUNT_OK@DGMsgBundle@servletRequest" 
               shortDescBinding="SELECT@DBMsgBundle@servletRequest" 
               formSubmitted="true"> 
    </oem:table>
    <uix:spacer width="4"/>
    </uix:contents>

  </uix:header>
<%-- Standby Redo Logs - End --%>

  		

       </uix:pageLayout>
     </db:form>
     </uix:body>

  </uix:document> 
</uix:renderingContext>
