<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.dg.rsc.DGMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <jsp:useBean id="dbBean" class="oracle.sysman.db.dg.util.DBInfo" scope="request"/>
    <%@ include file="/enablePPR.jspf" %> 
    <uix:metaContainer> 
      <uix:head titleBinding="nameHeaderTitle@dbBean@servletRequest"/> 
    </uix:metaContainer> 

    <uix:body>
     <db:form name="editDBForm" method="post" destination="/console/database/dataguard" copyParams="target,type">
      <uix:formValue name="pageNum" value="3"/>
      <uix:formValue name="dbName" valueBinding="name@dbBean@servletRequest"/>
      <uix:formValue name="pageName" value="/database/dataguard/editStandbyProps"/>

      <uix:pageLayout titleBinding="nameHeader@dbBean@servletRequest">

      <%@ include file="/database/global.jspf" %>

	    <%@ include file="/database/dataguard/errors.jspf" %>

       <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="1">          
                <uix:link textBinding="GENERAL@DGMsgBundle@servletRequest"
                  onClick="submitForm('editDBForm', true, {event:'editDBGeneral'})"/>
                <uix:link textBinding="STBY_ROLE@DGMsgBundle@servletRequest"/>
                <uix:link textBinding="COMM_ROLE@DGMsgBundle@servletRequest"
                  onClick="submitForm('editDBForm', true, {event:'editDBCommon'})"/>
            </uix:subTabBar>
          </uix:subTabs>

          <uix:spacer width="8"/>

          <uix:tableLayout  cellSpacing="3" summary="tl"> 
           <uix:contents>
          <uix:rowLayout>
           <uix:contents>
          <uix:spacer width="3"/>
          <uix:tip>
            <uix:contents>
              <uix:styledText 
                textBinding="standbyTip@dbBean@servletRequest"/>
            </uix:contents>
          </uix:tip>
           </uix:contents>
          </uix:rowLayout>
          </uix:contents>
         </uix:tableLayout>

          <uix:spacer width="8"/>

          <uix:labeledFieldLayout width="75%">
           <uix:contents>

  
          <uix:rowLayout hAlign="right">
           <uix:contents>
            <uix:image source="<%=dbBean.getMessageTypeImage(DGMsgID.LOGXPTMODE)%>" shortDescBinding="DETAILS@DGMsgBundle@servletRequest"
                destination="<%=dbBean.getPropertyDest(DGMsgID.LOGXPTMODE)%>" />            
            <uix:spacer width="5"/>
            <uix:styledText styleClass="OraPromptText" labeledNodeId="<%=dbBean.getPropertyString(DGMsgID.LOGXPTMODE)%>"
                      text="<%=dbBean.getPropertyName(DGMsgID.LOGXPTMODE)%>" />
          </uix:contents>
          </uix:rowLayout>
           <uix:flowLayout>
           <oem:choice name="<%=dbBean.getPropertyString(DGMsgID.LOGXPTMODE)%>" 
                                id="<%=dbBean.getPropertyString(DGMsgID.LOGXPTMODE)%>"
                                selectedValue="<%=dbBean.getPropertyValue(DGMsgID.LOGXPTMODE)%>" 
                                optionsBinding="logXPTModeOptions@dbBean@servletRequest"/>
            <%--<uix:submitButton 
                 textBinding="REDO_TRANSPORT_ADVISOR@DGMsgBundle@servletRequest" 
                 renderedBinding="is110@dbBean@servletRequest"
                 formName="editDBForm" 
                 name="event" value="showRedoAdvisor"  shortDesc="image"/> --%>
           </uix:flowLayout>
           <uix:styledText styleClass="OraInlineInfoText" text=""/>
           <uix:styledText styleClass="<%=dbBean.getStyleClass(DGMsgID.LOGXPTMODE)%>" text="<%=dbBean.getMessage(DGMsgID.LOGXPTMODE,DGMsgID.LOGXPT_DESC)%>" />

					<uix:messageTextInput 
                  renderedBinding="is10i@dbBean@servletRequest"
                  name="<%=dbBean.getPropertyString(DGMsgID.NET_TIMEOUT)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.NET_TIMEOUT)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.NET_TIMEOUT)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.NET_TIMEOUT)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.NET_TIMEOUT,DGMsgID.NET_TIMEOUT_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.NET_TIMEOUT)%>"
                  columns="4" >
  				</uix:messageTextInput>
					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.DELAYMINS)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.DELAYMINS)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.DELAYMINS)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.DELAYMINS)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.DELAYMINS,DGMsgID.DELAYMINS_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.DELAYMINS)%>"
                  columns="4" >
  				</uix:messageTextInput>
                  
<%           if (dbBean.isRAC()) { %>

<%             if (dbBean.isUsingRecoveryArea()) { %> <%-- 10i, RAC, RECOVERY_AREA --%>

					<uix:messagePrompt prompt="<%=dbBean.getPropertyName(DGMsgID.RECOVERY_AREA)%>"
                             messageType="info"
                             longDescURL="<%=dbBean.getPropertyDest(DGMsgID.RECOVERY_AREA)%>"/>
          <uix:link textBinding="recAreaLink@dbBean@servletRequest"
                    destinationBinding="recSettingsDest@dbBean@servletRequest"/>
					<uix:messagePrompt prompt=""/>
          <uix:styledText styleClass="OraInlineInfoText" text="<%=dbBean.getMessage(DGMsgID.RECOVERY_AREA,DGMsgID.RECOVERY_AREA_DESC)%>"/>


            <% } else { %>  <%-- No RecoverArea  --%>

              <uix:styledText styleClass="OraInlineInfoText" text=""/>
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
    					<uix:messagePrompt prompt="<%=dbBean.getPropertyName(DGMsgID.STANDBYARCHIVELOC)%>"
                             messageType="info"
                             longDescURL="<%=dbBean.getPropertyDest(DGMsgID.STANDBYARCHIVELOC)%>"/>
              <oem:table name="<%=dbBean.getPropertyString(DGMsgID.STANDBYARCHIVELOC)%>" beanKey="dbBean" alternateTextBinding="NO_DATA@DGMsgBundle@servletRequest"
                summaryBinding="STANDBYARCHIVELOC@DGMsgBundle@servletRequest" dataSourceProp="standbyArchiveLocationRAC"  formSubmitted="true" destination="/console/database/dataguard/dataguardConfig"/> 
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
              <uix:styledText styleClass="<%=dbBean.getStyleClass(DGMsgID.STANDBYARCHIVELOC)%>" text="<%=dbBean.getMessage(DGMsgID.STANDBYARCHIVELOC,DGMsgID.STANDBYARCHDEST_RACDESC)%>" />
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
              <uix:styledText styleClass="OraInlineInfoText" text=""/>

          <% } %>   <%-- 10i RAC  --%>

            <uix:rowLayout hAlign="right">
             <uix:contents>
              <uix:image source="<%=dbBean.getMessageTypeImage(DGMsgID.PREFERREDAPPLYINST)%>" shortDescBinding="DETAILS@DGMsgBundle@servletRequest"
                  destination="<%=dbBean.getPropertyDest(DGMsgID.PREFERREDAPPLYINST)%>" />            
              <uix:spacer width="5"/>
              <uix:styledText styleClass="OraPromptText" labeledNodeId="<%=dbBean.getPropertyString(DGMsgID.PREFERREDAPPLYINST)%>" text="<%=dbBean.getPropertyName(DGMsgID.PREFERREDAPPLYINST)%>" />
            </uix:contents>
            </uix:rowLayout>
             <oem:choice name="<%=dbBean.getPropertyString(DGMsgID.PREFERREDAPPLYINST)%>" 
                           id="<%=dbBean.getPropertyString(DGMsgID.PREFERREDAPPLYINST)%>"
                selectedValue="<%=dbBean.getPropertyValue(DGMsgID.PREFERREDAPPLYINST)%>" 
                                  optionsBinding="preferredApplyOptions@dbBean@servletRequest"/>
             <uix:styledText styleClass="OraInlineInfoText" text=""/>
             <uix:styledText styleClass="<%=dbBean.getStyleClass(DGMsgID.PREFERREDAPPLYINST)%>" text="<%=dbBean.getMessage(DGMsgID.PREFERREDAPPLYINST,DGMsgID.PREFERREDAPPLYINST_DESC)%>" />

<% } else if (dbBean.is9i()) { %>

					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.STANDBYARCHIVEDEST)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.STANDBYARCHIVEDEST)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.STANDBYARCHIVEDEST)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.STANDBYARCHIVEDEST)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.STANDBYARCHIVEDEST,DGMsgID.STANDBYARCHDEST_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.STANDBYARCHIVEDEST)%>" />

<% } else if (dbBean.isUsingRecoveryArea()) { %>

					<uix:messagePrompt prompt="<%=dbBean.getPropertyName(DGMsgID.RECOVERY_AREA)%>"
                             messageType="info"
                             longDescURL="<%=dbBean.getPropertyDest(DGMsgID.RECOVERY_AREA)%>"/>
          <uix:link textBinding="recAreaLink@dbBean@servletRequest"
                    destinationBinding="recSettingsDest@dbBean@servletRequest"/>
					<uix:messagePrompt prompt=""/>
          <uix:styledText styleClass="OraInlineInfoText" text="<%=dbBean.getMessage(DGMsgID.RECOVERY_AREA,DGMsgID.RECOVERY_AREA_DESC)%>"/>

<% } else { %>  <%-- 10i StandbyArchiveLocation --%>

					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.STANDBYARCHIVELOC)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.STANDBYARCHIVELOC)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.STANDBYARCHIVELOC)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.STANDBYARCHIVELOC)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.STANDBYARCHIVELOC,DGMsgID.STANDBYARCHDEST_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.STANDBYARCHIVELOC)%>" />

<% } %>

           </uix:contents>
          </uix:labeledFieldLayout>

          <uix:spacer width="8"/>

          
         

         <uix:hideShow formSubmitted="true" disclosedTextBinding="HIDE_ADV@DGMsgBundle@servletRequest"
            id="hideShow" undisclosedTextBinding="SHOW_ADV@DGMsgBundle@servletRequest" 
            partialRenderMode="self"
            disclosedBinding="advancedOptions@dbBean@servletRequest">
          <uix:contents>

          <uix:spacer width="8"/>

          <uix:labeledFieldLayout width="75%">
           <uix:contents>

          <uix:rowLayout hAlign="right">
           <uix:contents>
            <uix:image sourceBinding="detailsImage@servletRequest" shortDescBinding="DETAILS@DGMsgBundle@servletRequest"
                destination="<%=dbBean.getPropertyDest(DGMsgID.LOGSHIPPING)%>" />            
            <uix:spacer width="5"/>
            <uix:styledText styleClass="OraPromptText" labeledNodeId="<%=dbBean.getPropertyString(DGMsgID.LOGSHIPPING)%>"
                      text="<%=dbBean.getPropertyName(DGMsgID.LOGSHIPPING)%>" />
          </uix:contents>
          </uix:rowLayout>
           <oem:choice name="<%=dbBean.getPropertyString(DGMsgID.LOGSHIPPING)%>"
                                id="<%=dbBean.getPropertyString(DGMsgID.LOGSHIPPING)%>"
                                selectedValue="<%=dbBean.getPropertyValue(DGMsgID.LOGSHIPPING)%>" 
                                optionsBinding="logShippingOptions@dbBean@servletRequest"/>
           <uix:styledText styleClass="OraInlineInfoText" text=""/>
           <uix:styledText styleClass="<%=dbBean.getStyleClass(DGMsgID.LOGSHIPPING)%>" text="<%=dbBean.getMessage(DGMsgID.LOGSHIPPING,DGMsgID.LOGSHIP_DESC)%>" />

<%    if (!dbBean.is9i()) { %>  

          <uix:rowLayout hAlign="right" renderedBinding="isNot102@dbBean@servletRequest">
           <uix:contents>
            <uix:image source="<%=dbBean.getMessageTypeImage(DGMsgID.REALTIMEAPPLY)%>" shortDescBinding="DETAILS@DGMsgBundle@servletRequest"
                destination="<%=dbBean.getPropertyDest(DGMsgID.REALTIMEAPPLY)%>" />            
            <uix:spacer width="5"/>
            <uix:styledText styleClass="OraPromptText" labeledNodeId="<%=dbBean.getPropertyString(DGMsgID.REALTIMEAPPLY)%>"
                      text="<%=dbBean.getPropertyName(DGMsgID.REALTIMEAPPLY)%>" />
          </uix:contents>
          </uix:rowLayout>
           <oem:choice name="<%=dbBean.getPropertyString(DGMsgID.REALTIMEAPPLY)%>" 
                                id="<%=dbBean.getPropertyString(DGMsgID.REALTIMEAPPLY)%>"
                                selectedValue="<%=dbBean.getPropertyValue(DGMsgID.REALTIMEAPPLY)%>" 
                                optionsBinding="realTimeApplyOptions@dbBean@servletRequest"
                                renderedBinding="isNot102@dbBean@servletRequest"/>
           <uix:styledText styleClass="OraInlineInfoText" text="" renderedBinding="isNot102@dbBean@servletRequest"/>
           <uix:styledText styleClass="<%=dbBean.getStyleClass(DGMsgID.REALTIMEAPPLY)%>" text="<%=dbBean.getMessage(DGMsgID.REALTIMEAPPLY,DGMsgID.REALTIMEAPPLY_DESC)%>" renderedBinding="isNot102@dbBean@servletRequest"/>
    <% } %>

					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.DBFILENAMECONVERT)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.DBFILENAMECONVERT)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.DBFILENAMECONVERT)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.DBFILENAMECONVERT)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.DBFILENAMECONVERT,DGMsgID.DBFILE_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.DBFILENAMECONVERT)%>" />

					<uix:messageTextInput 
                  name="<%=dbBean.getPropertyString(DGMsgID.LOGFILENAMECONVERT)%>" 
                  prompt="<%=dbBean.getPropertyName(DGMsgID.LOGFILENAMECONVERT)%>" 
                  text="<%=dbBean.getPropertyValue(DGMsgID.LOGFILENAMECONVERT)%>" 
                  messageType="<%=dbBean.getMessageType(DGMsgID.LOGFILENAMECONVERT)%>" 
                  message="<%=dbBean.getMessage(DGMsgID.LOGFILENAMECONVERT,DGMsgID.LOGFILE_DESC)%>"
                  longDescURL="<%=dbBean.getPropertyDest(DGMsgID.LOGFILENAMECONVERT)%>" />

           </uix:contents>
          </uix:labeledFieldLayout>

          <%-- Include logical standby properties if appropriate. --%>
          
           <%@ include file="editLsbyProps.jspf" %> 

          </uix:contents>
        </uix:hideShow>

          <uix:spacer width="8"/>

         </uix:subTabLayout>
   
      <uix:pageButtons>
        <uix:pageButtonBar>
                <uix:submitButton textBinding="REVERT@DGMsgBundle@servletRequest" name="event" value="revert" unvalidated="true" formName="editDBForm" shortDescBinding="REVERT@DGMsgBundle@servletRequest"/> 
                <uix:submitButton textBinding="APPLY@DGMsgBundle@servletRequest" name="event" value="apply" formName="editDBForm" shortDescBinding="APPLY@DGMsgBundle@servletRequest"/> 
        </uix:pageButtonBar>
      </uix:pageButtons>

     </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document> 
</uix:renderingContext> 
