<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="confirmTitle@stateBean@configBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="roleChangeForm" method="POST" destination="/em/console/database/dataguard/failover" copyParams="target,type">
    <uix:formValue name="pageName"
    value="database/dataguard/failover"/>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>

     <oem:messageBox messageType="info"
                     errorTableBinding="info@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/>
     <oem:messageBox messageType="error"
                     errorTableBinding="errors@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="warning"
                    errorTableBinding="warning@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:contentFooter>
      <uix:pageButtonBar>
      <uix:contents>
          <uix:submitButton textBinding="NO@DGMsgBundle@servletRequest" name="event" value="cancelFailover" shortDescBinding="NO@DGMsgBundle@servletRequest"/>
          <uix:submitButton textBinding="YES@DGMsgBundle@servletRequest" name="event" value="doFailover" shortDescBinding="YES@DGMsgBundle@servletRequest"/>
      </uix:contents>
      </uix:pageButtonBar>
    </uix:contentFooter>

    <uix:header textBinding="confirmHeader@stateBean@configBean@servletRequest" messageType="confirmation">
    <uix:contents>
    <uix:rowLayout width="90%">
      <uix:contents>
        <uix:spacer width="25"/>
        <uix:stackLayout>

          <uix:rowLayout>
            <uix:contents>
              <uix:styledText styleClass="OraDataText" textBinding="confirmMsg@stateBean@configBean@servletRequest"/>
            </uix:contents>
          </uix:rowLayout>

          <uix:spacer height="15"/>

          <uix:styledText styleClass="OraPromptText" textBinding="introMsg@stateBean@configBean@servletRequest"/>

          <uix:spacer height="5"/>

          <uix:tip renderedBinding="showTip@stateBean@configBean@servletRequest">
            <uix:styledText textBinding="FAILOVER_CONFIG_PRIMARY_RUNNING@DGMsgBundle@servletRequest"/>
          </uix:tip>

          <uix:header textBinding="FAILOVER_FAILTYPE_TITLE@DGMsgBundle@servletRequest">

          <uix:stackLayout>
            <uix:contents>

              <uix:rowLayout  width="90%">
                <uix:contents>

                  <uix:cellFormat hAlign="left" vAlign="top" headers="">
                    <uix:contents>
                      <uix:radioButton name="fotype" selected="true" valueBinding="GRACEFUL@defaultBean@servletRequest" textBinding="FAILOVER_FAILTYPE_COMPLETE@DGMsgBundle@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout  width="90%">
                <uix:contents>

                  <uix:cellFormat hAlign="left" vAlign="top" headers="">
                    <uix:contents>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="FAILOVER_COMPLETE_INFO@DGMsgBundle@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>

              <uix:spacer height="5"/>

              <uix:rowLayout width="90%">
                <uix:contents>

                  <uix:cellFormat hAlign="left" vAlign="top" headers="">
                    <uix:contents>
                      <uix:radioButton name="fotype" valueBinding="FORCED@defaultBean@servletRequest" textBinding="FAILOVER_FAILTYPE_IMMEDIATE@DGMsgBundle@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout  width="90%">
                <uix:contents>

                  <uix:cellFormat hAlign="left" vAlign="top" headers="">
                    <uix:contents>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="FAILOVER_IMMEDIATE_INFO@DGMsgBundle@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>

            </uix:contents>
          </uix:stackLayout>

          </uix:header>
          <uix:spacer height="15"/>

 <%--...................... Jobs and Monitoring Template Swap .......................--%>
       <%@ include file="jobTable.jspf" %>
 <%--...................... Jobs and Monitoring Template Swap .......................--%>

        </uix:stackLayout>
      </uix:contents>
    </uix:rowLayout>

    </uix:contents>
    </uix:header>

    </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>




