<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="AFO_THRESHOLD_ADVISOR_HEADER@DGMsgBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="afoThresholdAdvisor" method="POST" destination="/em/console/database/dataguard/fsfoThresholdTuning" copyParams="target,type">
        <uix:pageLayout titleBinding="AFO_THRESHOLD_ADVISOR_HEADER@DGMsgBundle@servletRequest">
          <%@ include file="/database/global.jspf"%>
          <%@ include file="/database/dataguard/errors.jspf"%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:contents>
                <uix:submitButton textBinding="OK@DGMsgBundle@servletRequest" formName="afoThresholdAdvisor" name="event" value="editOk" shortDescBinding="OK@DGMsgBundle@servletRequest"/> 
              </uix:contents>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <uix:rowLayout>
            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraFieldText" textBinding="AFO_THRESHOLD_ADVISOR_TIP_1@DGMsgBundle@servletRequest"/>
                  <uix:flowLayout>
                    <uix:separator>
                      <uix:spacer width="10" height="1"/>
                    </uix:separator>
                    <uix:contents>
                      <uix:tableLayout summary="tl"> 
                        <uix:cellFormat width="50%" vAlign="top" headers=""> 
                          <uix:tableLayout width="90%" summary="tl"> 
                            <uix:rowLayout>
                              <uix:header textBinding="AFO_THRESHOLD_ADVISOR_NETWORK_LATENCY_STATISTICS@DGMsgBundle@servletRequest">
                                <uix:labeledFieldLayout width="100%" labelWidth="40%" fieldWidth="60%" columns="2">
                                  <uix:styledText styleClass="OraFieldText" textBinding="AFO_THRESHOLD_ADVISOR_AVERAGE_VALUE@DGMsgBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraFieldText" textBinding="averageValue@thresholdAdvisorStatistics@servletRequest"/>
                                </uix:labeledFieldLayout>
                                <uix:labeledFieldLayout width="100%" labelWidth="40%" fieldWidth="60%" columns="2">
                                  <uix:styledText styleClass="OraFieldText" textBinding="AFO_THRESHOLD_ADVISOR_MAX_VALUE@DGMsgBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraFieldText" textBinding="maxValue@thresholdAdvisorStatistics@servletRequest"/>
                                </uix:labeledFieldLayout>
                                <uix:labeledFieldLayout width="100%" labelWidth="40%" fieldWidth="60%" columns="2">
                                  <uix:styledText styleClass="OraFieldText" textBinding="AFO_THRESHOLD_ADVISOR_TOP_TEN_VALUES@DGMsgBundle@servletRequest"/>
                                  <oem:table name="topTenValuesTable" beanKey="thresholdAdvisorStatistics" id="topTenValuesTable" formSubmitted="false" dataSourceProp="topTenValues" blockSize="10" alternateTextBinding="NO_ITEMS_FOUND@DGMsgBundle@servletRequest"/>
                                </uix:labeledFieldLayout>
                              </uix:header>
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:cellFormat>
                        <uix:cellFormat width="50%" vAlign="top" headers=""> 
                          <uix:tableLayout width="90%" summary="tl"> 
                            <uix:rowLayout>
                              <uix:header textBinding="AFO_THRESHOLD_ADVISOR_DATA_FILTERS@DGMsgBundle@servletRequest">
                                <uix:labeledFieldLayout width="100%" labelWidth="5%" fieldWidth="95%" columns="2">
                                  <uix:checkBox name="lastDaysSelected" checkedBinding="lastDaysSelected@thresholdAdvisorStatistics@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:styledText styleClass="OraFieldText" textBinding="AFO_THRESHOLD_ADVISOR_DF_MSG_1@DGMsgBundle@servletRequest"/>
                                    <uix:spacer width="5"/>
                                    <uix:textInput columns="3" name="lastDays" textBinding="lastDays@thresholdAdvisorStatistics@servletRequest" required="no">
                                      <uix:onSubmitValidater>
                                        <uix:decimal/>
                                      </uix:onSubmitValidater>
                                    </uix:textInput>
                                    <uix:spacer width="5"/>
                                    <uix:styledText styleClass="OraFieldText" textBinding="AFO_THRESHOLD_ADVISOR_DF_MSG_2@DGMsgBundle@servletRequest"/>
                                  </uix:rowLayout>
                                </uix:labeledFieldLayout>
                                <uix:labeledFieldLayout width="100%" labelWidth="5%" fieldWidth="95%" columns="2">
                                  <uix:spacer/>
                                  <uix:messageText tipBinding="AFO_THRESHOLD_ADVISOR_DF_MSG_1_TIP@DGMsgBundle@servletRequest"/>
                                </uix:labeledFieldLayout>
                                <uix:labeledFieldLayout width="100%" labelWidth="5%" fieldWidth="95%" columns="2">
                                  <uix:spacer/>
                                  <uix:submitButton textBinding="AFO_THRESHOLD_ADVISOR_RECALCULATE@DGMsgBundle@servletRequest" formName="afoThresholdAdvisor" name="event" value="recalculate" shortDescBinding="AFO_THRESHOLD_ADVISOR_RECALCULATE@DGMsgBundle@servletRequest"/> 
                                </uix:labeledFieldLayout>
                              </uix:header>
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:cellFormat>
                      </uix:tableLayout>
                    </uix:contents>
                  </uix:flowLayout>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:rowLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
