<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<%@ page import="java.util.Vector" %>
<%@ page import="oracle.sysman.db.dg.ConfigBean" %>
<%@ page import="oracle.sysman.db.dg.util.DBInfo"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 
<%--
   <%@ include file="/enablePPR.jspf" %> 
 --%>
    <uix:metaContainer>
      <uix:head titleBinding="logSummaryTitle@configBean@servletRequest"/> 
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %>>
    </uix:metaContainer> 

    <uix:body>
     <db:form name="logSummaryForm" method="GET" destination="/console/database/dataguard" copyParams="target,type">
      <uix:formValue name="pageEvent" value="logSummary"/>
      
      <uix:pageLayout>

      <oem:messageBox messageType="info" 
                     errorTableBinding="info@servletRequest" 
                     titleTextKey="titleText" mainTextKey="mainText"/> 
      <oem:messageBox messageType="error" 
                     errorTableBinding="errors@servletRequest" 
                     titleTextKey="titleText" mainTextKey="mainText"/>     
       <%@ include file="/database/global.jspf" %>
      
       <%-- Refresh (View Data) --%>
      <uix:tableLayout width="100%"  summary="tl"> 
        <uix:rowLayout hAlign="right">
        <uix:cellFormat headers=""> 
          <uix:styledText textBinding="VIEW_DATA_LABEL@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice" styleClass="OraInstructionText"/>
          <uix:spacer width="5"/>
          <uix:choice name="refreshChoice" id="refreshChoice" onChange="submitForm('logSummaryForm', true, {'event':'logSummary'})"
              selectedValueBinding="refreshChoice@servletRequest" >
            <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="99999" />
            <uix:option textBinding="REAL_TIME_30_SEC@DBMsgBundle@servletRequest" value="30" />
            <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest" value="60" />
            <uix:option textBinding="REAL_TIME_5_MIN@DBMsgBundle@servletRequest" value="300" />
          </uix:choice>
         </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

       <%-- Page Header --%>
      <uix:header textBinding="logSummaryHeader@configBean@servletRequest" >

       <%-- Refresh (Page) --%>
        <uix:tableLayout width="100%"  summary="tl"> 
          <uix:rowLayout vAlign="top" hAlign="right">
              <uix:cellFormat width="97%" hAlign="right" vAlign="center" headers=""> 
                 <uix:contents> 
                  <oem:pageRefreshed/>
                 </uix:contents>
              </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="center" headers=""> 
              <uix:contents>
                  <uix:image sourceBinding="refreshImage@servletRequest"
                           destinationBinding="logSummaryDest@configBean@servletRequest"
                           shortDescBinding="REFRESH_PAGE@DGMsgBundle@servletRequest" />
             </uix:contents>
           </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>

    <%-- Intro section --%>
    <uix:tableLayout cellSpacing="2" width="100%" summary="tl"> 
     <uix:contents>
      <uix:cellFormat vAlign="top" width="100%" headers=""> 
                    
       <uix:contents>
        <uix:stackLayout>
         <uix:contents>

        <uix:spacer height="5"/>

          <%-- Row 1 - Intro --%>
         <uix:rowLayout>
          <uix:cellFormat headers=""> 
           <uix:styledText styleClass="OraFieldText" textBinding="LFD_INTRO@DGMsgBundle@servletRequest"/> 
          </uix:cellFormat>
         </uix:rowLayout>

        <uix:spacer height="5"/>
 
        <%-- Row 2 - For 9i and 10i non-RAC show Primary Current Log VALUE--%>
        <uix:switcher childNameBinding="primaryRAC@configBean@servletRequest" defaultCase="true">
        <uix:case name="false">              
           <uix:rowLayout>
            <uix:contents>
              <uix:cellFormat hAlign="right" headers=""> 
               <uix:contents>
                 <uix:messagePrompt promptBinding="LFD_PRIMARY_CUR_LOG@DGMsgBundle@servletRequest"/>
               </uix:contents>
              </uix:cellFormat>
             <uix:spacer width="8"/>
             <uix:styledText styleClass="OraDataText" textBinding="currentLog@configBean@servletRequest"/>
            </uix:contents>
           </uix:rowLayout>
        </uix:case>
        </uix:switcher>

         </uix:contents>
         </uix:stackLayout>
       </uix:contents>
 
      </uix:cellFormat>
       </uix:contents>
      </uix:tableLayout>

    <%-- Primary Current Logs header --%>
    <uix:switcher childNameBinding="primaryRAC@configBean@servletRequest" defaultCase="false">
    <uix:case name="true">              

      <uix:header textBinding="LFD_PLOGS_HEADER@DGMsgBundle@servletRequest">
      <%-- For 10i RAC show Primary Current Logs TABLE --%>
        <uix:contents>
        <oem:table name="primaryLogTable" width="20%" beanKey="configBean" blockSize="10"
                dataSourceProp="primaryLogTable" summaryBinding="LOG_FILE_DETAILS@DGMsgBundle@servletRequest"
                formSubmitted="true"> 
            
        </oem:table>
        <uix:spacer width="4"/>
        </uix:contents>
      </uix:header>

    </uix:case>
    </uix:switcher>

<% 
    ConfigBean configBean = ((ConfigBean)(request.getAttribute("configBean")));
    if (configBean != null)
    {
         Vector dbList = configBean.getDBs();
         if (dbList != null)
         {
              for (int i = 0; i < dbList.size(); i++)
              {
                  DBInfo dbInfo = ( DBInfo ) dbList.elementAt(i);
                  if (!dbInfo.isPrimary())
                  {
                      String dbName = dbInfo.getName();
                      String tableName = "logSummaryTable" + dbInfo.getObjectID();
                      String dbBeanName = "dbBean" + dbInfo.getObjectID();
                      request.setAttribute(dbBeanName, dbInfo);

                      String logXptState = dbInfo.getLogTransportState();
                      String logXptStatus = dbInfo.getLogTransportStatus();

                      String logApplyState = dbInfo.getLogApplyState();
                      String dbStatus = dbInfo.getErrorString();
                      String applyDelay = dbInfo.getApplyDelay();
%>
    <uix:header text="<%=dbName%>">

    <uix:tableLayout width="100%" summary="tl"> 
    <uix:contents>

    <%-- Log Transport Section --%>
    <uix:cellFormat width="45%" headers=""> 
    <uix:contents>
    <uix:stackLayout>
    <uix:contents>

    <uix:labeledFieldLayout>
     <uix:contents>

      <%-- Log Transport State --%>
      <uix:messagePrompt promptBinding="LFD_LOG_TRANSPORT_STATE@DGMsgBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText" text="<%=logXptState%>"/>

      <%-- Log Transport Status --%>
      <uix:messagePrompt promptBinding="LFD_LOG_TRANSPORT_STATUS@DGMsgBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText" text="<%=logXptStatus%>"/>
     </uix:contents>
    </uix:labeledFieldLayout>

    </uix:contents>
    </uix:stackLayout>
    </uix:contents>
    </uix:cellFormat>

    <%-- Log Apply Section --%>
    <uix:cellFormat width="45%" headers=""> 
    <uix:contents>
    <uix:stackLayout>
    <uix:contents>

    <uix:labeledFieldLayout>
     <uix:contents>

      <%-- Log Apply State --%>
      <uix:messagePrompt promptBinding="LFD_LOG_APPLY_STATE@DGMsgBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText" text="<%=logApplyState%>"/>

      <%-- DB Status --%>
      <uix:messagePrompt promptBinding="STATUS@DGMsgBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText" text="<%=dbStatus%>"/>

      <%-- Apply Delay --%>
      <uix:messagePrompt promptBinding="LFD_APPLY_DELAY@DGMsgBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText" text="<%=applyDelay%>"/>

     </uix:contents>
    </uix:labeledFieldLayout>

    </uix:contents>
    </uix:stackLayout>
    </uix:contents>
    </uix:cellFormat>

    </uix:contents>
    </uix:tableLayout>

    <%-- Log Summary table for each standby --%>
    <uix:contents>
    <oem:table name="<%=tableName%>" width="95%" beanKey="<%=dbBeanName%>" blockSize="10"
	    summaryBinding="LOG_FILE_DETAILS@DGMsgBundle@servletRequest"
            dataSourceProp="logSummaryTable" alternateTextBinding="LFD_TABLE_EMPTY@DGMsgBundle@servletRequest"
            formSubmitted="true" destination="/console/database/dataguard/logSummary"> 
<%--
            partialRenderMode="self" id="<%=tableName%>"
--%>
            
    </oem:table>
    <uix:spacer width="4"/>
    </uix:contents>
    </uix:header>
<%
                   } // if
              } // for
         } // if
    } // if
%>

   </uix:header>
  </uix:pageLayout>
  </db:form>
  </uix:body>
  </uix:document> 
</uix:renderingContext>
