<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@processBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="processForm" method="post" destinationBinding="destination@processBean@servletRequest" copyParams="target,type">
      <uix:formValue name="pageName" valueBinding="pageName@processBean@servletRequest"/>
     <uix:pageLayout titleBinding="header@processBean@servletRequest" messageType="processing">
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>
             <uix:submitButton renderedBinding="showCancel@processBean@servletRequest"
                               textBinding="cancelButton@processBean@servletRequest"
                               name="event"
                               value="cancelProcess"
                               unvalidated="true"
                               formName="processForm"
			       shortDescBinding="cancelButton@processBean@servletRequest"/>
          </uix:contents>
         </uix:pageButtonBar>
        </uix:pageButtons>

       <uix:pageStatus>
         <uix:stackLayout>
         <uix:contents>
          <uix:styledText styleClass="OraInstructionTextStrong"
                          textBinding="description@processBean@servletRequest"  />
          </uix:contents>
        </uix:stackLayout>
       </uix:pageStatus>

       <uix:contents>
       <uix:stackLayout>
         <uix:contents>
          <uix:spacer height="5" />
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="longDescription@processBean@servletRequest" />

          <uix:spacer height="2" />

         <uix:switcher childNameBinding="showAlertLogs@processBean@servletRequest" defaultCase="false">
            <uix:case name="true">
              <%@ include file="showAlertLogs.jspf" %>
            </uix:case>
          </uix:switcher>

         <uix:spacer height="20" />

        <uix:processing
              id="processingID"
              percentCompleteBinding="percentCompleteData@processBean@servletRequest"
              timeInterval="<%=processingPageInterval%>">
          <uix:contents>

            <uix:tableLayout cellSpacing="1" summary="tl">
              <uix:contents childDataBinding="allStepsData@processBean@servletRequest">

                <uix:rowLayout>
                  <uix:contents >
                    <uix:cellFormat headers="">
                      <uix:contents>
                        <uix:image source="/em/images/processCheck.gif"
                          renderedBinding="renderedDone"/>
                        <uix:image source="/em/images/currentStep.gif"
                          renderedBinding="current"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:spacer width="3" />
                    <uix:cellFormat vAlign="bottom" headers="">
                      <uix:contents >
                      <uix:styledText styleClass="OraFieldText" textBinding="text" />
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>

            <uix:spacer height="10" renderedBinding="showCancelWarn@processBean@servletRequest" />
            <uix:stackLayout>
            <uix:contents>
            <uix:rowLayout hAlign="left" renderedBinding="showCancelWarn@processBean@servletRequest">
              <uix:contents >
                <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="cancelWarn@processBean@servletRequest" messageTypeBinding="cancelWarnType@processBean@servletRequest"/>
              </uix:contents>
            </uix:rowLayout>

            <uix:rowLayout hAlign="right" renderedBinding="showSkipButton@processBean@servletRequest">
              <uix:contents >
                <uix:submitButton textBinding="skipButtonText@processBean@servletRequest"
                                  nameBinding="skippableButtonName@processBean@servletRequest"
                                  valueBinding="skippableButtonValue@processBean@servletRequest"
                                  unvalidated="true"
                                  formName="processForm"
                                  shortDescBinding="skipButtonText@processBean@servletRequest"/>
              </uix:contents>
            </uix:rowLayout>

           <uix:spacer height="10"/>
           <uix:rowLayout hAlign="left" renderedBinding="showSkippableSectionMessage@processBean@servletRequest">
             <uix:contents>
               <uix:tip>
                 <uix:contents>
                   <uix:styledText
                      textBinding="skippableSectionMessage@processBean@servletRequest"/>
                 </uix:contents>
               </uix:tip>
             </uix:contents>
           </uix:rowLayout>

          <uix:switcher childNameBinding="showSkippableSectionMessage@processBean@servletRequest">
            <uix:case name="false">
                <uix:tip renderedBinding="showNoCancel@processBean@servletRequest">
                  <uix:contents>
                    <uix:styledText
                      textBinding="NO_CANCEL@DGMsgBundle@servletRequest"/>
                  </uix:contents>
                </uix:tip>
            </uix:case>
          </uix:switcher>
          </uix:contents>
          </uix:stackLayout>
          </uix:contents>
        </uix:processing>

      </uix:contents>
      </uix:stackLayout>
      </uix:contents>
     </uix:pageLayout>

     </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
