<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>

<script language="javascript">
function getCurrentObjectType()
{
  objectType = document.dbObjectsList.pageObjectType.value;
  return objectType;
}
function popWindow(otype)
{
  if( (otype == '<%=DBObjectMsgID.JAVASOURCE%>') || 
      (otype == '<%=DBObjectMsgID.JAVACLASS%>') ||
      (otype == '<%=DBObjectMsgID.DATABASE_LINK%>') ||
      (otype == '<%=DBObjectMsgID.SYNONYM%>'))
    startLov('schemaName', 'ListSchemaWithPubUser');
  else
    startLov('schemaName', 'ListSchema');
}
</script>

<uix:renderingContext id="renderingContext">
<%-- temporary, will move to DBObjectMsg once NLS msgs files are reopen 
<uix:bundle name="schmTempMsgs" class="oracle.sysman.db.rsc.schm.SchemaTempMsg"/>
--%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="tbspMsgs" class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>
<uix:bundle name="archMsgs" class="oracle.sysman.db.rsc.stor.ArchivelogMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
  <%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <%-- uix:head titleBinding="pluralDisplayName@objectSearchBean@servletRequest"/--%>
</uix:metaContainer>
<uix:body>
<%-- HTML Form --%>
<db:form name="dbObjectsList" method="post" destination="/console/database/databaseObjectsSearch"
         copyParams="target,type,otype">
<uix:formValue name="pageName" value="/database/dbObjectsList"/>
<uix:formValue name="pageObjectType" valueBinding="selectedObjectType@objectSearchBean@servletRequest" />
<uix:formValue name="objectType" valueBinding="realObjectType@objectSearchBean@servletRequest" />
<%-- uix:pageLayout titleBinding="pluralDisplayName@objectSearchBean@servletRequest" --%>
<uix:pageLayout> 

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <%@ include file="/database/informationError.jspf" %>
	
  <%--                                                          --%>
  <%-- Support pageMsgBox for any apps that return to this page --%>
  <%-- and support it.  This include must be positioned AFTER   --%>
  <%-- any other uix:messages or messageBox tags.               --%>
  <%--                                                          --%>
  <%@ include file="/sdk/page/pageMsgBox.jspf" %>

  <uix:header textBinding="pluralDisplayName@objectSearchBean@servletRequest">
  

<%-- 
onChange='<%= "if ((this.value==\'"+DBObjectMsgID.MEASFLDR+"\') || (document.dbObjectsList.pageObjectType.value==\'"+DBObjectMsgID.MEASFLDR+"\')) submitForm(\'dbObjectsList\',1,{\'event\':\'search\'}); else if((this.value==\'"+DBObjectMsgID.INDEX+"\') || (document.dbObjectsList.pageObjectType.value==\'"+DBObjectMsgID.INDEX+"\')) submitForm(\'dbObjectsList\',1,{\'event\':\'switchObjectType\'});" %>'>
--%>
                    <%-- Don't display the choice if only a single object type --%>
                    <uix:switcher childNameBinding="multipleChoice@objectSearchBean@servletRequest">
                      <uix:case name="true">
                        <uix:tableLayout width="100%">
                          <uix:rowLayout width="100%">
                            <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="bottom">
                                <uix:styledText labeledNodeId="selectedObjectType"
                                                styleClass="OraPromptText" 
                                                textBinding="OBJECT_TYPE_COLON@uixDBObjectBundle@servletRequest"/>
                                <uix:choice name="selectedObjectType"
                                            id="selectedObjectType" 
                                            selectedValueBinding="selectedObjectType@objectSearchBean@servletRequest"
                                            onChange='submitForm(\'dbObjectsList\',1,{\'event\':\'switchObjectType\'})'>
                                  <uix:contents childDataBinding="objectTypesInfo@objectSearchBean@servletRequest">
                                    <uix:option textBinding="textKey"
                                                valueBinding="valueKey"/>
                                  </uix:contents>
                                </uix:choice>          
                                <uix:messageText messageBinding="objectType@errors@servletRequest"
                                                  messageType="error"/>
                        </uix:cellFormat>
                        </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:case>
                    </uix:switcher>


    <%-- START: TAB CONTENTS starts here --%>


            <%-- Start of Search Logic --%>
            <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
            <uix:stackLayout>

                <%-- Use different text for different types of objects --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:switcher childNameBinding="schemaObject@objectSearchBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraPromptText" textBinding="SELECT_OBJECT_TYPE_SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:switcher childNameBinding="multipleChoice@objectSearchBean@servletRequest">
                          <uix:case name="true">
                            <uix:styledText styleClass="OraPromptText" textBinding="SELECT_OBJECT_TYPE_MC@uixDBObjectBundle@servletRequest"/>
                          </uix:case>
                        </uix:switcher>
                      </uix:case>
                    </uix:switcher>
                  <%--
                  <uix:submitButton textBinding="ADVANCED_SEARCH@uixDBObjectBundle@servletRequest" name="event" value="advancedSearch"/>
                  --%>
                </uix:contents>
              </uix:rowLayout>

              <uix:tableLayout cellSpacing="5">

<%--
                   <uix:cellFormat vAlign="top" renderedBinding="indexType@objectSearchBean@servletRequest">
                     <uix:stackLayout>
                       <uix:styledText labeledNodeId="schemaName"
                                       styleClass="OraPromptText" textBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"/>
                       <uix:choice name="indexSearchBy"
                                   shortDescBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"
                                   selectedValueBinding="indexSearchBy@objectSearchBean@servletRequest">
                         <uix:contents childDataBinding="indexSearchByOptions@objectSearchBean@servletRequest">
                           <uix:option textBinding="textKey"
                                       valueBinding="valueKey"/>
                         </uix:contents>
                       </uix:choice>
                     </uix:stackLayout>
                   </uix:cellFormat>

                   <uix:cellFormat>
                     <uix:spacer width="8"/>
                   </uix:cellFormat>
--%>

                     <uix:rowLayout renderedBinding="indexType@objectSearchBean@servletRequest">
                       <uix:cellFormat hAlign="right"> 
                       <uix:styledText labeledNodeId="schemaName"
                                       styleClass="OraPromptText" textBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"/>
                          </uix:cellFormat>
                       <uix:choice name="indexSearchBy"
                                   shortDescBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"
                                   selectedValueBinding="indexSearchBy@objectSearchBean@servletRequest">
                         <uix:contents childDataBinding="indexSearchByOptions@objectSearchBean@servletRequest">
                           <uix:option textBinding="textKey"
                                       valueBinding="valueKey"/>
                         </uix:contents>
                       </uix:choice>
                     </uix:rowLayout>

                    <%-- Display schema text input only for schema objects --%>
                    <uix:switcher childNameBinding="showSchemaObject@objectSearchBean@servletRequest">
                      <uix:case name="true">
                        <uix:rowLayout>
                       <uix:cellFormat hAlign="right"> 
                                  <uix:styledText labeledNodeId="schemaName"
                                                  styleClass="OraPromptText" textBinding="SCHEMA_NAME_COLON@uixDBObjectBundle@servletRequest"/>
                          </uix:cellFormat>
                                <uix:messageLovField name="schemaName"
                                             id="schemaName"
                                             textBinding="schemaName@objectSearchBean@servletRequest"
                                             searchDescBinding="SCHEMA_NAME_COLON@uixDBObjectBundle@servletRequest"
                                             onClick='<%= "popWindow(getCurrentObjectType())" %>'/>
                                <uix:messageText messageBinding="schemaName@errors@servletRequest"
                                                  messageType="error"/>
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText labeledNodeId="objectName"
                                        styleClass="OraPromptText" textBinding="OBJECT_NAME_COLON@uixDBObjectBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:rowLayout>
                        <uix:textInput name="objectName" 
                                       id="objectName" textBinding="objectName@objectSearchBean@servletRequest"/>
                      </uix:rowLayout>
                      <uix:messageText messageBinding="objectName@errors@servletRequest"
                                       messageType="error"/>
                      <uix:switcher childNameBinding="schemaObject@objectSearchBean@servletRequest">
                        <uix:case name="false">
                          <uix:rowLayout>
                            <uix:cellFormat/>
                            <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest"
                                              shortDescBinding="GO@uixDBObjectBundle@servletRequest"
                                              onFocus="true" selected="true" name="event" value="search"/>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:rowLayout>

                    
                    <uix:switcher childNameBinding="schemaObject@objectSearchBean@servletRequest">
                      <uix:case name="true">
                    
                        <uix:rowLayout renderedBinding="objectHasStatus@objectSearchBean@servletRequest">
                          <uix:cellFormat hAlign="right"> 
                            <uix:styledText
                                            styleClass="OraPromptText" textBinding="STATUS@dbMsgs"/>
                          </uix:cellFormat>
                          <uix:choice name="selectedObjectStatus"
                                      shortDescBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"
                                      selectedValueBinding="selectedObjectStatus@objectSearchBean@servletRequest">
                           <uix:contents childDataBinding="objectStatusOptions@objectSearchBean@servletRequest">
                             <uix:option textBinding="textKey"
                                         valueBinding="valueKey"/>
                           </uix:contents>
                         </uix:choice>
                        </uix:rowLayout>
                        
                      <%-- Commenting to resolve bug#7317070, to display 'Status' Choice --%>
                      <%--   <uix:rowLayout>
                          <uix:cellFormat/> 
                          <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                                            shortDescBinding="GO@uixDBObjectBundle@servletRequest"
                                            onFocus="true" selected="true" name="event" value="search"/>
                        </uix:rowLayout> --%>
                      </uix:case>
                    </uix:switcher>

                    <%-- Introducing 'swither' to resolve bug#7317070, to display 'Status' Choice & 'Go' button--%>
                    <uix:switcher childNameBinding="schemaObject@objectSearchBean@servletRequest">
                      <uix:case name="true">
                    
                        <uix:rowLayout>
                          <uix:cellFormat/> 
                          <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                                            shortDescBinding="GO@uixDBObjectBundle@servletRequest"
                                            onFocus="true" selected="true" name="event" value="search"/>
                        </uix:rowLayout>

                      </uix:case>
                    </uix:switcher>

              </uix:tableLayout>

              
              <%-- Add Search Hint under the UI --%> 
              <uix:styledText styleClass="OraInlineInfoText" 
                              textBinding="searchHint@objectSearchBean@servletRequest" />

            </uix:stackLayout>
            <%-- /uix:header --%>

            <%-- End of Search Logic --%>
            <uix:separator>
              <uix:spacer height="10"/>
            </uix:separator>

            <uix:tableLayout cellSpacing="5">

            <%-- beginning of CREATE --%>
            <uix:rowLayout width="100%">
              <%-- multiple selection button --%>
              <uix:cellFormat hAlign="left" width="100%"> 
                <uix:styledText styleClass="OraPromptText" textBinding="SELECTION_MODE@dbMsgs"
                                labeledNodeId="selectionMode"
                                renderedBinding="showMultiSelectOption@objectSearchBean@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:choice name="selectionMode"
                            id="selectionMode" 
                            shortDescBinding="SELECTION_MODE@dbMsgs"
                            renderedBinding="showMultiSelectOption@objectSearchBean@servletRequest"
                            selectedValueBinding="selectionMode@objectSearchBean@servletRequest"
                            onChange='submitForm(\'dbObjectsList\',1,{\'event\':\'switchSelectionMode\'})'>
                  <uix:contents childDataBinding="selectionModeOptions@objectSearchBean@servletRequest">
                    <uix:option textBinding="textKey"
                                valueBinding="valueKey"/>
                  </uix:contents>
                </uix:choice>          

<%--
                <uix:checkBox name="isMultipleSelection"
                              textBinding="MULTI_SELECTION@dbMsgs"
                              shortDesc="MVIEW_BUILD_FROM_EXISTING_TABLE@mvMsgs"
                              checkedBinding="isMultipleSelection@objectSearchBean@servletRequest"
                              renderedBinding="showMultiSelectOption@objectSearchBean@servletRequest"
                              onClick="submitForm('dbObjectsList', true, {event:'switchSelectionStyle'})"/>
--%>
              </uix:cellFormat>
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                <uix:switcher childNameBinding="canCreate@objectSearchBean@servletRequest">
                  <uix:case name="true">
                    <uix:submitButton textBinding="CREATE@uixDBObjectBundle@servletRequest" 
                                      shortDescBinding="CREATE@uixDBObjectBundle@servletRequest" 
                                      name="event" 
                                      value="create"/>
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
              
              <uix:cellFormat>
              <uix:switcher childNameBinding="canLoadDrop@objectSearchBean@servletRequest">
                <uix:case name="true">
                  <uix:flowLayout>
                    <uix:submitButton textBinding="LOAD_JAVA@uixDBObjectBundle@servletRequest" 
                                      shortDescBinding="LOAD_JAVA@uixDBObjectBundle@servletRequest"
                                      name="event" 
                                      value="loadjava"/>
                    <uix:submitButton textBinding="DROP_JAVA@uixDBObjectBundle@servletRequest" 
                                      shortDescBinding="DROP_JAVA@uixDBObjectBundle@servletRequest" 
                                      name="event" 
                                      value="dropjava"/>
                  </uix:flowLayout>
                </uix:case>
              </uix:switcher>
            </uix:cellFormat>
           </uix:rowLayout>
            <%-- end of CREATE --%>

             <uix:switcher childNameBinding="canSelect@objectSearchBean@servletRequest">
               <uix:case name="true">
                 <uix:switcher childNameBinding="multipleSelection@objectSearchBean@servletRequest">
                   <uix:case name="true">
                     <uix:stackLayout> 
                       <oem:table name="objectsTwoDUIDataSource" formSubmitted="true" 
                                  width="100%" beanKey="objectSearchBean" blockSize="25"
                                  dataSourceProp="objectsTwoDUIDataSource"  
                                  destination="/console/database/databaseObjectsSearch"
                                  alternateTextBinding="UITableAlterText@objectBean@servletRequest"
                                  summaryBinding="RESULTS@dbMsgs"
                                  showAll="yes"
                                  copyParams="target,type">
                       <uix:tableSelection>
                         <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                                                selectionBinding="multiSelection@objectSearchBean@servletRequest"
                                                selectedBinding="selected">
                          <uix:submitButton textBinding="deleteButtonText@objectSearchBean@servletRequest" 
                                            shortDescBinding="deleteButtonText@objectSearchBean@servletRequest"
                                            name="event" 
                                            value="delete"
                                            renderedBinding="canDelete@objectSearchBean@servletRequest"/>
                            <uix:flowLayout renderedBinding="hasOptions@objectSearchBean@servletRequest">
                              <uix:spacer width="2"/>
                                <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@uixDBObjectBundle@servletRequest"
                                                renderedBinding="hasOperations@operationsChoiceBean@servletRequest"/>
                              <uix:spacer width="2"/>
                              <uix:choice name="optionChoice"
                                          shortDescBinding="ACTIONS@uixDBObjectBundle@servletRequest"
                                          selectedValueBinding="optionChoice@objectSearchBean@servletRequest"
                                          renderedBinding="hasOperations@operationsChoiceBean@servletRequest">
                                <uix:contents childDataBinding="operationsChoiceInfo@operationsChoiceBean@servletRequest">
                                  <uix:option textBinding="textKey"
                                              valueBinding="valueKey"/>
                                </uix:contents>
                              </uix:choice>
                              <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                                                shortDescBinding="GO@uixDBObjectBundle@servletRequest"
                                                renderedBinding="hasOperations@operationsChoiceBean@servletRequest"
                                                name="event" value="go"/>

                            </uix:flowLayout>
                          </uix:multipleSelection>
                        </uix:tableSelection>
                      </oem:table>
                      <uix:tip>
                        <uix:styledText styleClass="OraTipText"
                                        textBinding="tableRowSelectionTip@objectBean@servletRequest" />
                      </uix:tip>
                  </uix:stackLayout>
               </uix:case>  <%-- multiple selection --%>
               <uix:case name="false">
                 <oem:table name="objectsTwoDUIDataSource" formSubmitted="true" 
                            width="100%" beanKey="objectSearchBean" blockSize="25"
                            dataSourceProp="objectsTwoDUIDataSource"  
                            destination="/console/database/databaseObjectsSearch"
                            alternateTextBinding="UITableAlterText@objectBean@servletRequest"
                            summaryBinding="RESULTS@dbMsgs"
                            showAll="yes"
                            copyParams="target,type">
                  <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                                         selectedIndex="0">
                        <uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest" 
                                          shortDescBinding="EDIT@uixDBObjectBundle@servletRequest"
                                          name="event" 
                                          value="edit"
                                          renderedBinding="canEdit@objectSearchBean@servletRequest"/>
                        <uix:submitButton textBinding="VIEW_BUTTON@uixDBObjectBundle@servletRequest" 
                                          shortDescBinding="VIEW_BUTTON@uixDBObjectBundle@servletRequest"
                                          name="event" 
                                          value="view"
                                          renderedBinding="canView@objectSearchBean@servletRequest"/>
                        <uix:submitButton textBinding="deleteButtonText@objectSearchBean@servletRequest" 
                                          shortDescBinding="deleteButtonText@objectSearchBean@servletRequest"
                                          name="event" 
                                          value="delete"
                                          renderedBinding="canDelete@objectSearchBean@servletRequest"
                                          disabledBinding="disableDelete@objectSearchBean@servletRequest"/>
                      
                            <uix:flowLayout renderedBinding="hasOptions@objectSearchBean@servletRequest">
                              <uix:contents>
                                <uix:spacer width="2"/>
                                <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@uixDBObjectBundle@servletRequest"/>
                                <uix:spacer width="2"/>
                                <uix:choice name="optionChoice"
                                            shortDescBinding="ACTIONS@uixDBObjectBundle@servletRequest"
                                            selectedValueBinding="optionChoice@objectSearchBean@servletRequest">
                                  <uix:contents childDataBinding="operationsChoiceInfo@operationsChoiceBean@servletRequest">
                                    <uix:option textBinding="textKey"
                                                valueBinding="valueKey"/>
                                  </uix:contents>
                                </uix:choice>
                                <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                                                  shortDescBinding="GO@uixDBObjectBundle@servletRequest"
                                                  name="event" 
                                                  value="go"/>
                              </uix:contents>
                            </uix:flowLayout>
                        </uix:singleSelection>
                      </uix:tableSelection>
                    </oem:table>
                  </uix:case> 
                </uix:switcher> 
                </uix:case>

                <uix:case name="false"> <%-- cannot select --%>
                  <oem:table name="objectsTwoDUIDataSource" formSubmitted="true" 
                             width="100%" beanKey="objectSearchBean" blockSize="25"
                             dataSourceProp="objectsTwoDUIDataSource"  
                             destination="/console/database/databaseObjectsSearch"
                             summaryBinding="RESULTS@dbMsgs"
                             alternateTextBinding="NO_OBJECT_FOUND@uixDBObjectBundle@servletRequest" 
                             showAll="yes"
                             copyParams="target,type"/>
                </uix:case>
              </uix:switcher>
        
              <%-- tablespace space usage summary --%>
              <uix:switcher childNameBinding="tablespaceType@objectSearchBean@servletRequest">
                <uix:case name="true">
                <uix:tableLayout>
                  <uix:rowLayout width="100%">
                    <uix:spacer height="10"/> 
                  </uix:rowLayout>
                  <uix:rowLayout> 
                    <uix:cellFormat> 
                      <uix:labeledFieldLayout labelWidth="90%"> 
                        <uix:messagePrompt promptBinding="TOTAL_SIZE_GB@tbspMsgs"/>
                        <uix:styledText styleClass="OraDataText" 
                                      textBinding="tbspTotalSize@objectSearchBean@servletRequest"/>
                        <uix:messagePrompt promptBinding="TOTAL_USED_GB@tbspMsgs"/>
                        <uix:styledText styleClass="OraDataText" 
                                      textBinding="tbspTotalUsed@objectSearchBean@servletRequest"/>
                        <uix:messagePrompt promptBinding="TOTAL_FREE_GB@tbspMsgs"/>
                        <uix:styledText styleClass="OraDataText" 
                                      textBinding="tbspTotalFree@objectSearchBean@servletRequest"/>
                      </uix:labeledFieldLayout> 
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:spacer width="40"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right" vAlign="top"> 
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" width="30">
                          <uix:image source="/em/images/ok.gif"/>
                        </uix:cellFormat> 
                        <uix:cellFormat width="40">
                          <uix:messagePrompt promptBinding="ONLINE@dbMsgs"/>
                        </uix:cellFormat> 
                        <uix:cellFormat hAlign="right" width="30">
                          <uix:image source="/em/images/database/storage/off_line.gif"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:messagePrompt promptBinding="OFFLINE@dbMsgs"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right" width="30">
                          <uix:image source="/em/images/task.gif"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:messagePrompt promptBinding="READ_ONLY@dbMsgs"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                </uix:case> 
              </uix:switcher>

             
              <%-- archived log info --%>
              <uix:switcher childNameBinding="archiveLogType@objectSearchBean@servletRequest">
                <uix:case name="true">
                <uix:tableLayout width="100%">
                  <uix:rowLayout width="100%">
                    <uix:spacer height="10"/> 
                  </uix:rowLayout>
                  <uix:rowLayout> 
                    <uix:labeledFieldLayout renderedBinding="isDBVersionGTE9i@objectSearchBean@servletRequest"> 
                      <uix:messagePrompt promptBinding="LBL_OLDEST_NONE_BACKUP_ARCHLOG_DATE@archMsgs"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="oldestNonBackupArchLogDate@objectSearchBean@servletRequest"/>
                      <uix:messagePrompt promptBinding="LBL_TOTAL_NONE_BACKUP_ARCHLOG_FILE_SIZE@archMsgs"/>
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="totalNonBackupArchLogFileSize@objectSearchBean@servletRequest"/>
                    </uix:labeledFieldLayout> 
                  </uix:rowLayout>
                </uix:tableLayout>
                </uix:case> 
              </uix:switcher>
              <%-- end archive log info--%>

              
            </uix:tableLayout>

           </uix:header>
         </uix:header>
    <%-- END: TAB CONTENTS ends here --%>   
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
     <uix:switcher childNameBinding="flashbackFeaturesSupported@operationsChoiceBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="realObjectType@objectSearchBean@servletRequest">
            <uix:case name="TABLE">	  
	      <uix:submitButton formName="dbObjectsList" 
				                  textBinding="RECYCLE_BIN@uixDBObjectBundle@servletRequest" 
				                  shortDescBinding="RECYCLE_BIN@uixDBObjectBundle@servletRequest" 
				                  name="event" 
                          value="showRecycleBin"/>
	    </uix:case>
         </uix:switcher>
	</uix:case>
     </uix:switcher>
  </uix:pageButtonBar>
  </uix:pageButtons>
 
</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




