<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       dbClone_AddMaskScript.jsp
 *
 *      NOTES
 *       Launched from 'Add' on clone dest config page to add masking step. 
 *
 *
 * MODIFIED
 *    rpattabh   01/14/08 - bug 6744634 - fix ready to mask
 *    rpattabh   12/10/07 - Project 25671: Masking integration with Clone
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <!-- page contents -->
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="addMaskScriptPageTitle@dbCloneBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="disableComponentsOnLoad()">
    
      <uix:contents>
      
      <db:form name="dbCloneForm" destinationBinding="formDestination@dbCloneBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/dbclone/dbClone_AddMaskScript"/>
        <uix:formValue name="event" value="searchMask"/>
         
        <uix:pageLayout titleBinding="ADD_MASK_DEFINITION_HEADER@dbCloneBundle@servletRequest">
       
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="."/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/dbclone/errors.jspf" %>

          <uix:pageStatus>
            <%@ include file="/database/dbclone/destContext.jspf" %>
          </uix:pageStatus>

          <uix:separator/>

            <uix:rowLayout width="100%">
                 <uix:messagePrompt 
                      promptBinding="SELECT_SCRIPT_NAME_INSTRUCTION@dbCloneBundle@servletRequest"/>
            </uix:rowLayout>

              <uix:rowLayout width="100%">
                 <uix:spacer height="4"/>
              </uix:rowLayout>


<uix:rowLayout width="80%">
  <uix:cellFormat width="40%" hAlign="left" vAlign="top" headers=""> 
              <uix:labeledFieldLayout labelWidth="30%">
                <uix:contents>
                    <!-- Definition Name -->
                    <uix:messageTextInput                                     
                         promptBinding="SCRIPT_NAME@dbCloneBundle@servletRequest"
                         id="searchMaskScriptName"
                         name="searchMaskScriptName"
                         columns="40"
                         textBinding="searchMaskScriptName@dbCloneBean@servletRequest"/>

                    <!-- Search Button -->
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton 
                         name="event"
                         value="searchMask"
                         shortDescBinding="SEARCH@dbCloneBundle@servletRequest"
                         textBinding="SEARCH@dbCloneBundle@servletRequest"/>

                </uix:contents>
              </uix:labeledFieldLayout>
  </uix:cellFormat>
</uix:rowLayout>

<uix:spacer width="6"/>

              <uix:separator/>              
 
              <uix:rowLayout>
                 <uix:spacer height="4"/>
              </uix:rowLayout>

<!-- Search Mask Results Table -->
<uix:stackLayout>
  <uix:contents>
    <uix:table 
         summaryBinding="SELECT_SCRIPTS@dbCloneBundle@servletRequest"
         partialRenderMode="self"
         id="searchMaskTable"
         name="searchMaskTable"
         alternateTextBinding="NO_SCRIPTS_FOUND@dbCloneBundle@servletRequest"
         formSubmitted="true"
         width="100%"
         valueBinding="searchMaskValue@dbCloneBean@servletRequest"
         maxValueBinding="searchMaskMaxValue@dbCloneBean@servletRequest"
         blockSize="25"
         tableDataBinding="searchMask@dbCloneBean@servletRequest"
         columnHeaderDataBinding="searchMaskHeaders@dbCloneBean@servletRequest" 
         columnFormatsBinding="searchMaskFormats@dbCloneBean@servletRequest">
    
         <uix:tableFormat tableBanding="rowBanding"/>
           <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text"
                                 sortableBinding="sort"/>
           </uix:columnHeaderStamp>
           <uix:contents>
             <uix:styledText textBinding="SCRIPT_NAME"/>
             <uix:styledText textBinding="SCRIPT_MODIFY_DATE"/>
             <uix:styledText textBinding="HAS_MASK_SCRIPT"/>
           </uix:contents>
           <uix:tableSelection>
             <uix:multipleSelection
                  shortDescBinding="SELECT@dbCloneBundle@servletRequest"
                  selectedBinding="selected"
                  disabledBinding="disabled">
             </uix:multipleSelection>
           </uix:tableSelection>
    </uix:table>
  </uix:contents>
</uix:stackLayout>
<!-- End Search Mask Results Table -->

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                     shortDescBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"
                     name="event"
                     value="addMaskCancel"
                     textBinding="CANCEL_BUTTON_TEXT@dbCloneBundle@servletRequest"/>
                <uix:submitButton
                     shortDescBinding="CONTINUE_BUTTON@dbCloneBundle@servletRequest"
                     name="event"
                     value="bulkAdd"
                     textBinding="CONTINUE_BUTTON@dbCloneBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
